/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.types.Control;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class SearchResultReference {
    private List<Control> controls;
    private List<String> referralURLs;

    public SearchResultReference(String referralURL) {
        this.referralURLs = new ArrayList<String>(1);
        this.referralURLs.add(referralURL);
        this.controls = new ArrayList<Control>(0);
    }

    public SearchResultReference(List<String> referralURLs) {
        this.referralURLs = referralURLs == null ? new ArrayList<String>() : referralURLs;
        this.controls = new ArrayList<Control>(0);
    }

    public SearchResultReference(List<String> referralURLs, List<Control> controls) {
        this.referralURLs = referralURLs == null ? new ArrayList<String>() : referralURLs;
        this.controls = controls == null ? new ArrayList<Control>(0) : controls;
    }

    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    public String getReferralURLString() {
        if (this.referralURLs == null || this.referralURLs.isEmpty()) {
            return "";
        }
        if (this.referralURLs.size() == 1) {
            return this.referralURLs.get(0);
        }
        Iterator<String> iterator = this.referralURLs.iterator();
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ ");
        buffer.append(iterator.next());
        while (iterator.hasNext()) {
            buffer.append(", ");
            buffer.append(iterator.next());
        }
        buffer.append(" }");
        return buffer.toString();
    }

    public List<Control> getControls() {
        return this.controls;
    }
}

