/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.ChangeOperationType;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.Validator;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class AddChangeRecordEntry
extends ChangeRecordEntry {
    private final List<Attribute> attributes;

    public AddChangeRecordEntry(DN dn, Map<AttributeType, List<Attribute>> attributes) {
        super(dn);
        Validator.ensureNotNull(attributes);
        this.attributes = new ArrayList<Attribute>(attributes.size());
        for (List<Attribute> list : attributes.values()) {
            for (Attribute a : list) {
                this.attributes.add(a);
            }
        }
    }

    @Override
    public ChangeOperationType getChangeOperationType() {
        return ChangeOperationType.ADD;
    }

    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("AddChangeRecordEntry(dn=\"");
        buffer.append(String.valueOf(this.getDN()));
        buffer.append("\", attrs={");
        Iterator<Attribute> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next().getName());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
        return buffer.toString();
    }
}

