/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.opends.server.api.DirectoryThread;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class PasswordReader
extends DirectoryThread {
    private volatile boolean keepLooping;

    private PasswordReader() {
        super("Password Reader Thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void run() {
        Thread currentThread = Thread.currentThread();
        int initialPriority = currentThread.getPriority();
        try {
            try {
                currentThread.setPriority(10);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.keepLooping = true;
            while (this.keepLooping) {
                System.out.print("\b ");
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ie) {
                    currentThread.interrupt();
                    try {
                        currentThread.setPriority(initialPriority);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
            }
        }
        finally {
            try {
                currentThread.setPriority(initialPriority);
            }
            catch (Exception exception) {}
        }
    }

    private void stopLooping() {
        this.keepLooping = false;
    }

    public static char[] readPassword() {
        try {
            char[] password;
            Method consoleMethod = System.class.getDeclaredMethod("console", new Class[0]);
            if (consoleMethod != null && (password = PasswordReader.readPasswordUsingConsole(consoleMethod)) != null) {
                return password;
            }
        }
        catch (Exception e) {
            return PasswordReader.readPasswordUsingBackspaces();
        }
        return PasswordReader.readPasswordUsingBackspaces();
    }

    private static char[] readPasswordUsingConsole(Method consoleMethod) throws Exception {
        Object consoleObject = consoleMethod.invoke(null, new Object[0]);
        Method passwordMethod = consoleObject.getClass().getDeclaredMethod("readPassword", new Class[0]);
        return (char[])passwordMethod.invoke(consoleObject, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static char[] readPasswordUsingBackspaces() {
        pwBuffer = new char[100];
        pos = 0;
        backspaceThread = new PasswordReader();
        backspaceThread.start();
        try {
            while (true) {
                if ((charRead = System.in.read()) == -1 || charRead == 10) {
                    pwChars = new char[pos];
                    if (0 < pos) {
                        System.arraycopy(pwBuffer, 0, pwChars, 0, pos);
                        Arrays.fill(pwBuffer, '\u0000');
                    }
                    var5_5 = pwChars;
                    return var5_5;
                }
                if (charRead != 13) ** GOTO lbl39
                char2 = System.in.read();
                if (char2 == 10) {
                    if (pos == 0) {
                        var6_9 = null;
                        return var6_9;
                    }
                    pwChars = new char[pos];
                    System.arraycopy(pwBuffer, 0, pwChars, 0, pos);
                    Arrays.fill(pwBuffer, '\u0000');
                    var6_9 = pwChars;
                    return var6_9;
                }
                pwBuffer[pos++] = (char)charRead;
                if (pos >= pwBuffer.length) {
                    newBuffer = new char[pwBuffer.length + 100];
                    System.arraycopy(pwBuffer, 0, newBuffer, 0, pwBuffer.length);
                    Arrays.fill(pwBuffer, '\u0000');
                    pwBuffer = newBuffer;
                }
                pwBuffer[pos++] = (char)char2;
                if (pos < pwBuffer.length) continue;
                newBuffer = new char[pwBuffer.length + 100];
                System.arraycopy(pwBuffer, 0, newBuffer, 0, pwBuffer.length);
                Arrays.fill(pwBuffer, '\u0000');
                pwBuffer = newBuffer;
                continue;
lbl39:
                // 1 sources

                pwBuffer[pos++] = (char)charRead;
                if (pos < pwBuffer.length) continue;
                newBuffer = new char[pwBuffer.length + 100];
                System.arraycopy(pwBuffer, 0, newBuffer, 0, pwBuffer.length);
                Arrays.fill(pwBuffer, '\u0000');
                pwBuffer = newBuffer;
                continue;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                var5_8 = null;
                return var5_8;
            }
        }
        finally {
            backspaceThread.stopLooping();
        }
    }
}

