/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.ast.QuantifiableTerm;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public class BackReference
extends QuantifiableTerm {
    private final int[] groupNumbers;

    BackReference(int[] referencedGroupNumbers) {
        this.groupNumbers = referencedGroupNumbers;
    }

    private BackReference(BackReference copy) {
        super(copy);
        this.groupNumbers = copy.groupNumbers;
    }

    @Override
    public BackReference copy(RegexAST ast) {
        return ast.register(new BackReference(this));
    }

    @Override
    public BackReference copyRecursive(RegexAST ast, CompilationBuffer compilationBuffer) {
        return this.copy(ast);
    }

    public int[] getGroupNumbers() {
        return this.groupNumbers;
    }

    public boolean isNestedBackReference() {
        return this.isFlagSet(64);
    }

    public void setNestedBackReference() {
        this.setFlag(64, true);
    }

    public boolean isForwardReference() {
        return this.isFlagSet(128);
    }

    public void setForwardReference() {
        this.setFlag(128, true);
    }

    public boolean isNestedOrForwardReference() {
        return this.isFlagSet(448);
    }

    public void setNestedOrForwardReference() {
        this.setFlag(256, true);
    }

    public boolean isIgnoreCaseReference() {
        return this.isFlagSet(512);
    }

    public void setIgnoreCaseReference() {
        this.setFlag(512, true);
    }

    public boolean isIgnoreCaseReferenceAltMode() {
        return this.isFlagSet(1024);
    }

    public void setIgnoreCaseReferenceAltMode() {
        this.setFlag(1024, true);
    }

    @Override
    public boolean isUnrollingCandidate() {
        return this.hasQuantifier() && this.getQuantifier().isUnrollTrivial();
    }

    @Override
    public boolean equalsSemantic(RegexASTNode obj, boolean ignoreQuantifier) {
        return obj instanceof BackReference && Arrays.equals(((BackReference)obj).groupNumbers, this.groupNumbers) && (ignoreQuantifier || this.quantifierEquals((BackReference)obj));
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (this.groupNumbers.length == 1) {
            return "\\" + this.groupNumbers[0] + this.quantifierToString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\\k<");
        sb.append(this.groupNumbers[0]);
        for (int i = 1; i < this.groupNumbers.length; ++i) {
            sb.append(",");
            sb.append(this.groupNumbers[i]);
        }
        sb.append(">");
        sb.append(this.quantifierToString());
        return sb.toString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return this.toJson("BackReference").append(Json.prop("groupNumbers", Arrays.stream(this.groupNumbers).mapToObj(x -> Json.val(x))));
    }
}

