/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.DataViewPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.builtins.JSDataViewObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.EnumSet;

public final class DataViewPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<DataViewPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new DataViewPrototypeBuiltins();

    protected DataViewPrototypeBuiltins() {
        super(JSDataView.PROTOTYPE_NAME, DataViewPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, DataViewPrototype builtinEnum) {
        switch (builtinEnum) {
            case getBigInt64: 
            case getBigUint64: 
            case getFloat32: 
            case getFloat64: 
            case getInt16: 
            case getInt32: 
            case getInt8: 
            case getUint16: 
            case getUint32: 
            case getUint8: {
                return DataViewPrototypeBuiltinsFactory.DataViewGetNodeGen.create(context, builtin, DataViewPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case setBigInt64: 
            case setBigUint64: 
            case setFloat32: 
            case setFloat64: 
            case setInt16: 
            case setInt32: 
            case setInt8: 
            case setUint16: 
            case setUint32: 
            case setUint8: {
                return DataViewPrototypeBuiltinsFactory.DataViewSetNodeGen.create(context, builtin, DataViewPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case buffer: 
            case byteLength: 
            case byteOffset: {
                return DataViewPrototypeBuiltinsFactory.DataViewGetterNodeGen.create(context, builtin, builtinEnum, DataViewPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum DataViewPrototype implements BuiltinEnum<DataViewPrototype>
    {
        getBigInt64(1),
        getBigUint64(1),
        getFloat32(1),
        getFloat64(1),
        getInt8(1),
        getInt16(1),
        getInt32(1),
        getUint8(1),
        getUint16(1),
        getUint32(1),
        setBigInt64(2),
        setBigUint64(2),
        setFloat32(2),
        setFloat64(2),
        setInt8(2),
        setInt16(2),
        setInt32(2),
        setUint8(2),
        setUint16(2),
        setUint32(2),
        buffer(0),
        byteLength(0),
        byteOffset(0);

        private final int length;

        private DataViewPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(buffer, byteLength, byteOffset).contains(this);
        }
    }

    public static abstract class DataViewGetNode
    extends DataViewAccessNode {
        public DataViewGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final Object doDataView(JSDataViewObject dataView, Object byteOffset, Object littleEndian, @Cached JSToIndexNode toIndexNode, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedExactClassProfile bufferTypeProfile, @Cached InlinedExactClassProfile arrayTypeProfile) {
            long getIndex = toIndexNode.executeLong(byteOffset);
            boolean isLittleEndian = this.factory.getBytesPerElement() == 1 || toBooleanNode.executeBoolean(this, littleEndian);
            JSArrayBufferObject buffer = (JSArrayBufferObject)((Object)bufferTypeProfile.profile((Node)this, (Object)JSDataView.getArrayBuffer((Object)dataView)));
            this.ensureNotDetached(buffer, errorBranch);
            int bufferIndex = this.getBufferIndex(dataView, getIndex, errorBranch);
            boolean isInteropBuffer = JSArrayBuffer.isJSInteropArrayBuffer((Object)buffer);
            TypedArray strategy = (TypedArray)arrayTypeProfile.profile((Node)this, (Object)this.factory.createArrayType(JSArrayBuffer.isJSDirectOrSharedArrayBuffer((Object)buffer), true, isInteropBuffer));
            return strategy.getBufferElement(buffer, bufferIndex, isLittleEndian, isInteropBuffer ? this.getInterop() : null);
        }

        @Specialization(guards={"!isJSDataView(thisObj)"})
        protected JSDynamicObject doIncompatibleReceiver(Object thisObj, Object byteOffset, Object littleEndian) {
            throw Errors.createTypeErrorNotADataView();
        }
    }

    public static abstract class DataViewSetNode
    extends DataViewAccessNode {
        @Node.Child
        private JSToBigIntNode toBigIntNode;
        @Node.Child
        private JSToDoubleNode toDoubleNode;
        @Node.Child
        private JSToInt32Node toInt32Node;

        public DataViewSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            if (this.factory.isBigInt()) {
                this.toBigIntNode = JSToBigIntNode.create();
            } else if (this.factory.isFloat()) {
                this.toDoubleNode = JSToDoubleNode.create();
            } else {
                this.toInt32Node = JSToInt32Node.create();
            }
        }

        @Specialization
        protected Object doDataView(JSDataViewObject dataView, Object byteOffset, Object value, Object littleEndian, @Cached JSToIndexNode toIndexNode, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedExactClassProfile bufferTypeProfile, @Cached InlinedExactClassProfile arrayTypeProfile) {
            long getIndex = toIndexNode.executeLong(byteOffset);
            Comparable<BigInt> numberValue = switch (this.factory) {
                case TypedArrayFactory.BigInt64Array, TypedArrayFactory.BigUint64Array -> this.toBigIntNode.executeBigInteger(value);
                case TypedArrayFactory.Float64Array, TypedArrayFactory.Float32Array -> Double.valueOf(this.toDoubleNode.executeDouble(value));
                default -> Integer.valueOf(this.toInt32Node.executeInt(value));
            };
            boolean isLittleEndian = this.factory.getBytesPerElement() == 1 || toBooleanNode.executeBoolean(this, littleEndian);
            JSArrayBufferObject buffer = (JSArrayBufferObject)((Object)bufferTypeProfile.profile((Node)this, (Object)JSDataView.getArrayBuffer((Object)dataView)));
            this.ensureNotDetached(buffer, errorBranch);
            int bufferIndex = this.getBufferIndex(dataView, getIndex, errorBranch);
            boolean isInteropBuffer = JSArrayBuffer.isJSInteropArrayBuffer((Object)buffer);
            TypedArray strategy = (TypedArray)arrayTypeProfile.profile((Node)this, (Object)this.factory.createArrayType(JSArrayBuffer.isJSDirectOrSharedArrayBuffer((Object)buffer), true, isInteropBuffer));
            strategy.setBufferElement(buffer, bufferIndex, isLittleEndian, numberValue, isInteropBuffer ? this.getInterop() : null);
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSDataView(thisObj)"})
        protected JSDynamicObject doIncompatibleReceiver(Object thisObj, Object byteOffset, Object value, Object littleEndian) {
            throw Errors.createTypeErrorNotADataView();
        }
    }

    @ImportStatic(value={JSDataView.class})
    public static abstract class DataViewGetterNode
    extends JSBuiltinNode {
        private final DataViewPrototype getter;

        public DataViewGetterNode(JSContext context, JSBuiltin builtin, DataViewPrototype getter) {
            super(context, builtin);
            this.getter = getter;
        }

        @Specialization
        protected final Object doDataView(JSDataViewObject dataView, @Cached InlinedBranchProfile errorBranch) {
            JSArrayBufferObject arrayBuffer = JSDataView.getArrayBuffer((Object)dataView);
            switch (this.getter) {
                case buffer: {
                    return arrayBuffer;
                }
                case byteLength: {
                    if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
                        errorBranch.enter((Node)this);
                        throw Errors.createTypeErrorDetachedBuffer();
                    }
                    return JSDataView.typedArrayGetLength((Object)dataView);
                }
                case byteOffset: {
                    if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
                        errorBranch.enter((Node)this);
                        throw Errors.createTypeErrorDetachedBuffer();
                    }
                    return JSDataView.typedArrayGetOffset((Object)dataView);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSDataView(thisObj)"})
        protected Object doIncompatibleReceiver(Object thisObj) {
            throw Errors.createTypeErrorNotADataView();
        }
    }

    @ImportStatic(value={JSDataView.class})
    public static abstract class DataViewAccessNode
    extends JSBuiltinNode {
        protected final TypedArrayFactory factory;
        @Node.Child
        private InteropLibrary interopLibrary;

        public DataViewAccessNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.factory = DataViewAccessNode.typedArrayFactoryFromType(Strings.lazySubstring(builtin.getName(), 3));
        }

        private static TypedArrayFactory typedArrayFactoryFromType(TruffleString type) {
            for (TypedArrayFactory factory : TypedArray.factories()) {
                if (!Strings.startsWith(factory.getName(), type)) continue;
                return factory;
            }
            throw new IllegalArgumentException(Strings.toJavaString(type));
        }

        protected final InteropLibrary getInterop() {
            InteropLibrary lib = this.interopLibrary;
            if (lib == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.interopLibrary = lib = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(5)));
            }
            return lib;
        }

        protected final void ensureNotDetached(JSArrayBufferObject buffer, InlinedBranchProfile errorBranch) {
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(buffer)) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorDetachedBuffer();
            }
        }

        protected final int getBufferIndex(JSDataViewObject dataView, long getIndex, InlinedBranchProfile errorBranch) {
            int viewLength = JSDataView.typedArrayGetLength((Object)dataView);
            int elementSize = this.factory.getBytesPerElement();
            if (getIndex + (long)elementSize > (long)viewLength) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeError("index + elementSize > viewLength");
            }
            int viewOffset = JSDataView.typedArrayGetOffset((Object)dataView);
            assert (getIndex + (long)viewOffset <= Integer.MAX_VALUE);
            int bufferIndex = (int)(getIndex + (long)viewOffset);
            return bufferIndex;
        }
    }
}

