/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.TruffleOptionDescriptors;
import com.oracle.truffle.js.runtime.JSContextOptionsOptionDescriptors;
import com.oracle.truffle.js.runtime.JSParserOptions;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.util.UTS35Validator;
import java.nio.charset.Charset;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.SandboxPolicy;

public final class JSContextOptions {
    public static final String JS_OPTION_PREFIX = "js.";
    @CompilerDirectives.CompilationFinal
    private JSParserOptions parserOptions;
    @CompilerDirectives.CompilationFinal
    private OptionValues optionValues;
    public static final String ECMASCRIPT_VERSION_LATEST = "latest";
    public static final String ECMASCRIPT_VERSION_STAGING = "staging";
    public static final String ECMASCRIPT_VERSION_NAME = "js.ecmascript-version";
    @Option(name="js.ecmascript-version", category=OptionCategory.USER, stability=OptionStability.STABLE, sandbox=SandboxPolicy.UNTRUSTED, usageSyntax="latest|staging|[5, 14]|[2015, 2023]", help="ECMAScript version to be compatible with. Default is 'latest' (latest supported version), staged features are in 'staging'.")
    public static final OptionKey<Integer> ECMASCRIPT_VERSION = new OptionKey((Object)14, new OptionType("ecmascript-version", (Function)new Function<String, Integer>(){

        @Override
        public Integer apply(String in) {
            if (JSContextOptions.ECMASCRIPT_VERSION_LATEST.equals(in)) {
                return 14;
            }
            if (JSContextOptions.ECMASCRIPT_VERSION_STAGING.equals(in)) {
                return 15;
            }
            try {
                int minVersion = 5;
                int maxVersion = 14;
                int minYearVersion = 2015;
                int maxYearVersion = 2023;
                int version = Integer.parseInt(in);
                if (2015 <= version && version <= 2023) {
                    version -= 2009;
                }
                if (version < 5 || version > 14) {
                    throw new IllegalArgumentException("Supported values are 5 to 14 or 2015 to 2023.");
                }
                return version;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }));
    @CompilerDirectives.CompilationFinal
    private int ecmascriptVersion;
    public static final String ANNEX_B_NAME = "js.annex-b";
    @Option(name="js.annex-b", category=OptionCategory.USER, help="Enable ECMAScript Annex B features.")
    public static final OptionKey<Boolean> ANNEX_B = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean annexB;
    public static final String SYNTAX_EXTENSIONS_NAME = "js.syntax-extensions";
    @Option(name="js.syntax-extensions", category=OptionCategory.USER, help="Enable Nashorn syntax extensions.")
    public static final OptionKey<Boolean> SYNTAX_EXTENSIONS = new OptionKey((Object)false);
    public static final String SCRIPTING_NAME = "js.scripting";
    @Option(name="js.scripting", category=OptionCategory.USER, help="Enable scripting features (Nashorn compatibility option).")
    public static final OptionKey<Boolean> SCRIPTING = new OptionKey((Object)false);
    public static final String SHEBANG_NAME = "js.shebang";
    @Option(name="js.shebang", category=OptionCategory.USER, help="Allow parsing files starting with #!.")
    public static final OptionKey<Boolean> SHEBANG = new OptionKey((Object)false);
    public static final String STRICT_NAME = "js.strict";
    @Option(name="js.strict", category=OptionCategory.USER, stability=OptionStability.STABLE, sandbox=SandboxPolicy.UNTRUSTED, help="Enforce strict mode.")
    public static final OptionKey<Boolean> STRICT = new OptionKey((Object)false);
    public static final String CONST_AS_VAR_NAME = "js.const-as-var";
    @Option(name="js.const-as-var", category=OptionCategory.EXPERT, help="Parse const declarations as a var (legacy compatibility option).")
    public static final OptionKey<Boolean> CONST_AS_VAR = new OptionKey((Object)false);
    public static final String FUNCTION_STATEMENT_ERROR_NAME = "js.function-statement-error";
    @Option(name="js.function-statement-error", category=OptionCategory.EXPERT, help="Treat hoistable function statements in blocks as an error (in ES5 mode).")
    public static final OptionKey<Boolean> FUNCTION_STATEMENT_ERROR = new OptionKey((Object)false);
    public static final String INTL_402_NAME = "js.intl-402";
    @Option(name="js.intl-402", category=OptionCategory.USER, stability=OptionStability.STABLE, help="Enable ECMAScript Internationalization API.")
    public static final OptionKey<Boolean> INTL_402 = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean intl402;
    public static final String REGEXP_MATCH_INDICES_NAME = "js.regexp-match-indices";
    @Option(name="js.regexp-match-indices", category=OptionCategory.USER, help="Enable RegExp Match Indices property.", deprecated=true)
    public static final OptionKey<Boolean> REGEXP_MATCH_INDICES = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean regexpMatchIndices;
    public static final String REGEXP_UNICODE_SETS_NAME = "js.regexp-unicode-sets";
    @Option(name="js.regexp-unicode-sets", category=OptionCategory.USER, help="Enable RegExp Unicode sets proposal (v flag).")
    public static final OptionKey<Boolean> REGEXP_UNICODE_SETS = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean regexpUnicodeSets;
    public static final String REGEXP_STATIC_RESULT_NAME = "js.regexp-static-result";
    @Option(name="js.regexp-static-result", category=OptionCategory.USER, help="Provide last RegExp match in RegExp global var, e.g. RegExp.$1.")
    public static final OptionKey<Boolean> REGEXP_STATIC_RESULT = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean regexpStaticResult;
    public static final String SHARED_ARRAY_BUFFER_NAME = "js.shared-array-buffer";
    @Option(name="js.shared-array-buffer", category=OptionCategory.USER, help="Enable ECMAScript SharedArrayBuffer.")
    public static final OptionKey<Boolean> SHARED_ARRAY_BUFFER = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean sharedArrayBuffer;
    public static final String ATOMICS_NAME = "js.atomics";
    @Option(name="js.atomics", category=OptionCategory.USER, help="Enable ECMAScript Atomics.")
    public static final OptionKey<Boolean> ATOMICS = new OptionKey((Object)true);
    public static final String V8_COMPATIBILITY_MODE_NAME = "js.v8-compat";
    @Option(name="js.v8-compat", category=OptionCategory.USER, help="Provide compatibility with the Google V8 engine.")
    public static final OptionKey<Boolean> V8_COMPATIBILITY_MODE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean v8CompatibilityMode;
    public static final String V8_REALM_BUILTIN_NAME = "js.v8-realm-builtin";
    @Option(name="js.v8-realm-builtin", category=OptionCategory.INTERNAL, help="Provide Realm builtin compatible with V8's d8 shell.")
    public static final OptionKey<Boolean> V8_REALM_BUILTIN = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean v8RealmBuiltin;
    public static final String NASHORN_COMPATIBILITY_MODE_NAME = "js.nashorn-compat";
    @Option(name="js.nashorn-compat", category=OptionCategory.USER, help="Provide compatibility with the OpenJDK Nashorn engine. Do not use with untrusted code.")
    public static final OptionKey<Boolean> NASHORN_COMPATIBILITY_MODE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean nashornCompatibilityMode;
    public static final String STACK_TRACE_LIMIT_NAME = "js.stack-trace-limit";
    @Option(name="js.stack-trace-limit", category=OptionCategory.USER, usageSyntax="[0, inf)", help="Number of stack frames to capture.")
    public static final OptionKey<Integer> STACK_TRACE_LIMIT = new OptionKey((Object)10);
    @CompilerDirectives.CompilationFinal
    private int stackTraceLimit;
    public static final String DEBUG_BUILTIN_NAME = "js.debug-builtin";
    @Option(name="js.debug-builtin", category=OptionCategory.INTERNAL, help="Provide a non-API Debug builtin. Behaviour will likely change. Don't depend on this in production code.")
    public static final OptionKey<Boolean> DEBUG_BUILTIN = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean debug;
    public static final String DIRECT_BYTE_BUFFER_NAME = "js.direct-byte-buffer";
    @Option(name="js.direct-byte-buffer", category=OptionCategory.USER, help="Use direct (off-heap) byte buffer for typed arrays.")
    public static final OptionKey<Boolean> DIRECT_BYTE_BUFFER = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean directByteBuffer;
    public static final String PARSE_ONLY_NAME = "js.parse-only";
    @Option(name="js.parse-only", category=OptionCategory.INTERNAL, help="Only parse source code, do not run it.")
    public static final OptionKey<Boolean> PARSE_ONLY = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean parseOnly;
    public static final String TIME_ZONE_NAME = "js.timezone";
    @Option(name="js.timezone", category=OptionCategory.USER, usageSyntax="<TimeZoneID>", help="Set custom time zone ID.")
    public static final OptionKey<String> TIME_ZONE = new OptionKey((Object)"", new OptionType("ZoneId", (Function)new Function<String, String>(){

        @Override
        public String apply(String tz) {
            if (tz.isEmpty()) {
                return "";
            }
            try {
                return ZoneId.of(tz, ZoneId.SHORT_IDS).getId();
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }));
    public static final String ZONE_RULES_BASED_TIME_ZONES_NAME = "js.zone-rules-based-time-zones";
    @Option(name="js.zone-rules-based-time-zones", category=OptionCategory.EXPERT, help="Use ZoneRulesProvider instead of time-zone data from ICU4J.")
    public static final OptionKey<Boolean> ZONE_RULES_BASED_TIME_ZONES = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean zoneRulesBasedTimeZones;
    public static final String TIMER_RESOLUTION_NAME = "js.timer-resolution";
    @Option(name="js.timer-resolution", category=OptionCategory.USER, stability=OptionStability.STABLE, sandbox=SandboxPolicy.UNTRUSTED, usageSyntax="<nanoseconds>", help="Resolution of timers (performance.now() and Date built-ins) in nanoseconds. Fuzzy time is used when set to 0.")
    public static final OptionKey<Long> TIMER_RESOLUTION = new OptionKey((Object)1000000L);
    @CompilerDirectives.CompilationFinal
    private long timerResolution;
    public static final String AGENT_CAN_BLOCK_NAME = "js.agent-can-block";
    @Option(name="js.agent-can-block", category=OptionCategory.INTERNAL, help="Determines whether agents can block or not.")
    public static final OptionKey<Boolean> AGENT_CAN_BLOCK = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean agentCanBlock;
    public static final String JAVA_PACKAGE_GLOBALS_NAME = "js.java-package-globals";
    @Option(name="js.java-package-globals", category=OptionCategory.USER, help="Provide Java package globals: Packages, java, javafx, javax, com, org, edu.")
    public static final OptionKey<Boolean> JAVA_PACKAGE_GLOBALS = new OptionKey((Object)true);
    public static final String GLOBAL_PROPERTY_NAME = "js.global-property";
    @Option(name="js.global-property", category=OptionCategory.USER, help="Provide 'global' global property.")
    public static final OptionKey<Boolean> GLOBAL_PROPERTY = new OptionKey((Object)false);
    public static final String GLOBAL_ARGUMENTS_NAME = "js.global-arguments";
    @Option(name="js.global-arguments", category=OptionCategory.USER, help="Provide 'arguments' global property.")
    public static final OptionKey<Boolean> GLOBAL_ARGUMENTS = new OptionKey((Object)true);
    public static final String CONSOLE_NAME = "js.console";
    @Option(name="js.console", category=OptionCategory.USER, stability=OptionStability.STABLE, sandbox=SandboxPolicy.UNTRUSTED, help="Provide 'console' global property.")
    public static final OptionKey<Boolean> CONSOLE = new OptionKey((Object)true);
    public static final String PERFORMANCE_NAME = "js.performance";
    @Option(name="js.performance", category=OptionCategory.USER, help="Provide 'performance' global property.")
    public static final OptionKey<Boolean> PERFORMANCE = new OptionKey((Object)false);
    public static final String SHELL_NAME = "js.shell";
    @Option(name="js.shell", category=OptionCategory.USER, help="Provide global functions for js shell.")
    public static final OptionKey<Boolean> SHELL = new OptionKey((Object)false);
    public static final String PRINT_NAME = "js.print";
    @Option(name="js.print", category=OptionCategory.USER, stability=OptionStability.STABLE, sandbox=SandboxPolicy.UNTRUSTED, help="Provide 'print' global function.")
    public static final OptionKey<Boolean> PRINT = new OptionKey((Object)true);
    public static final String PRINT_NO_NEWLINE_NAME = "js.print-no-newline";
    @Option(name="js.print-no-newline", category=OptionCategory.USER, help="Print function will not print new line char.")
    public static final OptionKey<Boolean> PRINT_NO_NEWLINE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean printNoNewline;
    public static final String LOAD_NAME = "js.load";
    @Option(name="js.load", category=OptionCategory.USER, stability=OptionStability.STABLE, sandbox=SandboxPolicy.UNTRUSTED, help="Provide 'load' global function.")
    public static final OptionKey<Boolean> LOAD = new OptionKey((Object)true);
    public static final String LOAD_FROM_URL_NAME = "js.load-from-url";
    @Option(name="js.load-from-url", category=OptionCategory.USER, help="Allow 'load' to access URLs. Do not use with untrusted code.")
    public static final OptionKey<Boolean> LOAD_FROM_URL = new OptionKey((Object)false);
    public static final String LOAD_FROM_CLASSPATH_NAME = "js.load-from-classpath";
    @Option(name="js.load-from-classpath", category=OptionCategory.USER, help="Allow 'load' to access 'classpath:' URLs. Do not use with untrusted code.")
    public static final OptionKey<Boolean> LOAD_FROM_CLASSPATH = new OptionKey((Object)false);
    public static final String COMMONJS_REQUIRE_NAME = "js.commonjs-require";
    @Option(name="js.commonjs-require", category=OptionCategory.USER, help="Enable CommonJS require emulation.")
    public static final OptionKey<Boolean> COMMONJS_REQUIRE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean commonJSRequire;
    public static final String COMMONJS_REQUIRE_CWD_NAME = "js.commonjs-require-cwd";
    @Option(name="js.commonjs-require-cwd", category=OptionCategory.USER, usageSyntax="<path>", help="CommonJS default current working directory.")
    public static final OptionKey<String> COMMONJS_REQUIRE_CWD = new OptionKey((Object)"");
    public static final String COMMONJS_CORE_MODULES_REPLACEMENTS_NAME = "js.commonjs-core-modules-replacements";
    @Option(name="js.commonjs-core-modules-replacements", category=OptionCategory.USER, usageSyntax="<name>:<module>,...", help="Npm packages used to replace global Node.js builtins.")
    public static final OptionKey<Map<String, String>> COMMONJS_CORE_MODULES_REPLACEMENTS = new OptionKey(Collections.emptyMap(), new OptionType("commonjs-require-globals", (Function)new Function<String, Map<String, String>>(){

        @Override
        public Map<String, String> apply(String value) {
            String[] options;
            if (value.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (String s : options = value.split(",")) {
                String val;
                String key;
                block6: {
                    block5: {
                        String[] builtin = s.split(":", 2);
                        if (builtin.length != 2) break block5;
                        key = builtin[0];
                        val = builtin[1];
                        if (!key.isEmpty() && !val.isEmpty()) break block6;
                    }
                    throw new IllegalArgumentException("Unexpected builtin arguments: " + s);
                }
                map.put(key, val);
            }
            return map;
        }
    }));
    public static final String GRAAL_BUILTIN_NAME = "js.graal-builtin";
    @Option(name="js.graal-builtin", category=OptionCategory.USER, stability=OptionStability.STABLE, sandbox=SandboxPolicy.UNTRUSTED, help="Provide 'Graal' global property.")
    public static final OptionKey<Boolean> GRAAL_BUILTIN = new OptionKey((Object)true);
    public static final String POLYGLOT_BUILTIN_NAME = "js.polyglot-builtin";
    @Option(name="js.polyglot-builtin", category=OptionCategory.USER, help="Provide 'Polyglot' global property.", deprecated=true)
    public static final OptionKey<Boolean> POLYGLOT_BUILTIN = new OptionKey((Object)true);
    public static final String POLYGLOT_EVALFILE_NAME = "js.polyglot-evalfile";
    @Option(name="js.polyglot-evalfile", category=OptionCategory.USER, help="Provide 'Polyglot.evalFile' function.")
    public static final OptionKey<Boolean> POLYGLOT_EVALFILE = new OptionKey((Object)true);
    public static final String AWAIT_OPTIMIZATION_NAME = "js.await-optimization";
    @Option(name="js.await-optimization", category=OptionCategory.INTERNAL, help="Use PromiseResolve for Await.")
    public static final OptionKey<Boolean> AWAIT_OPTIMIZATION = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean awaitOptimization;
    public static final String DISABLE_EVAL_NAME = "js.disable-eval";
    @Option(name="js.disable-eval", category=OptionCategory.EXPERT, deprecated=true, deprecationMessage="Use js.allow-eval=false instead.", help="Disallow code generation from strings, e.g. using eval().")
    public static final OptionKey<Boolean> DISABLE_EVAL = new OptionKey((Object)false);
    public static final String ALLOW_EVAL_NAME = "js.allow-eval";
    @Option(name="js.allow-eval", category=OptionCategory.EXPERT, stability=OptionStability.STABLE, sandbox=SandboxPolicy.UNTRUSTED, help="Allow or disallow code generation from strings, e.g. using eval().")
    public static final OptionKey<Boolean> ALLOW_EVAL = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean allowEval;
    public static final String DISABLE_WITH_NAME = "js.disable-with";
    @Option(name="js.disable-with", category=OptionCategory.EXPERT, help="User code is not allowed to use the 'with' statement.")
    public static final OptionKey<Boolean> DISABLE_WITH = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean disableWith;
    public static final String BIGINT_NAME = "js.bigint";
    @Option(name="js.bigint", category=OptionCategory.USER, help="Provide an implementation of the BigInt proposal.")
    public static final OptionKey<Boolean> BIGINT = new OptionKey((Object)true);
    public static final String CLASS_FIELDS_NAME = "js.class-fields";
    @Option(name="js.class-fields", category=OptionCategory.USER, help="Enable the class public and private fields proposal.")
    public static final OptionKey<Boolean> CLASS_FIELDS = new OptionKey((Object)false);
    public static final int CLASS_FIELDS_ES_VERSION = 12;
    public static final String REGEX_DUMP_AUTOMATA_NAME = "js.regex.dump-automata";
    @Option(name="js.regex.dump-automata", category=OptionCategory.INTERNAL, help="Produce ASTs and automata in JSON, DOT (GraphViz) and LaTeX formats.")
    public static final OptionKey<Boolean> REGEX_DUMP_AUTOMATA = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean regexDumpAutomata;
    public static final String REGEX_STEP_EXECUTION_NAME = "js.regex.step-execution";
    @Option(name="js.regex.step-execution", category=OptionCategory.INTERNAL, help="Trace the execution of automata in JSON files.")
    public static final OptionKey<Boolean> REGEX_STEP_EXECUTION = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean regexStepExecution;
    public static final String REGEX_ALWAYS_EAGER_NAME = "js.regex.always-eager";
    @Option(name="js.regex.always-eager", category=OptionCategory.INTERNAL, help="Always match capture groups eagerly.")
    public static final OptionKey<Boolean> REGEX_ALWAYS_EAGER = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean regexAlwaysEager;
    public static final String SCRIPT_ENGINE_GLOBAL_SCOPE_IMPORT_NAME = "js.script-engine-global-scope-import";
    @Option(name="js.script-engine-global-scope-import", deprecated=true, stability=OptionStability.STABLE, category=OptionCategory.INTERNAL, help="Enable ScriptEngine-specific global scope import function.")
    public static final OptionKey<Boolean> SCRIPT_ENGINE_GLOBAL_SCOPE_IMPORT = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean scriptEngineGlobalScopeImport;
    public static final String FOREIGN_OBJECT_PROTOTYPE_NAME = "js.foreign-object-prototype";
    @Option(name="js.foreign-object-prototype", category=OptionCategory.EXPERT, stability=OptionStability.STABLE, help="Non-JS objects have prototype (Object/Function/Array.prototype) set.")
    public static final OptionKey<Boolean> FOREIGN_OBJECT_PROTOTYPE = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean hasForeignObjectPrototype;
    public static final String FOREIGN_HASH_PROPERTIES_NAME = "js.foreign-hash-properties";
    @Option(name="js.foreign-hash-properties", category=OptionCategory.EXPERT, help="Allow getting/setting non-JS hash entries using the `[]` and `.` operators.")
    public static final OptionKey<Boolean> FOREIGN_HASH_PROPERTIES = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean hasForeignHashProperties;
    public static final String FUNCTION_ARGUMENTS_LIMIT_NAME = "js.function-arguments-limit";
    @Option(name="js.function-arguments-limit", category=OptionCategory.EXPERT, usageSyntax="<int>", help="Maximum number of arguments for functions.")
    public static final OptionKey<Long> FUNCTION_ARGUMENTS_LIMIT = new OptionKey((Object)65535L);
    @CompilerDirectives.CompilationFinal
    private long functionArgumentsLimit;
    public static final String TEST262_MODE_NAME = "js.test262-mode";
    @Option(name="js.test262-mode", category=OptionCategory.INTERNAL, help="Expose global property $262 needed to run the Test262 harness.")
    public static final OptionKey<Boolean> TEST262_MODE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean test262Mode;
    public static final String TESTV8_MODE_NAME = "js.testV8-mode";
    @Option(name="js.testV8-mode", category=OptionCategory.INTERNAL, help="Expose internals needed to run the TestV8 harness.")
    public static final OptionKey<Boolean> TESTV8_MODE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean testV8Mode;
    public static final String VALIDATE_REGEXP_LITERALS_NAME = "js.validate-regexp-literals";
    @Option(name="js.validate-regexp-literals", category=OptionCategory.INTERNAL, help="Validate regexp literals at parse time.")
    public static final OptionKey<Boolean> VALIDATE_REGEXP_LITERALS = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean validateRegExpLiterals;
    public static final String LOCALE_NAME = "js.locale";
    @Option(name="js.locale", category=OptionCategory.EXPERT, stability=OptionStability.STABLE, sandbox=SandboxPolicy.UNTRUSTED, usageSyntax="<locale>", help="Set the default locale (Unicode BCP 47 locale identifier) to be used for locale-sensitive operations. If empty, Locale.getDefault() will be used.")
    public static final OptionKey<String> LOCALE = new OptionKey((Object)"", new OptionType("Locale", (Function)new Function<String, String>(){

        @Override
        public String apply(String tag) {
            if (tag.isEmpty() || UTS35Validator.isWellFormedUnicodeBCP47LocaleIdentifier(tag)) {
                return tag;
            }
            throw new IllegalArgumentException(String.format("Language tag is not well-formed: %s", tag));
        }
    }));
    public static final String FUNCTION_CONSTRUCTOR_CACHE_SIZE_NAME = "js.function-constructor-cache-size";
    @Option(name="js.function-constructor-cache-size", category=OptionCategory.EXPERT, usageSyntax="<int>", help="Maximum size of the parsing cache used by the Function constructor to avoid re-parsing known sources.")
    public static final OptionKey<Integer> FUNCTION_CONSTRUCTOR_CACHE_SIZE = new OptionKey((Object)256);
    @CompilerDirectives.CompilationFinal
    private int functionConstructorCacheSize;
    public static final String REGEX_CACHE_SIZE_NAME = "js.regex-cache-size";
    @Option(name="js.regex-cache-size", category=OptionCategory.EXPERT, usageSyntax="<int>", help="Maximum size of the regex cache used by the RegExp constructor to avoid re-parsing known sources.")
    public static final OptionKey<Integer> REGEX_CACHE_SIZE = new OptionKey((Object)128);
    @CompilerDirectives.CompilationFinal
    private int regexCacheSize;
    public static final String STRING_LENGTH_LIMIT_NAME = "js.string-length-limit";
    @Option(name="js.string-length-limit", category=OptionCategory.EXPERT, usageSyntax="<chars>", help="Maximum string length.")
    public static final OptionKey<Integer> STRING_LENGTH_LIMIT = new OptionKey((Object)1073741799);
    @CompilerDirectives.CompilationFinal
    private int stringLengthLimit;
    public static final String STRING_LAZY_SUBSTRINGS_NAME = "js.string-lazy-substrings";
    @Option(name="js.string-lazy-substrings", category=OptionCategory.EXPERT, help="Allow lazy substrings.")
    public static final OptionKey<Boolean> STRING_LAZY_SUBSTRINGS = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean stringLazySubstrings;
    public static final String BIND_MEMBER_FUNCTIONS_NAME = "js.bind-member-functions";
    @Option(name="js.bind-member-functions", category=OptionCategory.EXPERT, help="Bind functions returned by Value.getMember to the receiver object.")
    public static final OptionKey<Boolean> BIND_MEMBER_FUNCTIONS = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean bindMemberFunctions;
    public static final String REGEX_REGRESSION_TEST_MODE_NAME = "js.regex-regression-test-mode";
    @Option(name="js.regex-regression-test-mode", category=OptionCategory.INTERNAL, help="Test mode for TRegex.")
    public static final OptionKey<Boolean> REGEX_REGRESSION_TEST_MODE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean regexRegressionTestMode;
    public static final String INTEROP_COMPLETE_PROMISES_NAME = "js.interop-complete-promises";
    @Option(name="js.interop-complete-promises", category=OptionCategory.EXPERT, help="Resolve promises when crossing a polyglot language boundary.")
    public static final OptionKey<Boolean> INTEROP_COMPLETE_PROMISES = new OptionKey((Object)false);
    public static final String DEBUG_PROPERTY_NAME_NAME = "js.debug-property-name";
    @Option(name="js.debug-property-name", category=OptionCategory.EXPERT, usageSyntax="<name>", help="The name used for the Graal.js debug builtin.")
    public static final OptionKey<String> DEBUG_PROPERTY_NAME = new OptionKey((Object)Strings.toJavaString(JSRealm.DEBUG_CLASS_NAME));
    public static final String PROFILE_TIME_NAME = "js.profile-time";
    @Option(name="js.profile-time", category=OptionCategory.INTERNAL, help="Enable time profiling.")
    public static final OptionKey<Boolean> PROFILE_TIME = new OptionKey((Object)false);
    public static final String PROFILE_TIME_PRINT_CUMULATIVE_NAME = "js.profile-time-print-cumulative";
    @Option(name="js.profile-time-print-cumulative", category=OptionCategory.INTERNAL, help="Print cumulative time when time profiling is enabled.")
    public static final OptionKey<Boolean> PROFILE_TIME_PRINT_CUMULATIVE = new OptionKey((Object)false);
    public static final String TEST_CLONE_UNINITIALIZED_NAME = "js.test-clone-uninitialized";
    @Option(name="js.test-clone-uninitialized", category=OptionCategory.INTERNAL, help="Test uninitialized cloning.")
    public static final OptionKey<Boolean> TEST_CLONE_UNINITIALIZED = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean testCloneUninitialized;
    public static final String LAZY_TRANSLATION_NAME = "js.lazy-translation";
    @Option(name="js.lazy-translation", category=OptionCategory.INTERNAL, help="Translate function bodies lazily.")
    public static final OptionKey<Boolean> LAZY_TRANSLATION = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean lazyTranslation;
    public static final String MAX_TYPED_ARRAY_LENGTH_NAME = "js.max-typed-array-length";
    @Option(name="js.max-typed-array-length", category=OptionCategory.EXPERT, usageSyntax="<int>", help="Maximum allowed length for TypedArrays.")
    public static final OptionKey<Integer> MAX_TYPED_ARRAY_LENGTH = new OptionKey((Object)0x7FFFFFF7);
    @CompilerDirectives.CompilationFinal
    private int maxTypedArrayLength;
    public static final String MAX_APPLY_ARGUMENT_LENGTH_NAME = "js.max-apply-argument-length";
    @Option(name="js.max-apply-argument-length", category=OptionCategory.EXPERT, usageSyntax="<int>", help="Maximum allowed number of arguments allowed in an apply function.")
    public static final OptionKey<Integer> MAX_APPLY_ARGUMENT_LENGTH = new OptionKey((Object)10000000);
    @CompilerDirectives.CompilationFinal
    private int maxApplyArgumentLength;
    public static final String MAX_PROTOTYPE_CHAIN_LENGTH_NAME = "js.max-prototype-chain-length";
    @Option(name="js.max-prototype-chain-length", category=OptionCategory.EXPERT, usageSyntax="<int>", help="Maximum allowed length of a prototype chain.")
    public static final OptionKey<Integer> MAX_PROTOTYPE_CHAIN_LENGTH = new OptionKey((Object)32766);
    @CompilerDirectives.CompilationFinal
    private int maxPrototypeChainLength;
    public static final String ASYNC_STACK_TRACES_NAME = "js.async-stack-traces";
    @Option(name="js.async-stack-traces", category=OptionCategory.EXPERT, help="Include async function frames in stack traces.")
    public static final OptionKey<Boolean> ASYNC_STACK_TRACES = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean asyncStackTraces;
    public static final String PROPERTY_CACHE_LIMIT_NAME = "js.property-cache-limit";
    @Option(name="js.property-cache-limit", category=OptionCategory.INTERNAL, usageSyntax="<int>", help="Maximum allowed size of a property cache.")
    public static final OptionKey<Integer> PROPERTY_CACHE_LIMIT = new OptionKey((Object)5);
    @CompilerDirectives.CompilationFinal
    private int propertyCacheLimit;
    public static final String FUNCTION_CACHE_LIMIT_NAME = "js.function-cache-limit";
    @Option(name="js.function-cache-limit", category=OptionCategory.INTERNAL, usageSyntax="<int>", help="Maximum allowed size of a function cache.")
    public static final OptionKey<Integer> FUNCTION_CACHE_LIMIT = new OptionKey((Object)4);
    @CompilerDirectives.CompilationFinal
    private int functionCacheLimit;
    public static final String TOP_LEVEL_AWAIT_NAME = "js.top-level-await";
    @Option(name="js.top-level-await", category=OptionCategory.EXPERT, help="Enable top-level-await.")
    protected static final OptionKey<Boolean> TOP_LEVEL_AWAIT = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean topLevelAwait;
    public static final String USE_UTC_FOR_LEGACY_DATES_NAME = "js.use-utc-for-legacy-dates";
    @Option(name="js.use-utc-for-legacy-dates", category=OptionCategory.EXPERT, stability=OptionStability.STABLE, help="Determines what time zone (UTC or local time zone) should be used when UTC offset is absent in a parsed date.")
    public static final OptionKey<Boolean> USE_UTC_FOR_LEGACY_DATES = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean useUTCForLegacyDates;
    public static final String WEBASSEMBLY_NAME = "js.webassembly";
    @Option(name="js.webassembly", category=OptionCategory.USER, stability=OptionStability.STABLE, help="Enable WebAssembly JavaScript API.")
    public static final OptionKey<Boolean> WEBASSEMBLY = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean webAssembly;
    public static final String NEW_SET_METHODS_NAME = "js.new-set-methods";
    @Option(name="js.new-set-methods", category=OptionCategory.EXPERT, help="Enable new Set methods.")
    public static final OptionKey<Boolean> NEW_SET_METHODS = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean newSetMethods;
    public static final String ATOMICS_WAIT_ASYNC_NAME = "js.atomics-wait-async";
    @Option(name="js.atomics-wait-async", category=OptionCategory.EXPERT, help="Enable Atomics.waitAsync.")
    public static final OptionKey<Boolean> ATOMICS_WAIT_ASYNC = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean atomicsWaitAsync;
    public static final String TEMPORAL_NAME = "js.temporal";
    @Option(name="js.temporal", category=OptionCategory.EXPERT, help="Enable JavaScript Temporal API.")
    public static final OptionKey<Boolean> TEMPORAL = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean temporal;
    public static final String ITERATOR_HELPERS_NAME = "js.iterator-helpers";
    @Option(name="js.iterator-helpers", category=OptionCategory.EXPERT, help="Enable JavaScript Iterator Helpers API.")
    public static final OptionKey<Boolean> ITERATOR_HELPERS = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean iteratorHelpers;
    public static final String SHADOW_REALM_NAME = "js.shadow-realm";
    @Option(name="js.shadow-realm", category=OptionCategory.EXPERT, help="Enable ShadowRealm API.")
    public static final OptionKey<Boolean> SHADOW_REALM = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean shadowRealm;
    public static final String ASYNC_CONTEXT_NAME = "js.async-context";
    @Option(name="js.async-context", category=OptionCategory.EXPERT, help="Enable AsyncContext proposal.")
    public static final OptionKey<Boolean> ASYNC_CONTEXT = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean asyncContext;
    public static final String ALLOW_NARROW_SPACES_IN_DATE_FORMAT_NAME = "js.allow-narrow-spaces-in-date-format";
    @Option(name="js.allow-narrow-spaces-in-date-format", category=OptionCategory.EXPERT, help="Allow narrow spaces when formatting dates.")
    public static final OptionKey<Boolean> ALLOW_NARROW_SPACES_IN_DATE_FORMAT = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean allowNarrowSpacesInDateFormat;
    public static final String V8_INTRINSICS_NAME = "js.v8-intrinsics";
    @Option(name="js.v8-intrinsics", category=OptionCategory.INTERNAL, help="Enable parsing of V8 intrinsics.")
    public static final OptionKey<Boolean> V8_INTRINSICS = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean v8Intrinsics;
    public static final String UNHANDLED_REJECTIONS_NAME = "js.unhandled-rejections";
    @Option(name="js.unhandled-rejections", category=OptionCategory.USER, stability=OptionStability.STABLE, sandbox=SandboxPolicy.CONSTRAINED, help="Configure unhandled promise rejections tracking. Accepted values: 'none', unhandled rejections are not tracked. 'warn', a warning is printed to stderr when an unhandled rejection is detected. 'throw', an exception is thrown when an unhandled rejection is detected. 'handler', the handler function set with Graal.setUnhandledPromiseRejectionHandler will be called with the rejection value and promise respectively as arguments.")
    public static final OptionKey<UnhandledRejectionsTrackingMode> UNHANDLED_REJECTIONS = new OptionKey((Object)UnhandledRejectionsTrackingMode.NONE);
    @CompilerDirectives.CompilationFinal
    private UnhandledRejectionsTrackingMode unhandledRejectionsMode;
    public static final String OPERATOR_OVERLOADING_NAME = "js.operator-overloading";
    @Option(name="js.operator-overloading", category=OptionCategory.USER, help="Enable operator overloading")
    public static final OptionKey<Boolean> OPERATOR_OVERLOADING = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean operatorOverloading;
    public static final String ERROR_CAUSE_NAME = "js.error-cause";
    @Option(name="js.error-cause", category=OptionCategory.EXPERT, help="Enable the error cause proposal. Allows an error to be chained with a cause using the optional options parameter.")
    public static final OptionKey<Boolean> ERROR_CAUSE = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean errorCause;
    public static final String IMPORT_ASSERTIONS_NAME = "js.import-assertions";
    @Option(name="js.import-assertions", category=OptionCategory.USER, help="Enable import assertions")
    public static final OptionKey<Boolean> IMPORT_ASSERTIONS = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean importAssertions;
    public static final String JSON_MODULES_NAME = "js.json-modules";
    @Option(name="js.json-modules", category=OptionCategory.USER, help="Enable loading of json modules")
    public static final OptionKey<Boolean> JSON_MODULES = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean jsonModules;
    public static final String WASM_BIG_INT_NAME = "js.wasm-bigint";
    @Option(name="js.wasm-bigint", category=OptionCategory.USER, help="Enable wasm i64 to javascript BigInt support")
    public static final OptionKey<Boolean> WASM_BIG_INT = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean wasmBigInt;
    public static final String ESM_EVAL_RETURNS_EXPORTS_NAME = "js.esm-eval-returns-exports";
    @Option(name="js.esm-eval-returns-exports", category=OptionCategory.EXPERT, help="Eval of an ES module through the polyglot API returns its exported symbols.")
    public static final OptionKey<Boolean> ESM_EVAL_RETURNS_EXPORTS = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean esmEvalReturnsExports;
    public static final String MLE_MODE_NAME = "js.mle-mode";
    @Option(name="js.mle-mode", category=OptionCategory.INTERNAL, help="Provide a non-API MLE builtin. Behaviour will likely change. Don't depend on this in production code.")
    public static final OptionKey<Boolean> MLE_MODE = new OptionKey((Object)false);
    public static final String MLE_PROPERTY_NAME = "MLE";
    @CompilerDirectives.CompilationFinal
    private boolean mleMode;
    public static final String PRIVATE_FIELDS_IN_NAME = "js.private-fields-in";
    @Option(name="js.private-fields-in", category=OptionCategory.USER, help="Enable private field in in operator")
    public static final OptionKey<Boolean> PRIVATE_FIELDS_IN = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean privateFieldsIn;
    public static final String ESM_BARE_SPECIFIER_RELATIVE_LOOKUP_NAME = "js.esm-bare-specifier-relative-lookup";
    @Option(name="js.esm-bare-specifier-relative-lookup", category=OptionCategory.EXPERT, help="Resolve ESM bare specifiers relative to the importing module's path instead of attempting an absolute path lookup.")
    public static final OptionKey<Boolean> ESM_BARE_SPECIFIER_RELATIVE_LOOKUP = new OptionKey((Object)false);
    @CompilerDirectives.CompilationFinal
    private boolean esmBareSpecifierRelativeLookup;
    public static final String CHARSET_NAME = "js.charset";
    @Option(name="js.charset", category=OptionCategory.EXPERT, usageSyntax="UTF-8|UTF-32|<name>", help="Charset used for decoding/encoding of the input/output streams.")
    public static final OptionKey<String> CHARSET = new OptionKey((Object)"", new OptionType("CharsetName", (Function)new Function<String, String>(){

        @Override
        public String apply(String name) {
            if (name.isEmpty()) {
                return "";
            }
            try {
                return Charset.forName(name).name();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }));
    public static final String SCOPE_OPTIMIZATION_NAME = "js.scope-optimization";
    @Option(name="js.scope-optimization", category=OptionCategory.INTERNAL, help="Allow scope optimizations around closures.")
    public static final OptionKey<Boolean> SCOPE_OPTIMIZATION = new OptionKey((Object)true);
    @CompilerDirectives.CompilationFinal
    private boolean scopeOptimization;
    public static final String FREQUENCY_BASED_PROPERTY_CACHE_LIMIT_NAME = "js.frequency-based-property-cache-limit";
    @Option(name="js.frequency-based-property-cache-limit", category=OptionCategory.INTERNAL, help="Maximum size of high-frequency-key property cache.")
    public static final OptionKey<Integer> FREQUENCY_BASED_PROPERTY_CACHE_LIMIT = new OptionKey((Object)5, JSContextOptions.integerRange(0, Short.MAX_VALUE));
    @CompilerDirectives.CompilationFinal
    private short frequencyBasedPropertyCacheLimit;

    private static OptionType<Integer> integerRange(int min, int max) {
        return new OptionType("Integer", sv -> {
            try {
                int iv = Integer.parseInt(sv);
                if (iv < min || iv > max) {
                    throw new NumberFormatException();
                }
                return iv;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Value \"%s\" is not an integer in the range [%d, %d].", sv, min, max));
            }
        });
    }

    JSContextOptions(SandboxPolicy sandboxPolicy, OptionValues optionValues) {
        this.optionValues = optionValues;
        this.setOptionValues(sandboxPolicy, optionValues);
    }

    public static JSContextOptions fromOptionValues(SandboxPolicy sandboxPolicy, OptionValues optionValues) {
        return new JSContextOptions(sandboxPolicy, optionValues);
    }

    public void setOptionValues(SandboxPolicy sandboxPolicy, OptionValues newOptions) {
        CompilerAsserts.neverPartOfCompilation();
        this.optionValues = newOptions;
        this.cacheOptions(sandboxPolicy);
    }

    private void cacheOptions(SandboxPolicy sandboxPolicy) {
        this.nashornCompatibilityMode = this.readBooleanOption(NASHORN_COMPATIBILITY_MODE);
        this.ecmascriptVersion = this.nashornCompatibilityMode && !ECMASCRIPT_VERSION.hasBeenSet(this.optionValues) ? 5 : this.readIntegerOption(ECMASCRIPT_VERSION);
        this.annexB = this.readBooleanOption(ANNEX_B);
        this.intl402 = INTL_402.hasBeenSet(this.optionValues) ? this.readBooleanOption(INTL_402) : !this.nashornCompatibilityMode;
        this.regexpStaticResult = this.readBooleanOption(REGEXP_STATIC_RESULT);
        this.regexpMatchIndices = REGEXP_MATCH_INDICES.hasBeenSet(this.optionValues) ? this.readBooleanOption(REGEXP_MATCH_INDICES) : this.getEcmaScriptVersion() >= 13;
        this.regexpUnicodeSets = this.readBooleanOption(REGEXP_UNICODE_SETS);
        this.sharedArrayBuffer = this.readBooleanOption(SHARED_ARRAY_BUFFER);
        this.v8CompatibilityMode = this.readBooleanOption(V8_COMPATIBILITY_MODE);
        this.v8RealmBuiltin = this.readBooleanOption(V8_REALM_BUILTIN);
        this.directByteBuffer = this.readBooleanOption(DIRECT_BYTE_BUFFER);
        this.parseOnly = this.readBooleanOption(PARSE_ONLY);
        this.debug = this.readBooleanOption(DEBUG_BUILTIN);
        this.zoneRulesBasedTimeZones = this.readBooleanOption(ZONE_RULES_BASED_TIME_ZONES);
        this.timerResolution = this.optionValues.hasBeenSet(TIMER_RESOLUTION) ? this.readLongOption(TIMER_RESOLUTION) : (sandboxPolicy.isStricterOrEqual(SandboxPolicy.UNTRUSTED) ? TimeUnit.SECONDS.toNanos(1L) : ((Long)TIMER_RESOLUTION.getDefaultValue()).longValue());
        this.agentCanBlock = this.readBooleanOption(AGENT_CAN_BLOCK);
        this.awaitOptimization = this.readBooleanOption(AWAIT_OPTIMIZATION);
        this.allowEval = this.readBooleanOption(ALLOW_EVAL) && !this.readBooleanOption(DISABLE_EVAL);
        this.disableWith = this.readBooleanOption(DISABLE_WITH);
        this.regexDumpAutomata = this.readBooleanOption(REGEX_DUMP_AUTOMATA);
        this.regexStepExecution = this.readBooleanOption(REGEX_STEP_EXECUTION);
        this.regexAlwaysEager = this.readBooleanOption(REGEX_ALWAYS_EAGER);
        this.scriptEngineGlobalScopeImport = this.readBooleanOption(SCRIPT_ENGINE_GLOBAL_SCOPE_IMPORT);
        this.hasForeignObjectPrototype = this.readBooleanOption(FOREIGN_OBJECT_PROTOTYPE);
        this.hasForeignHashProperties = this.readBooleanOption(FOREIGN_HASH_PROPERTIES);
        this.functionArgumentsLimit = this.readLongOption(FUNCTION_ARGUMENTS_LIMIT);
        this.test262Mode = this.readBooleanOption(TEST262_MODE);
        this.testV8Mode = this.readBooleanOption(TESTV8_MODE);
        this.validateRegExpLiterals = this.readBooleanOption(VALIDATE_REGEXP_LITERALS);
        this.functionConstructorCacheSize = this.readIntegerOption(FUNCTION_CONSTRUCTOR_CACHE_SIZE);
        this.regexCacheSize = this.readIntegerOption(REGEX_CACHE_SIZE);
        this.stringLengthLimit = this.readIntegerOption(STRING_LENGTH_LIMIT);
        this.stringLazySubstrings = this.readBooleanOption(STRING_LAZY_SUBSTRINGS);
        this.bindMemberFunctions = this.readBooleanOption(BIND_MEMBER_FUNCTIONS);
        this.commonJSRequire = this.readBooleanOption(COMMONJS_REQUIRE);
        this.regexRegressionTestMode = this.readBooleanOption(REGEX_REGRESSION_TEST_MODE);
        this.testCloneUninitialized = this.readBooleanOption(TEST_CLONE_UNINITIALIZED);
        this.lazyTranslation = this.readBooleanOption(LAZY_TRANSLATION);
        this.stackTraceLimit = this.readIntegerOption(STACK_TRACE_LIMIT);
        this.maxTypedArrayLength = this.readIntegerOption(MAX_TYPED_ARRAY_LENGTH);
        this.maxApplyArgumentLength = this.readIntegerOption(MAX_APPLY_ARGUMENT_LENGTH);
        this.maxPrototypeChainLength = this.readIntegerOption(MAX_PROTOTYPE_CHAIN_LENGTH);
        this.asyncStackTraces = this.readBooleanOption(ASYNC_STACK_TRACES);
        boolean bl = TOP_LEVEL_AWAIT.hasBeenSet(this.optionValues) ? this.readBooleanOption(TOP_LEVEL_AWAIT) : (this.topLevelAwait = this.getEcmaScriptVersion() >= 13);
        this.useUTCForLegacyDates = USE_UTC_FOR_LEGACY_DATES.hasBeenSet(this.optionValues) ? this.readBooleanOption(USE_UTC_FOR_LEGACY_DATES) : !this.v8CompatibilityMode;
        this.webAssembly = this.readBooleanOption(WEBASSEMBLY);
        this.unhandledRejectionsMode = this.readUnhandledRejectionsMode();
        this.newSetMethods = this.readBooleanOption(NEW_SET_METHODS);
        boolean bl2 = this.iteratorHelpers = this.getEcmaScriptVersion() >= 9 && this.readBooleanOption(ITERATOR_HELPERS);
        this.atomicsWaitAsync = ATOMICS_WAIT_ASYNC.hasBeenSet(this.optionValues) ? this.readBooleanOption(ATOMICS_WAIT_ASYNC) : this.getEcmaScriptVersion() >= 15;
        this.shadowRealm = this.getEcmaScriptVersion() >= 6 && this.readBooleanOption(SHADOW_REALM);
        this.asyncContext = this.readBooleanOption(ASYNC_CONTEXT);
        this.operatorOverloading = this.readBooleanOption(OPERATOR_OVERLOADING);
        this.errorCause = ERROR_CAUSE.hasBeenSet(this.optionValues) ? this.readBooleanOption(ERROR_CAUSE) : this.getEcmaScriptVersion() >= 13;
        this.importAssertions = this.readBooleanOption(IMPORT_ASSERTIONS);
        this.jsonModules = this.readBooleanOption(JSON_MODULES);
        this.wasmBigInt = this.readBooleanOption(WASM_BIG_INT);
        this.esmEvalReturnsExports = this.readBooleanOption(ESM_EVAL_RETURNS_EXPORTS);
        this.printNoNewline = this.readBooleanOption(PRINT_NO_NEWLINE);
        boolean bl3 = this.mleMode = this.readBooleanOption(MLE_MODE) || this.readBooleanOption(INTEROP_COMPLETE_PROMISES);
        this.privateFieldsIn = PRIVATE_FIELDS_IN.hasBeenSet(this.optionValues) ? this.readBooleanOption(PRIVATE_FIELDS_IN) : this.getEcmaScriptVersion() >= 13;
        this.esmBareSpecifierRelativeLookup = this.readBooleanOption(ESM_BARE_SPECIFIER_RELATIVE_LOOKUP);
        this.temporal = this.readBooleanOption(TEMPORAL);
        this.propertyCacheLimit = this.readIntegerOption(PROPERTY_CACHE_LIMIT);
        this.functionCacheLimit = this.readIntegerOption(FUNCTION_CACHE_LIMIT);
        this.frequencyBasedPropertyCacheLimit = (short)this.readIntegerOption(FREQUENCY_BASED_PROPERTY_CACHE_LIMIT);
        this.scopeOptimization = this.readBooleanOption(SCOPE_OPTIMIZATION);
        this.allowNarrowSpacesInDateFormat = ALLOW_NARROW_SPACES_IN_DATE_FORMAT.hasBeenSet(this.optionValues) ? this.readBooleanOption(ALLOW_NARROW_SPACES_IN_DATE_FORMAT) : !this.isV8CompatibilityMode();
        this.v8Intrinsics = this.readBooleanOption(V8_INTRINSICS);
    }

    private UnhandledRejectionsTrackingMode readUnhandledRejectionsMode() {
        return (UnhandledRejectionsTrackingMode)((Object)UNHANDLED_REJECTIONS.getValue(this.optionValues));
    }

    private boolean readBooleanOption(OptionKey<Boolean> key) {
        return (Boolean)key.getValue(this.optionValues);
    }

    private int readIntegerOption(OptionKey<Integer> key) {
        return (Integer)key.getValue(this.optionValues);
    }

    private long readLongOption(OptionKey<Long> key) {
        return (Long)key.getValue(this.optionValues);
    }

    public static TruffleOptionDescriptors optionDescriptorsWithDefaultValues() {
        final JSContextOptionsOptionDescriptors originalOptionDescriptors = new JSContextOptionsOptionDescriptors();
        ArrayList<OptionDescriptor> options = new ArrayList<OptionDescriptor>();
        JSContextOptions.describeOptions(originalOptionDescriptors, options);
        final OptionDescriptors optionDescriptorsWithDefaults = OptionDescriptors.create(options);
        return new TruffleOptionDescriptors(){

            public SandboxPolicy getSandboxPolicy(String key) {
                return originalOptionDescriptors.getSandboxPolicy(key);
            }

            public OptionDescriptor get(String optionName) {
                return optionDescriptorsWithDefaults.get(optionName);
            }

            public Iterator<OptionDescriptor> iterator() {
                return optionDescriptorsWithDefaults.iterator();
            }
        };
    }

    private static String helpWithDefault(String helpMessage, OptionKey<? extends Object> key) {
        return helpMessage + " (default:" + key.getDefaultValue() + ")";
    }

    private static OptionDescriptor newOptionDescriptor(OptionKey<?> key, String name, OptionCategory category, OptionStability stability, String help, String usageSyntax) {
        return OptionDescriptor.newBuilder(key, (String)name).category(category).help(JSContextOptions.helpWithDefault(help, key)).stability(stability).usageSyntax(usageSyntax).build();
    }

    private static void describeOptions(JSContextOptionsOptionDescriptors descriptors, List<OptionDescriptor> options) {
        Iterator<OptionDescriptor> iterator = descriptors.iterator();
        while (iterator.hasNext()) {
            OptionDescriptor desc = iterator.next();
            options.add(JSContextOptions.newOptionDescriptor(desc.getKey(), desc.getName(), desc.getCategory(), desc.getStability(), desc.getHelp(), desc.getUsageSyntax()));
        }
    }

    public int getEcmaScriptVersion() {
        return this.ecmascriptVersion;
    }

    public boolean isAnnexB() {
        return this.annexB;
    }

    public boolean isIntl402() {
        CompilerAsserts.neverPartOfCompilation((String)"Patchable option intl-402 should never be accessed in compiled code.");
        return this.intl402;
    }

    public boolean isRegexpMatchIndices() {
        return this.regexpMatchIndices;
    }

    public boolean isRegexpUnicodeSets() {
        return this.regexpUnicodeSets;
    }

    public boolean isRegexpStaticResult() {
        return this.regexpStaticResult;
    }

    public boolean isSharedArrayBuffer() {
        if (this.getEcmaScriptVersion() < 8) {
            return false;
        }
        return this.sharedArrayBuffer;
    }

    public boolean isAtomics() {
        if (this.getEcmaScriptVersion() < 8) {
            return false;
        }
        return (Boolean)ATOMICS.getValue(this.optionValues);
    }

    public boolean isV8CompatibilityMode() {
        return this.v8CompatibilityMode;
    }

    public boolean isNashornCompatibilityMode() {
        return this.nashornCompatibilityMode;
    }

    public boolean isDebugBuiltin() {
        return this.debug;
    }

    public boolean isMLEMode() {
        return this.mleMode;
    }

    public boolean isDirectByteBuffer() {
        return this.directByteBuffer;
    }

    public boolean isParseOnly() {
        return this.parseOnly;
    }

    public long getTimerResolution() {
        return this.timerResolution;
    }

    public boolean isV8RealmBuiltin() {
        return this.v8RealmBuiltin;
    }

    public boolean hasZoneRulesBasedTimeZones() {
        return this.zoneRulesBasedTimeZones;
    }

    public boolean canAgentBlock() {
        return this.agentCanBlock;
    }

    public boolean isAwaitOptimization() {
        return this.awaitOptimization;
    }

    public boolean isTopLevelAwait() {
        return this.topLevelAwait;
    }

    public boolean allowEval() {
        return this.allowEval;
    }

    public boolean isDisableWith() {
        return this.disableWith;
    }

    public boolean isRegexDumpAutomata() {
        return this.regexDumpAutomata;
    }

    public boolean isRegexStepExecution() {
        return this.regexStepExecution;
    }

    public boolean isRegexAlwaysEager() {
        return this.regexAlwaysEager;
    }

    public boolean isScriptEngineGlobalScopeImport() {
        return this.scriptEngineGlobalScopeImport;
    }

    public boolean hasForeignObjectPrototype() {
        return this.hasForeignObjectPrototype;
    }

    public boolean hasForeignHashProperties() {
        return this.hasForeignHashProperties;
    }

    public boolean isGlobalProperty() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option global-property was assumed not to be accessed in compiled code.");
        return (Boolean)GLOBAL_PROPERTY.getValue(this.optionValues);
    }

    public boolean isGlobalArguments() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option js.global-arguments was assumed not to be accessed in compiled code.");
        return (Boolean)GLOBAL_ARGUMENTS.getValue(this.optionValues);
    }

    public boolean isConsole() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option console was assumed not to be accessed in compiled code.");
        return (Boolean)CONSOLE.getValue(this.optionValues) != false || !CONSOLE.hasBeenSet(this.optionValues) && this.isShell();
    }

    public boolean isPrint() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option print was assumed not to be accessed in compiled code.");
        return (Boolean)PRINT.getValue(this.optionValues) != false || !PRINT.hasBeenSet(this.optionValues) && (this.isShell() || this.isNashornCompatibilityMode());
    }

    public boolean isPrintNoNewline() {
        return this.printNoNewline;
    }

    public boolean isLoad() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option load was assumed not to be accessed in compiled code.");
        return (Boolean)LOAD.getValue(this.optionValues) != false || !LOAD.hasBeenSet(this.optionValues) && (this.isShell() || this.isNashornCompatibilityMode());
    }

    public boolean isCommonJSRequire() {
        return this.commonJSRequire;
    }

    public Map<String, String> getCommonJSRequireBuiltins() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option load was assumed not to be accessed in compiled code.");
        return (Map)COMMONJS_CORE_MODULES_REPLACEMENTS.getValue(this.optionValues);
    }

    public String getRequireCwd() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option load was assumed not to be accessed in compiled code.");
        return (String)COMMONJS_REQUIRE_CWD.getValue(this.optionValues);
    }

    public boolean isPerformance() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option performance was assumed not to be accessed in compiled code.");
        return (Boolean)PERFORMANCE.getValue(this.optionValues) != false || !PERFORMANCE.hasBeenSet(this.optionValues) && this.isShell();
    }

    public boolean isShell() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option shell was assumed not to be accessed in compiled code.");
        return (Boolean)SHELL.getValue(this.optionValues);
    }

    public boolean isGraalBuiltin() {
        return (Boolean)GRAAL_BUILTIN.getValue(this.optionValues);
    }

    public boolean isPolyglotBuiltin() {
        return (Boolean)POLYGLOT_BUILTIN.getValue(this.optionValues);
    }

    public boolean isPolyglotEvalFile() {
        return (Boolean)POLYGLOT_EVALFILE.getValue(this.optionValues);
    }

    public boolean isLoadFromURL() {
        return (Boolean)LOAD_FROM_URL.getValue(this.optionValues);
    }

    public boolean isLoadFromClasspath() {
        return (Boolean)LOAD_FROM_CLASSPATH.getValue(this.optionValues);
    }

    public boolean isBigInt() {
        if (this.getEcmaScriptVersion() < 10) {
            return false;
        }
        return (Boolean)BIGINT.getValue(this.optionValues);
    }

    public long getFunctionArgumentsLimit() {
        return this.functionArgumentsLimit;
    }

    public boolean isTest262Mode() {
        return this.test262Mode;
    }

    public boolean isTestV8Mode() {
        return this.testV8Mode;
    }

    public boolean isValidateRegExpLiterals() {
        return this.validateRegExpLiterals;
    }

    public String getLocale() {
        return (String)LOCALE.getValue(this.optionValues);
    }

    public String getCharset() {
        return (String)CHARSET.getValue(this.optionValues);
    }

    public int getFunctionConstructorCacheSize() {
        return this.functionConstructorCacheSize;
    }

    public int getRegexCacheSize() {
        return this.regexCacheSize;
    }

    public int getStringLengthLimit() {
        return this.stringLengthLimit;
    }

    public boolean isStringLazySubstrings() {
        return this.stringLazySubstrings;
    }

    public boolean bindMemberFunctions() {
        return this.bindMemberFunctions;
    }

    public boolean isRegexRegressionTestMode() {
        return this.regexRegressionTestMode;
    }

    public String getDebugPropertyName() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option debug-property-name was assumed not to be accessed in compiled code.");
        return (String)DEBUG_PROPERTY_NAME.getValue(this.optionValues);
    }

    public boolean isProfileTime() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option profile-time was assumed not to be accessed in compiled code.");
        return (Boolean)PROFILE_TIME.getValue(this.optionValues);
    }

    public boolean isTestCloneUninitialized() {
        return this.testCloneUninitialized;
    }

    public boolean isLazyTranslation() {
        return this.lazyTranslation;
    }

    public boolean isProfileTimePrintCumulative() {
        CompilerAsserts.neverPartOfCompilation((String)"Context patchable option profile-time-print-cumulative was assumed not to be accessed in compiled code.");
        return (Boolean)PROFILE_TIME_PRINT_CUMULATIVE.getValue(this.optionValues);
    }

    public int getStackTraceLimit() {
        return this.stackTraceLimit;
    }

    public int getMaxTypedArrayLength() {
        return this.maxTypedArrayLength;
    }

    public int getMaxApplyArgumentLength() {
        return this.maxApplyArgumentLength;
    }

    public int getMaxPrototypeChainLength() {
        return this.maxPrototypeChainLength;
    }

    public int getPropertyCacheLimit() {
        return this.propertyCacheLimit;
    }

    public int getFunctionCacheLimit() {
        return this.functionCacheLimit;
    }

    public boolean isAsyncStackTraces() {
        return this.asyncStackTraces;
    }

    public boolean shouldUseUTCForLegacyDates() {
        return this.useUTCForLegacyDates;
    }

    public boolean isWebAssembly() {
        return this.webAssembly;
    }

    public boolean isTemporal() {
        return this.temporal;
    }

    public UnhandledRejectionsTrackingMode getUnhandledRejectionsMode() {
        return this.unhandledRejectionsMode;
    }

    public boolean isNewSetMethods() {
        return this.newSetMethods;
    }

    public boolean isAtomicsWaitAsync() {
        return this.atomicsWaitAsync;
    }

    public boolean isIteratorHelpers() {
        return this.iteratorHelpers;
    }

    public boolean isShadowRealm() {
        return this.shadowRealm;
    }

    public boolean isAsyncContext() {
        return this.asyncContext;
    }

    public boolean isOperatorOverloading() {
        return this.operatorOverloading;
    }

    public boolean isErrorCauseEnabled() {
        return this.errorCause;
    }

    public boolean isImportAssertions() {
        return this.importAssertions;
    }

    public boolean isJsonModules() {
        return this.jsonModules;
    }

    public boolean isWasmBigInt() {
        return this.wasmBigInt;
    }

    public boolean isEsmEvalReturnsExports() {
        return this.esmEvalReturnsExports;
    }

    public boolean isPrivateFieldsIn() {
        return this.privateFieldsIn;
    }

    public boolean isEsmBareSpecifierRelativeLookup() {
        return this.esmBareSpecifierRelativeLookup;
    }

    public boolean isScopeOptimization() {
        return this.scopeOptimization;
    }

    public boolean allowNarrowSpacesInDateFormat() {
        return this.allowNarrowSpacesInDateFormat;
    }

    public boolean isSyntaxExtensions() {
        return SYNTAX_EXTENSIONS.hasBeenSet(this.optionValues) ? (Boolean)SYNTAX_EXTENSIONS.getValue(this.optionValues) : (Boolean)NASHORN_COMPATIBILITY_MODE.getValue(this.optionValues);
    }

    public boolean isScripting() {
        return (Boolean)SCRIPTING.getValue(this.optionValues);
    }

    public boolean isShebang() {
        return SHEBANG.hasBeenSet(this.optionValues) ? (Boolean)SHEBANG.getValue(this.optionValues) : this.getEcmaScriptVersion() >= 11;
    }

    public boolean isStrict() {
        return (Boolean)STRICT.getValue(this.optionValues);
    }

    public boolean isConstAsVar() {
        return (Boolean)CONST_AS_VAR.getValue(this.optionValues);
    }

    public boolean isFunctionStatementError() {
        return (Boolean)FUNCTION_STATEMENT_ERROR.getValue(this.optionValues);
    }

    public boolean isClassFields() {
        return CLASS_FIELDS.hasBeenSet(this.optionValues) ? (Boolean)CLASS_FIELDS.getValue(this.optionValues) : this.getEcmaScriptVersion() >= 12;
    }

    public boolean isV8Intrinsics() {
        return (Boolean)V8_INTRINSICS.getValue(this.optionValues);
    }

    public short getFrequencyBasedPropertyCacheLimit() {
        return this.frequencyBasedPropertyCacheLimit;
    }

    public static enum UnhandledRejectionsTrackingMode {
        NONE,
        WARN,
        THROW,
        HANDLER;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

