/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm;

import java.util.ArrayList;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.debug.GraalError;

public final class Label {
    private int position = -1;
    private final int blockId;
    ArrayList<Integer> patchPositions;
    Label nextWithPatches;

    public int position() {
        assert (this.position >= 0) : "Unbound label is being referenced";
        return this.position;
    }

    public Label() {
        this.blockId = -1;
    }

    public Label(int id) {
        this.blockId = id;
    }

    public int getBlockId() {
        return this.blockId;
    }

    protected void bind(int pos, Assembler<?> asm) {
        if (pos < 0) {
            throw new GraalError("Cannot bind label to negative position %d", pos);
        }
        this.position = pos;
        if (this.patchPositions != null) {
            for (int i = 0; i < this.patchPositions.size(); ++i) {
                asm.patchJumpTarget(this.patchPositions.get(i), this.position);
            }
            this.patchPositions = null;
        }
    }

    public boolean isBound() {
        return this.position >= 0;
    }

    public void addPatchAt(int branchLocation, Assembler<?> asm) {
        assert (!this.isBound()) : "Label is already bound " + this + " " + branchLocation + " at position " + this.position;
        if (this.patchPositions == null) {
            this.patchPositions = new ArrayList(2);
            this.nextWithPatches = asm.labelsWithPatches;
            asm.labelsWithPatches = this;
        }
        assert (!this.patchPositions.contains(branchLocation)) : "same location added multiple times: " + branchLocation;
        this.patchPositions.add(branchLocation);
    }

    public void reset() {
        this.patchPositions = null;
        this.nextWithPatches = null;
        this.position = -1;
    }

    public String toString() {
        return this.isBound() ? String.valueOf(this.position()) : "?";
    }
}

