/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.bytecode;

import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeLookupSwitch;
import org.graalvm.compiler.bytecode.BytecodeStream;
import org.graalvm.compiler.bytecode.BytecodeSwitch;
import org.graalvm.compiler.bytecode.BytecodeTableSwitch;
import org.graalvm.compiler.bytecode.Bytecodes;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.serviceprovider.GraalServices;

public class BytecodeDisassembler {
    private final boolean multiline;
    private final boolean newLine;

    public BytecodeDisassembler(boolean multiline, boolean newLine) {
        this.multiline = multiline;
        this.newLine = newLine;
    }

    public BytecodeDisassembler(boolean multiline) {
        this(multiline, true);
    }

    public BytecodeDisassembler() {
        this(true, true);
    }

    public static String disassembleOne(ResolvedJavaMethod method, int bci) {
        return new BytecodeDisassembler(false, false).disassemble(method, bci, bci);
    }

    public String disassemble(ResolvedJavaMethod method) {
        return this.disassemble(method, 0, Integer.MAX_VALUE);
    }

    public String disassemble(ResolvedJavaMethod method, int startBci, int endBci) {
        return this.disassemble(new ResolvedJavaMethodBytecode(method), startBci, endBci);
    }

    public String disassemble(Bytecode code) {
        return this.disassemble(code, 0, Integer.MAX_VALUE);
    }

    public String disassemble(Bytecode code, int startBci, int endBci) {
        if (code.getCode() == null) {
            return null;
        }
        ResolvedJavaMethod method = code.getMethod();
        ConstantPool cp = code.getConstantPool();
        BytecodeStream stream = new BytecodeStream(code.getCode());
        StringBuilder buf = new StringBuilder();
        int opcode = stream.currentBC();
        try {
            while (opcode != 256) {
                int bci = stream.currentBCI();
                if (bci >= startBci && bci <= endBci) {
                    String mnemonic = Bytecodes.nameOf(opcode);
                    buf.append(String.format("%4d: %-14s", bci, mnemonic));
                    if (stream.nextBCI() > bci + 1) {
                        this.decodeOperand(buf, stream, cp, method, bci, opcode);
                    }
                    if (this.newLine) {
                        buf.append(String.format("%n", new Object[0]));
                    }
                }
                stream.next();
                opcode = stream.currentBC();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("Error disassembling %s%nPartial disassembly:%n%s", method.format("%H.%n(%p)"), buf.toString()), e);
        }
        return buf.toString();
    }

    private void decodeOperand(StringBuilder buf, BytecodeStream stream, ConstantPool cp, ResolvedJavaMethod method, int bci, int opcode) {
        switch (opcode) {
            case 16: {
                buf.append(stream.readByte());
                break;
            }
            case 17: {
                buf.append(stream.readShort());
                break;
            }
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                char cpi = stream.readCPI();
                JavaType type = cp.lookupType((int)cpi, opcode);
                buf.append(String.format("#%-10d // %s", cpi, type.toJavaName()));
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                char cpi = stream.readCPI();
                JavaField field = cp.lookupField((int)cpi, method, opcode);
                String fieldDesc = field.getDeclaringClass().getName().equals(method.getDeclaringClass().getName()) ? field.format("%n:%T") : field.format("%H.%n:%T");
                buf.append(String.format("#%-10d // %s", cpi, fieldDesc));
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                char cpi = stream.readCPI();
                JavaMethod callee = cp.lookupMethod((int)cpi, opcode);
                String calleeDesc = callee.getDeclaringClass().getName().equals(method.getDeclaringClass().getName()) ? callee.format("%n:(%P)%R") : callee.format("%H.%n:(%P)%R");
                buf.append(String.format("#%-10d // %s", cpi, calleeDesc));
                break;
            }
            case 185: {
                char cpi = stream.readCPI();
                JavaMethod callee = cp.lookupMethod((int)cpi, opcode);
                String calleeDesc = callee.getDeclaringClass().getName().equals(method.getDeclaringClass().getName()) ? callee.format("%n:(%P)%R") : callee.format("%H.%n:(%P)%R");
                buf.append(String.format("#%-10s // %s", cpi + ", " + stream.readUByte(bci + 3), calleeDesc));
                break;
            }
            case 186: {
                int cpi = stream.readCPI4();
                JavaMethod callee = cp.lookupMethod(cpi, opcode);
                String calleeDesc = callee.getDeclaringClass().getName().equals(method.getDeclaringClass().getName()) ? callee.format("%n:(%P)%R") : callee.format("%H.%n:(%P)%R");
                buf.append(String.format("#%-10d // %s", cpi, calleeDesc));
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                char cpi = stream.readCPI();
                Object constant = GraalServices.lookupConstant(cp, cpi, false);
                String desc = null;
                if (constant == null) {
                    desc = "<unresolved>";
                } else if (constant instanceof JavaConstant) {
                    JavaConstant c = (JavaConstant)constant;
                    desc = c.toValueString();
                } else {
                    desc = constant.toString();
                }
                if (!this.multiline) {
                    desc = desc.replaceAll("\\n", "");
                }
                buf.append(String.format("#%-10d // %s", cpi, desc));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                buf.append(String.format("%d", stream.readLocalIndex()));
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: 
            case 200: 
            case 201: {
                buf.append(String.format("%d", stream.readBranchDest()));
                break;
            }
            case 170: 
            case 171: {
                BytecodeSwitch bswitch;
                BytecodeSwitch bytecodeSwitch = bswitch = opcode == 171 ? new BytecodeLookupSwitch(stream, bci) : new BytecodeTableSwitch(stream, bci);
                if (this.multiline) {
                    buf.append("{ // " + bswitch.numberOfCases());
                    for (int i = 0; i < bswitch.numberOfCases(); ++i) {
                        buf.append(String.format("%n           %7d: %d", bswitch.keyAt(i), bswitch.targetAt(i)));
                    }
                    buf.append(String.format("%n           default: %d", bswitch.defaultTarget()));
                    buf.append(String.format("%n      }", new Object[0]));
                    break;
                }
                buf.append("[" + bswitch.numberOfCases()).append("] {");
                for (int i = 0; i < bswitch.numberOfCases(); ++i) {
                    buf.append(String.format("%d: %d", bswitch.keyAt(i), bswitch.targetAt(i)));
                    if (i == bswitch.numberOfCases() - 1) continue;
                    buf.append(", ");
                }
                buf.append(String.format("} default: %d", bswitch.defaultTarget()));
                break;
            }
            case 188: {
                int typecode = stream.readLocalIndex();
                switch (typecode) {
                    case 4: {
                        buf.append("boolean");
                        break;
                    }
                    case 5: {
                        buf.append("char");
                        break;
                    }
                    case 6: {
                        buf.append("float");
                        break;
                    }
                    case 7: {
                        buf.append("double");
                        break;
                    }
                    case 8: {
                        buf.append("byte");
                        break;
                    }
                    case 9: {
                        buf.append("short");
                        break;
                    }
                    case 10: {
                        buf.append("int");
                        break;
                    }
                    case 11: {
                        buf.append("long");
                    }
                }
                break;
            }
            case 197: {
                char cpi = stream.readCPI();
                JavaType type = cp.lookupType((int)cpi, opcode);
                buf.append(String.format("#%-10s // %s", cpi + ", " + stream.readUByte(bci + 3), type.toJavaName()));
                break;
            }
        }
    }

    public static JavaMethod getInvokedMethodAt(ResolvedJavaMethod method, int invokeBci) {
        if (method.getCode() == null) {
            return null;
        }
        ConstantPool cp = method.getConstantPool();
        BytecodeStream stream = new BytecodeStream(method.getCode());
        int opcode = stream.currentBC();
        while (opcode != 256) {
            int bci = stream.currentBCI();
            if (bci == invokeBci && stream.nextBCI() > bci + 1) {
                switch (opcode) {
                    case 182: 
                    case 183: 
                    case 184: {
                        char cpi = stream.readCPI();
                        JavaMethod callee = cp.lookupMethod((int)cpi, opcode);
                        return callee;
                    }
                    case 185: {
                        char cpi = stream.readCPI();
                        JavaMethod callee = cp.lookupMethod((int)cpi, opcode);
                        return callee;
                    }
                    case 186: {
                        int cpi = stream.readCPI4();
                        JavaMethod callee = cp.lookupMethod(cpi, opcode);
                        return callee;
                    }
                }
                throw new InternalError(BytecodeDisassembler.disassembleOne(method, invokeBci));
            }
            stream.next();
            opcode = stream.currentBC();
        }
        return null;
    }

    public static int getBytecodeAt(ResolvedJavaMethod method, int invokeBci) {
        if (method.getCode() == null) {
            return -1;
        }
        BytecodeStream stream = new BytecodeStream(method.getCode());
        int opcode = stream.currentBC();
        while (opcode != 256) {
            int bci = stream.currentBCI();
            if (bci == invokeBci) {
                return opcode;
            }
            stream.next();
            opcode = stream.currentBC();
        }
        return -1;
    }
}

