/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.GraalCompilerOptions;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionStability;
import org.graalvm.compiler.options.OptionType;

public class GraalCompilerOptions_OptionDescriptors
implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
            case "CompilationBailoutAsFailure": {
                return OptionDescriptor.create("CompilationBailoutAsFailure", OptionType.User, Boolean.class, "Treat compilation bailouts like compilation failures.", GraalCompilerOptions.class, "CompilationBailoutAsFailure", GraalCompilerOptions.CompilationBailoutAsFailure, OptionStability.STABLE, false, "");
            }
            case "CompilationFailureAction": {
                return OptionDescriptor.create("CompilationFailureAction", OptionType.User, CompilationWrapper.ExceptionAction.class, "Specifies the action to take when compilation fails.", new String[]{"", "The accepted values are:", "    Silent  - Print nothing to the console.", "     Print  - Print a stack trace to the console.", "  Diagnose* - Retry the compilation with extra diagnostics.", "    ExitVM  - Same as Diagnose except that the VM process exits after retrying.", "    ", "* If \"Diagnose\" is set compilation will be retried with extra diagnostics enabled including dumping (see file:doc-files/DumpHelp.txt). ", "  In such a scenario DiagnoseDumpLevel can be used to specify the dump level (DebugContext dump levels) accordingly.", "      "}, GraalCompilerOptions.class, "CompilationFailureAction", GraalCompilerOptions.CompilationFailureAction, OptionStability.STABLE, false, "");
            }
            case "CrashAt": {
                return OptionDescriptor.create("CrashAt", OptionType.Debug, String.class, "Pattern for method(s) that will trigger an exception when compiled. This option exists to test handling compilation crashes gracefully. See the MethodFilter option for the pattern syntax. A ':Bailout' suffix will raise a bailout exception and a ':PermanentBailout' suffix will raise a permanent bailout exception.", GraalCompilerOptions.class, "CrashAt", GraalCompilerOptions.CrashAt, OptionStability.EXPERIMENTAL, false, "");
            }
            case "InjectedCompilationDelay": {
                return OptionDescriptor.create("InjectedCompilationDelay", OptionType.Debug, Integer.class, "The number of seconds by which to slow down each compilation. The compilations slowed down can be restricted with MethodFilter. This option exists to test the compilation watchdog.", GraalCompilerOptions.class, "InjectedCompilationDelay", GraalCompilerOptions.InjectedCompilationDelay, OptionStability.EXPERIMENTAL, false, "");
            }
            case "MaxCompilationProblemsPerAction": {
                return OptionDescriptor.create("MaxCompilationProblemsPerAction", OptionType.User, Integer.class, "The maximum number of compilation failures to handle with the action specified by CompilationFailureAction before changing to a less verbose action. This does not apply to the ExitVM action.", GraalCompilerOptions.class, "MaxCompilationProblemsPerAction", GraalCompilerOptions.MaxCompilationProblemsPerAction, OptionStability.EXPERIMENTAL, false, "");
            }
            case "PrintCompilation": {
                return OptionDescriptor.create("PrintCompilation", OptionType.Debug, Boolean.class, "Print an informational line to the console for each completed compilation.", GraalCompilerOptions.class, "PrintCompilation", GraalCompilerOptions.PrintCompilation, OptionStability.STABLE, false, "");
            }
            case "SystemicCompilationFailureRate": {
                return OptionDescriptor.create("SystemicCompilationFailureRate", OptionType.User, Integer.class, "Compilation failure rate indicating a systemic compilation problem that will issue a warning. The value is made absolute and clamped to produce P, a value between 0 and 100. Systemic failure is detected if the percent of failing compilations in a sliding time window >= P. A negative value will cause the VM to exit after issuing the warning. Set to 0 to disable systemic compilation problem detection.", GraalCompilerOptions.class, "SystemicCompilationFailureRate", GraalCompilerOptions.SystemicCompilationFailureRate, OptionStability.EXPERIMENTAL, false, "");
            }
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 7;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return GraalCompilerOptions_OptionDescriptors.this.get("CompilationBailoutAsFailure");
                    }
                    case 1: {
                        return GraalCompilerOptions_OptionDescriptors.this.get("CompilationFailureAction");
                    }
                    case 2: {
                        return GraalCompilerOptions_OptionDescriptors.this.get("CrashAt");
                    }
                    case 3: {
                        return GraalCompilerOptions_OptionDescriptors.this.get("InjectedCompilationDelay");
                    }
                    case 4: {
                        return GraalCompilerOptions_OptionDescriptors.this.get("MaxCompilationProblemsPerAction");
                    }
                    case 5: {
                        return GraalCompilerOptions_OptionDescriptors.this.get("PrintCompilation");
                    }
                    case 6: {
                        return GraalCompilerOptions_OptionDescriptors.this.get("SystemicCompilationFailureRate");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

