/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.amd64;

import java.util.ListIterator;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.core.amd64.UseTrappingDivPhase;
import org.graalvm.compiler.java.DefaultSuitesCreator;
import org.graalvm.compiler.lir.amd64.phases.StackMoveOptimizationPhase;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.UseTrappingNullChecksPhase;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.phases.tiers.LowTierContext;
import org.graalvm.compiler.phases.tiers.Suites;

public abstract class AMD64SuitesCreator
extends DefaultSuitesCreator {
    public AMD64SuitesCreator(CompilerConfiguration compilerConfiguration, GraphBuilderConfiguration.Plugins plugins) {
        super(compilerConfiguration, plugins);
    }

    public AMD64SuitesCreator(CompilerConfiguration compilerConfiguration) {
        super(compilerConfiguration);
    }

    @Override
    public Suites createSuites(OptionValues options, Architecture arch) {
        Suites suites = super.createSuites(options, arch);
        ListIterator<BasePhase<LowTierContext>> position = suites.getLowTier().findPhase(UseTrappingNullChecksPhase.class);
        if (position != null) {
            position.previous();
            position.add(new UseTrappingDivPhase());
        }
        return suites;
    }

    @Override
    public LIRSuites createLIRSuites(OptionValues options) {
        LIRSuites lirSuites = super.createLIRSuites(options);
        if (StackMoveOptimizationPhase.Options.LIROptStackMoveOptimizer.getValue(options).booleanValue()) {
            lirSuites.getPostAllocationOptimizationStage().appendPhase(new StackMoveOptimizationPhase());
        }
        return lirSuites;
    }
}

