/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.amd64;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.WordBase;

@NodeInfo(cycles=NodeCycles.CYCLES_16, size=NodeSize.SIZE_4)
public class WriteProtectionKeyRegisterNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<WriteProtectionKeyRegisterNode> TYPE = NodeClass.create(WriteProtectionKeyRegisterNode.class);
    @Node.Input
    protected ValueNode value;

    public WriteProtectionKeyRegisterNode(ValueNode value) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.value = value;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.getLIRGeneratorTool().emitProtectionKeyRegisterWrite(gen.operand(this.value));
    }

    @Node.NodeIntrinsic
    public static native void writeProtectionKeyRegister(WordBase var0);
}

