/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.util;

import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;

public final class CompilationAlarm
implements AutoCloseable {
    private static final ThreadLocal<CompilationAlarm> currentAlarm = new ThreadLocal();
    private static final CompilationAlarm NEVER_EXPIRES = new CompilationAlarm(0L);
    private final long expiration;

    private CompilationAlarm(long expiration) {
        this.expiration = expiration;
    }

    public static CompilationAlarm current() {
        CompilationAlarm alarm = currentAlarm.get();
        return alarm == null ? NEVER_EXPIRES : alarm;
    }

    public boolean hasExpired() {
        return this != NEVER_EXPIRES && System.currentTimeMillis() > this.expiration;
    }

    @Override
    public void close() {
        if (this != NEVER_EXPIRES) {
            currentAlarm.set(null);
        }
    }

    public static CompilationAlarm trackCompilationPeriod(OptionValues options) {
        double period = Options.CompilationExpirationPeriod.getValue(options);
        if (period > 0.0) {
            CompilationAlarm current;
            if (Assertions.assertionsEnabled()) {
                period *= 2.0;
            }
            if (Assertions.detailedAssertionsEnabled(options)) {
                period *= 2.0;
            }
            if ((current = currentAlarm.get()) == null) {
                long expiration = System.currentTimeMillis() + (long)(period * 1000.0);
                current = new CompilationAlarm(expiration);
                currentAlarm.set(current);
                return current;
            }
        }
        return null;
    }

    public static class Options {
        public static final OptionKey<Double> CompilationExpirationPeriod = new OptionKey<Double>(300.0);
    }
}

