/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.match;

import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.match.MatchContext;
import org.graalvm.compiler.core.match.MatchStatement;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;

public class MatchPattern {
    private final Class<? extends Node> nodeClass;
    private final String name;
    private final MatchPattern[] patterns;
    private final Position[] inputs;
    private final boolean singleUser;
    private final boolean consumable;
    private final boolean ignoresSideEffects;
    private static final MatchPattern[] EMPTY_PATTERNS = new MatchPattern[0];

    public MatchPattern(String name, boolean singleUser, boolean consumable, boolean ignoresSideEffects) {
        this(null, name, singleUser, consumable, ignoresSideEffects);
    }

    public MatchPattern(Class<? extends Node> nodeClass, String name, boolean singleUser, boolean consumable, boolean ignoresSideEffects) {
        this.nodeClass = nodeClass;
        this.name = name;
        this.singleUser = singleUser;
        this.consumable = consumable;
        this.ignoresSideEffects = ignoresSideEffects;
        this.patterns = EMPTY_PATTERNS;
        this.inputs = null;
        assert (!ignoresSideEffects || FloatingNode.class.isAssignableFrom(nodeClass));
    }

    private MatchPattern(Class<? extends Node> nodeClass, String name, boolean singleUser, boolean consumable, boolean ignoresSideEffects, MatchPattern[] patterns, Position[] inputs) {
        assert (inputs == null || inputs.length == patterns.length);
        this.nodeClass = nodeClass;
        this.name = name;
        this.singleUser = singleUser;
        this.consumable = consumable;
        this.ignoresSideEffects = ignoresSideEffects;
        this.patterns = patterns;
        this.inputs = inputs;
        assert (!ignoresSideEffects || FloatingNode.class.isAssignableFrom(nodeClass));
    }

    public MatchPattern(Class<? extends Node> nodeClass, String name, MatchPattern first, Position[] inputs, boolean singleUser, boolean consumable, boolean ignoresSideEffects) {
        this(nodeClass, name, singleUser, consumable, ignoresSideEffects, new MatchPattern[]{first}, inputs);
    }

    public MatchPattern(Class<? extends Node> nodeClass, String name, MatchPattern first, MatchPattern second, Position[] inputs, boolean singleUser, boolean consumable, boolean ignoresSideEffects) {
        this(nodeClass, name, singleUser, consumable, ignoresSideEffects, new MatchPattern[]{first, second}, inputs);
    }

    public MatchPattern(Class<? extends Node> nodeClass, String name, MatchPattern first, MatchPattern second, MatchPattern third, Position[] inputs, boolean singleUser, boolean consumable, boolean ignoresSideEffects) {
        this(nodeClass, name, singleUser, consumable, ignoresSideEffects, new MatchPattern[]{first, second, third}, inputs);
    }

    Class<? extends Node> nodeClass() {
        return this.nodeClass;
    }

    private Result matchType(Node node) {
        if (this.nodeClass != null && node.getClass() != this.nodeClass) {
            return Result.wrongClass(node, this);
        }
        return Result.OK;
    }

    Result matchUsage(Node node, MatchContext context) {
        Result result = this.matchUsage(node, context, true);
        if (result == Result.OK) {
            result = context.validate();
        }
        return result;
    }

    private Result matchUsage(Node node, MatchContext context, boolean atRoot) {
        if (node instanceof OnHeapMemoryAccess && ((OnHeapMemoryAccess)((Object)node)).getBarrierType() != BarrierType.NONE) {
            return Result.barrier(node, context.getRule().getPattern());
        }
        Result result = this.matchType(node);
        if (result != Result.OK) {
            return result;
        }
        if (this.consumable && (result = context.consume(node, this.ignoresSideEffects, atRoot, this.singleUser)) != Result.OK) {
            return result;
        }
        if (this.name != null) {
            result = context.captureNamedValue(this.name, this.nodeClass, node);
        }
        for (int input = 0; input < this.patterns.length; ++input) {
            result = this.patterns[input].matchUsage(this.getInput(input, node), context, false);
            if (result == Result.OK) continue;
            return result;
        }
        return result;
    }

    public Result matchShape(Node node, MatchStatement statement) {
        return this.matchShape(node, statement, true);
    }

    private Result matchShape(Node node, MatchStatement statement, boolean atRoot) {
        Result result = this.matchType(node);
        if (result != Result.OK) {
            return result;
        }
        if (this.singleUser && !atRoot && !MatchPattern.isSingleValueUser(node)) {
            return Result.tooManyUsers(node, statement.getPattern());
        }
        for (int input = 0; input < this.patterns.length; ++input) {
            result = this.patterns[input].matchShape(this.getInput(input, node), statement, false);
            if (result == Result.OK) continue;
            return result;
        }
        return result;
    }

    public static boolean isSingleValueUser(Node node) {
        int valueUsage = node.getUsageCount();
        if (valueUsage == 1) {
            return true;
        }
        if (node.isAllowedUsageType(InputType.Guard)) {
            valueUsage = 0;
            for (Node usage : node.usages()) {
                for (Position input : usage.inputPositions()) {
                    if (input.getInputType() != InputType.Value || input.get(usage) != node || ++valueUsage <= 1) continue;
                    return false;
                }
            }
            assert (valueUsage == 1);
            return true;
        }
        return false;
    }

    public String formatMatch(Node root) {
        String result = String.format("%s", root);
        if (this.patterns.length == 0) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(result);
        for (int input = 0; input < this.patterns.length; ++input) {
            sb.append(" ");
            sb.append(this.patterns[input].formatMatch(this.getInput(input, root)));
        }
        sb.append(")");
        return sb.toString();
    }

    private Node getInput(int index, Node node) {
        return this.inputs[index].get(node);
    }

    public String toString() {
        if (this.nodeClass == null) {
            return this.name;
        }
        String nodeName = this.nodeClass.getSimpleName();
        if (nodeName.endsWith("Node")) {
            nodeName = nodeName.substring(0, nodeName.length() - 4);
        }
        if (this.patterns.length == 0) {
            return nodeName + (String)(this.name != null ? "=" + this.name : "");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(nodeName);
        for (int index = 0; index < this.patterns.length; ++index) {
            sb.append(" ");
            sb.append(this.patterns[index].toString());
        }
        sb.append(")");
        return sb.toString();
    }

    static class Result {
        final MatchResultCode code;
        final Node node;
        final MatchPattern matcher;
        private static final CounterKey MatchResult_WRONG_CLASS = DebugContext.counter("MatchResult_WRONG_CLASS");
        private static final CounterKey MatchResult_NAMED_VALUE_MISMATCH = DebugContext.counter("MatchResult_NAMED_VALUE_MISMATCH");
        private static final CounterKey MatchResult_TOO_MANY_USERS = DebugContext.counter("MatchResult_TOO_MANY_USERS");
        private static final CounterKey MatchResult_NOT_IN_BLOCK = DebugContext.counter("MatchResult_NOT_IN_BLOCK");
        private static final CounterKey MatchResult_NOT_SAFE = DebugContext.counter("MatchResult_NOT_SAFE");
        private static final CounterKey MatchResult_ALREADY_USED = DebugContext.counter("MatchResult_ALREADY_USED");
        private static final CounterKey MatchResult_TOO_LATE = DebugContext.counter("MatchResult_TOO_LATE");
        private static final CounterKey MatchResult_BARRIER = DebugContext.counter("MatchResult_BARRIER");
        static final Result OK = new Result(MatchResultCode.OK, null, null);
        private static final Result CACHED_WRONG_CLASS = new Result(MatchResultCode.WRONG_CLASS, null, null);
        private static final Result CACHED_NAMED_VALUE_MISMATCH = new Result(MatchResultCode.NAMED_VALUE_MISMATCH, null, null);
        private static final Result CACHED_TOO_MANY_USERS = new Result(MatchResultCode.TOO_MANY_USERS, null, null);
        private static final Result CACHED_NOT_IN_BLOCK = new Result(MatchResultCode.NOT_IN_BLOCK, null, null);
        private static final Result CACHED_NOT_SAFE = new Result(MatchResultCode.NOT_SAFE, null, null);
        private static final Result CACHED_ALREADY_USED = new Result(MatchResultCode.ALREADY_USED, null, null);
        private static final Result CACHED_TOO_LATE = new Result(MatchResultCode.TOO_LATE, null, null);
        private static final Result CACHED_BARRIER = new Result(MatchResultCode.BARRIER, null, null);

        Result(MatchResultCode result, Node node, MatchPattern matcher) {
            this.code = result;
            this.node = node;
            this.matcher = matcher;
        }

        static Result wrongClass(Node node, MatchPattern matcher) {
            MatchResult_WRONG_CLASS.increment(node.getDebug());
            return node.getDebug().isLogEnabled() ? new Result(MatchResultCode.WRONG_CLASS, node, matcher) : CACHED_WRONG_CLASS;
        }

        static Result namedValueMismatch(Node node, MatchPattern matcher) {
            MatchResult_NAMED_VALUE_MISMATCH.increment(node.getDebug());
            return node.getDebug().isLogEnabled() ? new Result(MatchResultCode.NAMED_VALUE_MISMATCH, node, matcher) : CACHED_NAMED_VALUE_MISMATCH;
        }

        static Result tooManyUsers(Node node, MatchPattern matcher) {
            MatchResult_TOO_MANY_USERS.increment(node.getDebug());
            return node.getDebug().isLogEnabled() ? new Result(MatchResultCode.TOO_MANY_USERS, node, matcher) : CACHED_TOO_MANY_USERS;
        }

        static Result notInBlock(Node node, MatchPattern matcher) {
            MatchResult_NOT_IN_BLOCK.increment(node.getDebug());
            return node.getDebug().isLogEnabled() ? new Result(MatchResultCode.NOT_IN_BLOCK, node, matcher) : CACHED_NOT_IN_BLOCK;
        }

        static Result notSafe(Node node, MatchPattern matcher) {
            MatchResult_NOT_SAFE.increment(node.getDebug());
            return node.getDebug().isLogEnabled() ? new Result(MatchResultCode.NOT_SAFE, node, matcher) : CACHED_NOT_SAFE;
        }

        static Result alreadyUsed(Node node, MatchPattern matcher) {
            MatchResult_ALREADY_USED.increment(node.getDebug());
            return node.getDebug().isLogEnabled() ? new Result(MatchResultCode.ALREADY_USED, node, matcher) : CACHED_ALREADY_USED;
        }

        static Result tooLate(Node node, MatchPattern matcher) {
            MatchResult_TOO_LATE.increment(node.getDebug());
            return node.getDebug().isLogEnabled() ? new Result(MatchResultCode.TOO_LATE, node, matcher) : CACHED_TOO_LATE;
        }

        static Result barrier(Node node, MatchPattern matcher) {
            MatchResult_BARRIER.increment(node.getDebug());
            return node.getDebug().isLogEnabled() ? new Result(MatchResultCode.BARRIER, node, matcher) : CACHED_BARRIER;
        }

        public String toString() {
            if (this.code == MatchResultCode.OK) {
                return "OK";
            }
            if (this.node == null) {
                return this.code.toString();
            }
            return this.code + " " + this.node.toString(Verbosity.Id) + "|" + this.node.getClass().getSimpleName() + " " + this.matcher;
        }
    }

    static enum MatchResultCode {
        OK,
        WRONG_CLASS,
        NAMED_VALUE_MISMATCH,
        TOO_MANY_USERS,
        NOT_IN_BLOCK,
        NOT_SAFE,
        ALREADY_USED,
        TOO_LATE,
        BARRIER;

    }
}

