/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.match;

import org.graalvm.compiler.core.gen.NodeLIRBuilder;
import org.graalvm.compiler.core.match.ComplexMatchResult;
import org.graalvm.compiler.core.match.MatchContext;
import org.graalvm.compiler.core.match.MatchGenerator;
import org.graalvm.compiler.core.match.MatchPattern;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.graph.GraalGraphError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;

public class MatchStatement {
    private static final CounterKey MatchStatementSuccess = DebugContext.counter("MatchStatementSuccess");
    private final String name;
    private final MatchPattern pattern;
    private MatchGenerator generatorMethod;
    private String[] arguments;

    public MatchStatement(String name, MatchPattern pattern, MatchGenerator generator, String[] arguments) {
        this.name = name;
        this.pattern = pattern;
        this.generatorMethod = generator;
        this.arguments = arguments;
    }

    public boolean generate(NodeLIRBuilder builder, int index, Node node, HIRBlock block, StructuredGraph.ScheduleResult schedule) {
        DebugContext debug = node.getDebug();
        assert (index == schedule.getBlockToNodesMap().get(block).indexOf(node));
        MatchPattern.Result result = this.pattern.matchShape(node, this);
        if (result != MatchPattern.Result.OK) {
            return false;
        }
        MatchContext context = new MatchContext(builder, this, index, node, block, schedule);
        result = this.pattern.matchUsage(node, context);
        if (result == MatchPattern.Result.OK) {
            ComplexMatchResult value = this.generatorMethod.match(builder.getNodeMatchRules(), this.buildArgList(context));
            if (value != null) {
                context.setResult(value);
                MatchStatementSuccess.increment(debug);
                DebugContext.counter("MatchStatement[%s]", this.getName()).increment(debug);
                return true;
            }
            if (DebugOptions.LogVerbose.getValue(node.getOptions()).booleanValue()) {
                debug.log("while matching %s|%s %s %s returned null", (Object)context.getRoot().toString(Verbosity.Id), (Object)context.getRoot().getClass().getSimpleName(), (Object)this.getName(), (Object)this.generatorMethod.getName());
                debug.log("with nodes %s", (Object)this.formatMatch(node));
            }
        } else if (DebugOptions.LogVerbose.getValue(node.getOptions()).booleanValue() && result.code != MatchPattern.MatchResultCode.WRONG_CLASS) {
            debug.log("while matching %s|%s %s %s", (Object)context.getRoot().toString(Verbosity.Id), (Object)context.getRoot().getClass().getSimpleName(), (Object)this.getName(), (Object)result);
        }
        return false;
    }

    private Object[] buildArgList(MatchContext context) {
        Object[] result = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            if ("root".equals(this.arguments[i])) {
                result[i] = context.getRoot();
                continue;
            }
            result[i] = context.namedNode(this.arguments[i]);
            if (result[i] != null) continue;
            throw new GraalGraphError("Can't find named node %s", this.arguments[i]);
        }
        return result;
    }

    public String formatMatch(Node root) {
        return this.pattern.formatMatch(root);
    }

    public MatchPattern getPattern() {
        return this.pattern;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.pattern.toString();
    }
}

