/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.phases;

import org.graalvm.compiler.core.phases.BaseTier;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.phases.PlaceholderPhase;
import org.graalvm.compiler.phases.common.AddressLoweringPhase;
import org.graalvm.compiler.phases.common.BarrierSetVerificationPhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.ExpandLogicPhase;
import org.graalvm.compiler.phases.common.LowTierLoweringPhase;
import org.graalvm.compiler.phases.common.RemoveOpaqueValuePhase;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.phases.tiers.LowTierContext;

public class EconomyLowTier
extends BaseTier<LowTierContext> {
    public EconomyLowTier() {
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
        this.appendPhase(new LowTierLoweringPhase(canonicalizer));
        this.appendPhase(new ExpandLogicPhase(canonicalizer));
        if (Assertions.assertionsEnabled()) {
            this.appendPhase(new BarrierSetVerificationPhase());
        }
        this.appendPhase(new PlaceholderPhase(AddressLoweringPhase.class));
        this.appendPhase(new RemoveOpaqueValuePhase());
        this.appendPhase(new SchedulePhase(SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS));
    }
}

