/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.MethodFilter;

final class DebugFilter {
    private final Term[] terms;

    public static DebugFilter parse(String spec) {
        if (spec == null) {
            return null;
        }
        return new DebugFilter(spec.split(","));
    }

    private DebugFilter(String[] terms) {
        if (terms.length == 0) {
            this.terms = null;
        } else {
            this.terms = new Term[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                int level;
                String pattern;
                String t = terms[i];
                int idx = t.indexOf(58);
                if (idx < 0) {
                    if (t.startsWith("~")) {
                        pattern = t.substring(1);
                        level = 0;
                    } else {
                        pattern = t;
                        level = 1;
                    }
                } else {
                    pattern = t.substring(0, idx);
                    if (idx + 1 < t.length()) {
                        String levelString = t.substring(idx + 1);
                        try {
                            level = Integer.parseInt(levelString);
                        }
                        catch (NumberFormatException e) {
                            switch (levelString) {
                                case "basic": {
                                    level = 1;
                                    break;
                                }
                                case "info": {
                                    level = 2;
                                    break;
                                }
                                case "verbose": {
                                    level = 3;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unknown dump level: \"" + levelString + "\" expected basic, info, verbose or an integer");
                                }
                            }
                        }
                    } else {
                        level = 1;
                    }
                }
                this.terms[i] = new Term(pattern, level);
            }
        }
    }

    public int matchLevel(DebugContext.Scope scope) {
        if (this.terms == null) {
            return 1;
        }
        int defaultLevel = 0;
        int level = -1;
        String input = null;
        for (Term t : this.terms) {
            if (t.isMatchAny()) {
                defaultLevel = t.level;
                continue;
            }
            if (input == null) {
                input = scope.getQualifiedName();
            }
            if (!t.matches(input)) continue;
            level = t.level;
        }
        return level == -1 ? defaultLevel : level;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("DebugFilter");
        if (this.terms != null) {
            buf.append(Arrays.toString(this.terms));
        } else {
            buf.append("[]");
        }
        return buf.toString();
    }

    private static class Term {
        private final Pattern pattern;
        public final int level;

        Term(String filter, int level) {
            this.level = level;
            this.pattern = filter.isEmpty() || filter.equals("*") ? null : (filter.contains("*") || filter.contains("?") ? Pattern.compile(MethodFilter.createGlobString(filter)) : Pattern.compile(".*" + MethodFilter.createGlobString(filter) + ".*"));
        }

        public boolean matches(String input) {
            return this.pattern == null || this.pattern.matcher(input).matches();
        }

        public boolean isMatchAny() {
            return this.pattern == null;
        }

        public String toString() {
            return (this.pattern == null ? ".*" : this.pattern.toString()) + ":" + this.level;
        }
    }
}

