/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionStability;
import org.graalvm.compiler.options.OptionType;

public class DebugOptions_OptionDescriptors
implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
            case "AggregatedMetricsFile": {
                return OptionDescriptor.create("AggregatedMetricsFile", OptionType.Debug, String.class, "File to which aggregated metrics are dumped at shutdown. A CSV format is used if the file ends with .csv otherwise a more human readable format is used. If not specified, metrics are dumped to the console.", DebugOptions.class, "AggregatedMetricsFile", DebugOptions.AggregatedMetricsFile, OptionStability.EXPERIMENTAL, false, "");
            }
            case "BootstrapInitializeOnly": {
                return OptionDescriptor.create("BootstrapInitializeOnly", OptionType.Debug, Boolean.class, "Do not compile anything on bootstrap but just initialize the compiler.", DebugOptions.class, "BootstrapInitializeOnly", DebugOptions.BootstrapInitializeOnly, OptionStability.EXPERIMENTAL, false, "");
            }
            case "CanonicalGraphStringsCheckConstants": {
                return OptionDescriptor.create("CanonicalGraphStringsCheckConstants", OptionType.Debug, Boolean.class, "Exclude virtual nodes when dumping canonical text for graphs.", DebugOptions.class, "CanonicalGraphStringsCheckConstants", DebugOptions.CanonicalGraphStringsCheckConstants, OptionStability.EXPERIMENTAL, false, "");
            }
            case "CanonicalGraphStringsExcludeVirtuals": {
                return OptionDescriptor.create("CanonicalGraphStringsExcludeVirtuals", OptionType.Debug, Boolean.class, "Exclude virtual nodes when dumping canonical text for graphs.", DebugOptions.class, "CanonicalGraphStringsExcludeVirtuals", DebugOptions.CanonicalGraphStringsExcludeVirtuals, OptionStability.EXPERIMENTAL, false, "");
            }
            case "CanonicalGraphStringsRemoveIdentities": {
                return OptionDescriptor.create("CanonicalGraphStringsRemoveIdentities", OptionType.Debug, Boolean.class, "Attempts to remove object identity hashes when dumping canonical text for graphs.", DebugOptions.class, "CanonicalGraphStringsRemoveIdentities", DebugOptions.CanonicalGraphStringsRemoveIdentities, OptionStability.EXPERIMENTAL, false, "");
            }
            case "ClearMetricsAfterBootstrap": {
                return OptionDescriptor.create("ClearMetricsAfterBootstrap", OptionType.Debug, Boolean.class, "Clear the debug metrics after bootstrap.", DebugOptions.class, "ClearMetricsAfterBootstrap", DebugOptions.ClearMetricsAfterBootstrap, OptionStability.EXPERIMENTAL, false, "");
            }
            case "Count": {
                return OptionDescriptor.create("Count", OptionType.Debug, String.class, "Pattern for specifying scopes in which counters are enabled. See the Dump option for the pattern syntax. An empty value enables all counters unconditionally.", DebugOptions.class, "Count", DebugOptions.Count, OptionStability.EXPERIMENTAL, false, "");
            }
            case "Counters": {
                return OptionDescriptor.create("Counters", OptionType.Debug, String.class, "Comma separated names of counters that are enabled irrespective of the value for Count option. An empty value enables all counters unconditionally.", DebugOptions.class, "Counters", DebugOptions.Counters, OptionStability.EXPERIMENTAL, false, "");
            }
            case "DebugStubsAndSnippets": {
                return OptionDescriptor.create("DebugStubsAndSnippets", OptionType.Debug, Boolean.class, "Enable debug output for stub code generation and snippet preparation.", DebugOptions.class, "DebugStubsAndSnippets", DebugOptions.DebugStubsAndSnippets, OptionStability.EXPERIMENTAL, false, "");
            }
            case "DiagnoseDumpLevel": {
                return OptionDescriptor.create("DiagnoseDumpLevel", OptionType.Debug, Integer.class, "Specify the dump level if CompilationFailureAction#Diagnose is used.See CompilationFailureAction for details. file:doc-files/CompilationFailureActionHelp.txt", DebugOptions.class, "DiagnoseDumpLevel", DebugOptions.DiagnoseDumpLevel, OptionStability.EXPERIMENTAL, false, "");
            }
            case "DisableIntercept": {
                return OptionDescriptor.create("DisableIntercept", OptionType.Debug, Boolean.class, "Disable intercepting exceptions in debug scopes.", DebugOptions.class, "DisableIntercept", DebugOptions.DisableIntercept, OptionStability.EXPERIMENTAL, false, "");
            }
            case "Dump": {
                return OptionDescriptor.create("Dump", OptionType.Debug, String.class, "Filter pattern for specifying scopes in which dumping is enabled.", new String[]{"", "A filter is a list of comma-separated terms of the form:", " ", "  <pattern>[:<level>]", " ", "If <pattern> contains a \"*\" or \"?\" character, it is interpreted as a glob pattern.", "Otherwise, it is interpreted as a substring. If <pattern> is empty, it", "matches every scope. If :<level> is omitted, it defaults to 1. The term", "~<pattern> is a shorthand for <pattern>:0 to disable a debug facility for a pattern.", "", "The default log level is 0 (disabled). Terms with an empty pattern set", "the default log level to the specified value. The last", "matching term with a non-empty pattern selects the level specified. If", "no term matches, the log level is the default level. A filter with no", "terms matches every scope with a log level of 1.", "", "Examples of debug filters:", "--------- ", "  (empty string)", "", "  Matches any scope with level 1.", "--------- ", "  :1", "", "  Matches any scope with level 1.", "--------- ", "  *", "", "  Matches any scope with level 1.", "--------- ", "  CodeGen,CodeInstall", "", "  Matches scopes containing \"CodeGen\" or \"CodeInstall\", both with level 1.", "--------- ", "  CodeGen:2,CodeInstall:1", "", "  Matches scopes containing \"CodeGen\" with level 2, or \"CodeInstall\" with level 1.", "---------", "  Outer:2,Inner:0}", "", "  Matches scopes containing \"Outer\" with log level 2, or \"Inner\" with log level 0. If the scope", "  name contains both patterns then the log level will be 0. This is useful for silencing subscopes.", "---------", "  :1,Dead:2", "", "  Matches scopes containing \"Dead\" with level 2, and all other scopes with level 1.", "--------- ", "  Dead:0,:1", "", "  Matches all scopes with level 1, except those containing \"Dead\".   Note that the location of", "  the :1 doesn't matter since it's specifying the default log level so it's the same as", "  specifying :1,Dead:0.", "--------- ", "  Code*", "", "  Matches scopes starting with \"Code\" with level 1.", "--------- ", "  Code,~Dead", "", "  Matches scopes containing \"Code\" but not \"Dead\", with level 1."}, DebugOptions.class, "Dump", DebugOptions.Dump, OptionStability.STABLE, false, "");
            }
            case "DumpOnError": {
                return OptionDescriptor.create("DumpOnError", OptionType.Debug, Boolean.class, "Send compiler IR to dump handlers on error.", DebugOptions.class, "DumpOnError", DebugOptions.DumpOnError, OptionStability.EXPERIMENTAL, false, "");
            }
            case "DumpOnPhaseChange": {
                return OptionDescriptor.create("DumpOnPhaseChange", OptionType.Debug, String.class, "Dump a before and after graph if the named phase changes the graph.%nThe argument is substring matched against the simple name of the phase class", DebugOptions.class, "DumpOnPhaseChange", DebugOptions.DumpOnPhaseChange, OptionStability.EXPERIMENTAL, false, "");
            }
            case "DumpPath": {
                return OptionDescriptor.create("DumpPath", OptionType.Debug, String.class, "The directory where various Graal dump files are written.", DebugOptions.class, "DumpPath", DebugOptions.DumpPath, OptionStability.EXPERIMENTAL, false, "");
            }
            case "DumpingErrorsAreFatal": {
                return OptionDescriptor.create("DumpingErrorsAreFatal", OptionType.Debug, Boolean.class, "Treat any exceptions during dumping as fatal.", DebugOptions.class, "DumpingErrorsAreFatal", DebugOptions.DumpingErrorsAreFatal, OptionStability.EXPERIMENTAL, false, "");
            }
            case "InterceptBailout": {
                return OptionDescriptor.create("InterceptBailout", OptionType.Debug, Boolean.class, "Intercept also bailout exceptions", DebugOptions.class, "InterceptBailout", DebugOptions.InterceptBailout, OptionStability.EXPERIMENTAL, false, "");
            }
            case "ListMetrics": {
                return OptionDescriptor.create("ListMetrics", OptionType.Debug, Boolean.class, "Lists on the console at VM shutdown the metric names available to the Timers, Counters and MemUseTrackers options. Note that this only lists the metrics that were initialized during the VM execution and so will not include metrics for compiler code that is not executed.", DebugOptions.class, "ListMetrics", DebugOptions.ListMetrics, OptionStability.EXPERIMENTAL, false, "");
            }
            case "Log": {
                return OptionDescriptor.create("Log", OptionType.Debug, String.class, "Pattern for specifying scopes in which logging is enabled. See the Dump option for the pattern syntax.", DebugOptions.class, "Log", DebugOptions.Log, OptionStability.EXPERIMENTAL, false, "");
            }
            case "LogVerbose": {
                return OptionDescriptor.create("LogVerbose", OptionType.Debug, Boolean.class, "Enable more verbose log output when available", DebugOptions.class, "LogVerbose", DebugOptions.LogVerbose, OptionStability.EXPERIMENTAL, false, "");
            }
            case "MemUseTrackers": {
                return OptionDescriptor.create("MemUseTrackers", OptionType.Debug, String.class, "Comma separated names of memory usage trackers that are enabled irrespective of the value for TrackMemUse option. An empty value enables all memory usage trackers unconditionally.", DebugOptions.class, "MemUseTrackers", DebugOptions.MemUseTrackers, OptionStability.EXPERIMENTAL, false, "");
            }
            case "MethodFilter": {
                return OptionDescriptor.create("MethodFilter", OptionType.Debug, String.class, "Pattern for matching methods. The syntax for a pattern is:", new String[]{"", "  SourcePatterns = SourcePattern [\",\" SourcePatterns] .", "  SourcePattern = [ \"~\" ] [ Class \".\" ] method [ \"(\" [ Parameter { \";\" Parameter } ] \")\" ] .", "  Parameter = Class | \"int\" | \"long\" | \"float\" | \"double\" | \"short\" | \"char\" | \"boolean\" .", "  Class = { package \".\" } class .", "", "Glob pattern matching (*, ?) is allowed in all parts of the source pattern.", "The \"~\" prefix negates the pattern.", "", "Positive patterns are joined by an \"or\" operator: \"A,B\" matches anything", "matched by \"A\" or \"B\". Negative patterns are joined by \"and not\": \"~A,~B\"", "matches anything not matched by \"A\" and not matched by \"B\". \"A,~B,~C,D\"", "matches anything matched by \"A\" or \"D\" and not matched by \"B\" and not", "matched by \"C\".", "", "A set of patterns containing negative patterns but no positive ones contains", "an implicit positive \"*\" pattern: \"~A,~B\" is equivalent to \"*,~A,~B\".", "", "Examples of method filters:", "---------", "  *", "", "  Matches all methods in all classes.", "---------", "  canonical(CanonicalizerTool;LogicNode;LogicNode)", "", "  Matches all methods named \"canonical\", with the first parameter of type", "  \"CanonicalizerTool\", and the second and third parameters of type", "  \"LogicNode\".", "  The packages of the parameter types are irrelevant.", "---------", "  arraycopy(Object;;;;)", "", "  Matches all methods named \"arraycopy\", with the first parameter", "  of type \"Object\", and four more parameters of any type. The", "  packages of the parameter types are irrelevant.", "---------", "  List.set", "", "  Matches all methods named \"set\" in a class whose simple name is \"List\".", "---------", "  *List.set", "", "  Matches all methods named \"set\" in a class whose simple name ends with \"List\".", "---------", "  org.graalvm.compiler.nodes.PhiNode.*", "", "  Matches all methods in the class \"org.graalvm.compiler.nodes.PhiNode\".", "---------", "  org.graalvm.compiler.nodes.*.canonical", "", "  Matches all methods named \"canonical\" in classes in the package", "  \"org.graalvm.compiler.nodes\".", "---------", "  arraycopy,toString", "", "  Matches all methods named \"arraycopy\" or \"toString\", meaning that ',' acts", "  as an \"or\" operator.", "---------", "  java.util.*.*.,~java.util.*Array*.*", "  java.util.*.*.,~*Array*.*", "", "  These patterns are equivalent and match all methods in the package", "  \"java.util\" except for classes that have \"Array\" in their name.", "---------", "  ~java.util.*.*", "", "  Matches all methods in all classes in all packages except for anything in", "  the \"java.util\" package."}, DebugOptions.class, "MethodFilter", DebugOptions.MethodFilter, OptionStability.STABLE, false, "");
            }
            case "MethodFilterRootOnly": {
                return OptionDescriptor.create("MethodFilterRootOnly", OptionType.Debug, Boolean.class, "Only check MethodFilter against the root method in the context if true, otherwise check all methods", DebugOptions.class, "MethodFilterRootOnly", DebugOptions.MethodFilterRootOnly, OptionStability.EXPERIMENTAL, false, "");
            }
            case "MetricsFile": {
                return OptionDescriptor.create("MetricsFile", OptionType.Debug, String.class, "File to which metrics are dumped per compilation.", new String[]{"A CSV format is used if the file ends with .csv otherwise a more", "human readable format is used. The fields in the CSV format are:", "           compilable - method being compiled", "  compilable_identity - identity hash code of compilable", "       compilation_nr - where this compilation lies in the ordered", "                        sequence of all compilations identified by", "                        compilable_identity", "       compilation_id - runtime issued identifier for the compilation", "          metric_name - name of metric", "         metric_value - value of metric"}, DebugOptions.class, "MetricsFile", DebugOptions.MetricsFile, OptionStability.EXPERIMENTAL, false, "");
            }
            case "OptimizationLog": {
                return OptionDescriptor.create("OptimizationLog", OptionType.Debug, EconomicSet.class, "Enable the structured optimization log and specify where it is printed.", new String[]{"The accepted values are:", "  Directory - Format the structured optimization log as JSON and print it to files in a directory.", "              The directory is specified by OptimizationLogPath. If OptimizationLogPath is not set,", "              the target directory is DumpPath/optimization_log.", "     Stdout - Print the structured optimization log to the standard output.", "       Dump - Dump optimization trees for IdealGraphVisualizer according to the PrintGraph option.", "It is possible to specify multiple comma-separated values."}, DebugOptions.class, "OptimizationLog", DebugOptions.OptimizationLog, OptionStability.EXPERIMENTAL, false, "");
            }
            case "OptimizationLogPath": {
                return OptionDescriptor.create("OptimizationLogPath", OptionType.Debug, String.class, "Path to the directory where the optimization log is saved if OptimizationLog is set to Directory. Directories are created if they do no exist.", DebugOptions.class, "OptimizationLogPath", DebugOptions.OptimizationLogPath, OptionStability.EXPERIMENTAL, false, "");
            }
            case "PrintBBInfo": {
                return OptionDescriptor.create("PrintBBInfo", OptionType.Debug, Boolean.class, "Enables dumping of basic blocks relative PC and frequencies in the dump directory.", DebugOptions.class, "PrintBBInfo", DebugOptions.PrintBBInfo, OptionStability.EXPERIMENTAL, false, "");
            }
            case "PrintBackendCFG": {
                return OptionDescriptor.create("PrintBackendCFG", OptionType.Debug, Boolean.class, "Enable dumping scheduled HIR, LIR, register allocation and code generation info to the C1Visualizer.", DebugOptions.class, "PrintBackendCFG", DebugOptions.PrintBackendCFG, OptionStability.EXPERIMENTAL, false, "");
            }
            case "PrintBlockMapping": {
                return OptionDescriptor.create("PrintBlockMapping", OptionType.Debug, Boolean.class, "Enable dumping CFG built during initial BciBlockMapping", DebugOptions.class, "PrintBlockMapping", DebugOptions.PrintBlockMapping, OptionStability.EXPERIMENTAL, false, "");
            }
            case "PrintCanonicalGraphStringFlavor": {
                return OptionDescriptor.create("PrintCanonicalGraphStringFlavor", OptionType.Debug, Integer.class, "Choose format used when dumping canonical text for graphs: 0 gives a scheduled graph (better for spotting changes involving the schedule) while 1 gives a CFG containing expressions rooted at fixed nodes (better for spotting small structure differences)", DebugOptions.class, "PrintCanonicalGraphStringFlavor", DebugOptions.PrintCanonicalGraphStringFlavor, OptionStability.EXPERIMENTAL, false, "");
            }
            case "PrintCanonicalGraphStrings": {
                return OptionDescriptor.create("PrintCanonicalGraphStrings", OptionType.Debug, Boolean.class, "Enable dumping canonical text from for graphs.", DebugOptions.class, "PrintCanonicalGraphStrings", DebugOptions.PrintCanonicalGraphStrings, OptionStability.EXPERIMENTAL, false, "");
            }
            case "PrintGraph": {
                return OptionDescriptor.create("PrintGraph", OptionType.Debug, DebugOptions.PrintGraphTarget.class, "Where IdealGraphVisualizer graph dumps triggered by Dump or DumpOnError should be written.", new String[]{"The accepted values are:", "      File - Dump IGV graphs to the local file system (see DumpPath).", "   Network - Dump IGV graphs to the network destination specified by PrintGraphHost and PrintGraphPort.", "             If a network connection cannot be opened, dumping falls back to file dumping. ", "   Disable - Do not dump IGV graphs."}, DebugOptions.class, "PrintGraph", DebugOptions.PrintGraph, OptionStability.EXPERIMENTAL, false, "");
            }
            case "PrintGraphFile": {
                return OptionDescriptor.create("PrintGraphFile", OptionType.Debug, Boolean.class, "Setting to true sets PrintGraph=file, setting to false sets PrintGraph=network", DebugOptions.class, "PrintGraphFile", DebugOptions.PrintGraphFile, OptionStability.EXPERIMENTAL, false, "");
            }
            case "PrintGraphHost": {
                return OptionDescriptor.create("PrintGraphHost", OptionType.Debug, String.class, "Host part of the address to which graphs are dumped.", DebugOptions.class, "PrintGraphHost", DebugOptions.PrintGraphHost, OptionStability.EXPERIMENTAL, false, "");
            }
            case "PrintGraphPort": {
                return OptionDescriptor.create("PrintGraphPort", OptionType.Debug, Integer.class, "Port part of the address to which graphs are dumped in binary format.", DebugOptions.class, "PrintGraphPort", DebugOptions.PrintGraphPort, OptionStability.EXPERIMENTAL, false, "");
            }
            case "PrintGraphWithSchedule": {
                return OptionDescriptor.create("PrintGraphWithSchedule", OptionType.Debug, Boolean.class, "Schedule graphs as they are dumped.", DebugOptions.class, "PrintGraphWithSchedule", DebugOptions.PrintGraphWithSchedule, OptionStability.EXPERIMENTAL, false, "");
            }
            case "PrintUnmodifiedGraphs": {
                return OptionDescriptor.create("PrintUnmodifiedGraphs", OptionType.Debug, Boolean.class, "Dump a graph even if it has not changed since it was last dumped.  Change detection is based on adding and deleting nodes or changing inputs.", DebugOptions.class, "PrintUnmodifiedGraphs", DebugOptions.PrintUnmodifiedGraphs, OptionStability.EXPERIMENTAL, false, "");
            }
            case "ShowDumpFiles": {
                return OptionDescriptor.create("ShowDumpFiles", OptionType.Debug, Boolean.class, "Print the name of each dump file path as it's created.", DebugOptions.class, "ShowDumpFiles", DebugOptions.ShowDumpFiles, OptionStability.EXPERIMENTAL, false, "");
            }
            case "Time": {
                return OptionDescriptor.create("Time", OptionType.Debug, String.class, "Pattern for specifying scopes in which timing is enabled. See the Dump option for the pattern syntax. An empty value enables all timers unconditionally.", DebugOptions.class, "Time", DebugOptions.Time, OptionStability.EXPERIMENTAL, false, "");
            }
            case "Timers": {
                return OptionDescriptor.create("Timers", OptionType.Debug, String.class, "Comma separated names of timers that are enabled irrespective of the value for Time option. An empty value enables all timers unconditionally.", DebugOptions.class, "Timers", DebugOptions.Timers, OptionStability.EXPERIMENTAL, false, "");
            }
            case "TrackMemUse": {
                return OptionDescriptor.create("TrackMemUse", OptionType.Debug, String.class, "Pattern for specifying scopes in which memory use tracking is enabled. See the Dump option for the pattern syntax. An empty value enables all memory use trackers unconditionally.", DebugOptions.class, "TrackMemUse", DebugOptions.TrackMemUse, OptionStability.EXPERIMENTAL, false, "");
            }
            case "Verify": {
                return OptionDescriptor.create("Verify", OptionType.Debug, String.class, "Pattern for specifying scopes in which logging is enabled. See the Dump option for the pattern syntax.", DebugOptions.class, "Verify", DebugOptions.Verify, OptionStability.EXPERIMENTAL, false, "");
            }
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 42;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return DebugOptions_OptionDescriptors.this.get("AggregatedMetricsFile");
                    }
                    case 1: {
                        return DebugOptions_OptionDescriptors.this.get("BootstrapInitializeOnly");
                    }
                    case 2: {
                        return DebugOptions_OptionDescriptors.this.get("CanonicalGraphStringsCheckConstants");
                    }
                    case 3: {
                        return DebugOptions_OptionDescriptors.this.get("CanonicalGraphStringsExcludeVirtuals");
                    }
                    case 4: {
                        return DebugOptions_OptionDescriptors.this.get("CanonicalGraphStringsRemoveIdentities");
                    }
                    case 5: {
                        return DebugOptions_OptionDescriptors.this.get("ClearMetricsAfterBootstrap");
                    }
                    case 6: {
                        return DebugOptions_OptionDescriptors.this.get("Count");
                    }
                    case 7: {
                        return DebugOptions_OptionDescriptors.this.get("Counters");
                    }
                    case 8: {
                        return DebugOptions_OptionDescriptors.this.get("DebugStubsAndSnippets");
                    }
                    case 9: {
                        return DebugOptions_OptionDescriptors.this.get("DiagnoseDumpLevel");
                    }
                    case 10: {
                        return DebugOptions_OptionDescriptors.this.get("DisableIntercept");
                    }
                    case 11: {
                        return DebugOptions_OptionDescriptors.this.get("Dump");
                    }
                    case 12: {
                        return DebugOptions_OptionDescriptors.this.get("DumpOnError");
                    }
                    case 13: {
                        return DebugOptions_OptionDescriptors.this.get("DumpOnPhaseChange");
                    }
                    case 14: {
                        return DebugOptions_OptionDescriptors.this.get("DumpPath");
                    }
                    case 15: {
                        return DebugOptions_OptionDescriptors.this.get("DumpingErrorsAreFatal");
                    }
                    case 16: {
                        return DebugOptions_OptionDescriptors.this.get("InterceptBailout");
                    }
                    case 17: {
                        return DebugOptions_OptionDescriptors.this.get("ListMetrics");
                    }
                    case 18: {
                        return DebugOptions_OptionDescriptors.this.get("Log");
                    }
                    case 19: {
                        return DebugOptions_OptionDescriptors.this.get("LogVerbose");
                    }
                    case 20: {
                        return DebugOptions_OptionDescriptors.this.get("MemUseTrackers");
                    }
                    case 21: {
                        return DebugOptions_OptionDescriptors.this.get("MethodFilter");
                    }
                    case 22: {
                        return DebugOptions_OptionDescriptors.this.get("MethodFilterRootOnly");
                    }
                    case 23: {
                        return DebugOptions_OptionDescriptors.this.get("MetricsFile");
                    }
                    case 24: {
                        return DebugOptions_OptionDescriptors.this.get("OptimizationLog");
                    }
                    case 25: {
                        return DebugOptions_OptionDescriptors.this.get("OptimizationLogPath");
                    }
                    case 26: {
                        return DebugOptions_OptionDescriptors.this.get("PrintBBInfo");
                    }
                    case 27: {
                        return DebugOptions_OptionDescriptors.this.get("PrintBackendCFG");
                    }
                    case 28: {
                        return DebugOptions_OptionDescriptors.this.get("PrintBlockMapping");
                    }
                    case 29: {
                        return DebugOptions_OptionDescriptors.this.get("PrintCanonicalGraphStringFlavor");
                    }
                    case 30: {
                        return DebugOptions_OptionDescriptors.this.get("PrintCanonicalGraphStrings");
                    }
                    case 31: {
                        return DebugOptions_OptionDescriptors.this.get("PrintGraph");
                    }
                    case 32: {
                        return DebugOptions_OptionDescriptors.this.get("PrintGraphFile");
                    }
                    case 33: {
                        return DebugOptions_OptionDescriptors.this.get("PrintGraphHost");
                    }
                    case 34: {
                        return DebugOptions_OptionDescriptors.this.get("PrintGraphPort");
                    }
                    case 35: {
                        return DebugOptions_OptionDescriptors.this.get("PrintGraphWithSchedule");
                    }
                    case 36: {
                        return DebugOptions_OptionDescriptors.this.get("PrintUnmodifiedGraphs");
                    }
                    case 37: {
                        return DebugOptions_OptionDescriptors.this.get("ShowDumpFiles");
                    }
                    case 38: {
                        return DebugOptions_OptionDescriptors.this.get("Time");
                    }
                    case 39: {
                        return DebugOptions_OptionDescriptors.this.get("Timers");
                    }
                    case 40: {
                        return DebugOptions_OptionDescriptors.this.get("TrackMemUse");
                    }
                    case 41: {
                        return DebugOptions_OptionDescriptors.this.get("Verify");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

