/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.PrintStream;
import org.graalvm.compiler.debug.LogStream;
import org.graalvm.compiler.debug.TTYStreamProvider;
import org.graalvm.compiler.serviceprovider.GraalServices;

public class TTY {
    public static final PrintStream out;
    private static final ThreadLocal<LogStream> log;

    public static boolean isSuppressed() {
        return log.get() == LogStream.SINK;
    }

    public static LogStream out() {
        return log.get();
    }

    public static void print(String s) {
        TTY.out().print(s);
    }

    public static void print(int i) {
        TTY.out().print(i);
    }

    public static void print(long i) {
        TTY.out().print(i);
    }

    public static void print(char c) {
        TTY.out().print(c);
    }

    public static void print(boolean b) {
        TTY.out().print(b);
    }

    public static void print(double d) {
        TTY.out().print(d);
    }

    public static void print(float f) {
        TTY.out().print(f);
    }

    public static void println(String s) {
        TTY.out().println(s);
    }

    public static void println() {
        TTY.out().println();
    }

    public static void println(int i) {
        TTY.out().println(i);
    }

    public static void println(long l) {
        TTY.out().println(l);
    }

    public static void println(char c) {
        TTY.out().println(c);
    }

    public static void println(boolean b) {
        TTY.out().println(b);
    }

    public static void println(double d) {
        TTY.out().println(d);
    }

    public static void println(float f) {
        TTY.out().println(f);
    }

    public static void printf(String format, Object ... args) {
        TTY.out().printf(format, args);
    }

    public static void println(String format, Object ... args) {
        TTY.out().printf(format + "%n", args);
    }

    public static void fillTo(int i) {
        TTY.out().fillTo(i, ' ');
    }

    public static void flush() {
        TTY.out().flush();
    }

    static {
        TTYStreamProvider p = GraalServices.loadSingle(TTYStreamProvider.class, false);
        out = p == null ? System.out : p.getStream();
        log = new ThreadLocal<LogStream>(){

            @Override
            protected LogStream initialValue() {
                return new LogStream(out);
            }
        };
    }

    public static class Filter
    implements AutoCloseable {
        private LogStream previous;
        private final Thread thread = Thread.currentThread();

        public Filter() {
            this.previous = TTY.out();
            log.set(LogStream.SINK);
        }

        public Filter(LogStream newStream) {
            this.previous = TTY.out();
            log.set(newStream);
        }

        public void remove() {
            assert (this.thread == Thread.currentThread());
            if (this.previous != null) {
                log.set(this.previous);
            }
        }

        @Override
        public void close() {
            this.remove();
        }
    }
}

