/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import java.util.Iterator;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;

class GraphNodeIterator
implements Iterator<Node> {
    private final Graph graph;
    private int index;

    GraphNodeIterator(Graph graph) {
        this(graph, 0);
    }

    GraphNodeIterator(Graph graph, int index) {
        this.graph = graph;
        this.index = index - 1;
        this.forward();
    }

    private void forward() {
        if (this.index < this.graph.nodesSize) {
            do {
                ++this.index;
            } while (this.index < this.graph.nodesSize && this.graph.nodes[this.index] == null);
        }
    }

    @Override
    public boolean hasNext() {
        this.checkForDeletedNode();
        return this.index < this.graph.nodesSize;
    }

    private void checkForDeletedNode() {
        while (this.index < this.graph.nodesSize && this.graph.nodes[this.index] == null) {
            ++this.index;
        }
    }

    @Override
    public Node next() {
        try {
            Node node = this.graph.nodes[this.index];
            return node;
        }
        finally {
            this.forward();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

