/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hightiercodegen;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hightiercodegen.CodeBuffer;
import org.graalvm.compiler.hightiercodegen.Emitter;
import org.graalvm.compiler.hightiercodegen.IEmitter;
import org.graalvm.compiler.hightiercodegen.Keyword;
import org.graalvm.compiler.hightiercodegen.NodeLowerer;
import org.graalvm.compiler.hightiercodegen.variables.ResolvedVar;
import org.graalvm.compiler.hightiercodegen.variables.VariableAllocation;
import org.graalvm.compiler.hightiercodegen.variables.VariableMap;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;

public abstract class CodeGenTool {
    protected final CodeBuffer codeBuffer;
    public VariableMap variableMap;
    protected final VariableAllocation variableAllocation;
    private int methodScopeUniqueID = 0;

    protected CodeGenTool(CodeBuffer codeBuffer, VariableAllocation variableAllocation) {
        this.codeBuffer = codeBuffer;
        this.variableAllocation = variableAllocation;
    }

    public static String getEfficientIntLiteral(long i) {
        StringBuilder sb = new StringBuilder();
        long abs = Math.abs(i);
        if (abs >= 1000000L) {
            if (i < 0L) {
                sb.append('-');
            }
            sb.append("0x");
            sb.append(Long.toHexString(abs));
        } else {
            sb.append(i);
        }
        return sb.toString();
    }

    public abstract CoreProviders getProviders();

    public void prepareForMethod(StructuredGraph g) {
        this.variableMap = this.variableAllocation.compute(g, this);
        this.methodScopeUniqueID = 0;
    }

    public boolean declared(Node n) {
        ValueNode valueNode;
        return n instanceof ValueNode && this.getAllocatedVariable(valueNode = (ValueNode)n) != null;
    }

    public int genUniqueID() {
        ++this.methodScopeUniqueID;
        return this.methodScopeUniqueID;
    }

    public void lowerStatement(Node n) {
        this.nodeLowerer().lowerStatement(n);
    }

    public void lowerValue(ValueNode n) {
        this.nodeLowerer().lowerValue(n);
    }

    public void genLabeledBlockHeader(String label) {
        this.codeBuffer.emitLabel(label);
        this.codeBuffer.emitScopeBegin();
    }

    public abstract void genBinaryOperation(Keyword var1, ValueNode var2, ValueNode var3);

    public abstract void genUnaryOperation(Keyword var1, ValueNode var2);

    public void lower(IEmitter l) {
        l.lower(this);
    }

    public int getCodeSize() {
        return this.codeBuffer.codeSize();
    }

    public CodeBuffer getCodeBuffer() {
        return this.codeBuffer;
    }

    public abstract NodeLowerer nodeLowerer();

    public void genFunctionEnd() {
        this.codeBuffer.emitFunctionEnd();
    }

    public abstract void genMethodHeader(StructuredGraph var1, ResolvedJavaMethod var2, List<ParameterNode> var3);

    public void genArrayLoad(ValueNode index, ValueNode array) {
        this.genArrayLoad(Emitter.of(index), Emitter.of(array));
    }

    public void genArrayLoad(IEmitter index, IEmitter array) {
        this.lower(array);
        this.genArrayAccessPrefix();
        this.lower(index);
        this.genArrayAccessPostfix();
    }

    public void genArrayStore(IEmitter index, IEmitter array, IEmitter value) {
        this.lower(array);
        this.genArrayAccessPrefix();
        this.lower(index);
        this.genArrayAccessPostfix();
        this.genAssignment();
        this.lower(value);
    }

    public void genArrayStore(IEmitter index, ValueNode array, ValueNode value) {
        this.genArrayStore(index, Emitter.of(array), Emitter.of(value));
    }

    protected abstract void genArrayAccessPostfix();

    protected abstract void genArrayAccessPrefix();

    public ResolvedVar getAllocatedVariable(ValueNode n) {
        return this.variableMap.getVarByNode(n);
    }

    public VariableAllocation getVariableAllocation() {
        return this.variableAllocation;
    }

    public abstract void genClassHeader(ResolvedJavaType var1);

    public void genClassEnd() {
        this.genScopeEnd();
        this.codeBuffer.emitNewLine();
        this.codeBuffer.emitNewLine();
    }

    public void genIfHeader(LogicNode condition) {
        this.genIfHeader(Emitter.of(condition));
    }

    public void genIfHeader(IEmitter condition) {
        this.codeBuffer.emitIfHeaderLeft();
        this.lower(condition);
        this.codeBuffer.emitIfHeaderRight();
    }

    public void genElseHeader() {
        this.codeBuffer.emitElse();
    }

    public void genScopeEnd() {
        this.codeBuffer.emitScopeEnd();
        this.codeBuffer.emitNewLine();
    }

    public void genSwitchHeader(ValueNode node) {
        this.codeBuffer.emitSwitchHeaderLeft();
        this.lowerValue(node);
        this.codeBuffer.emitSwitchHeaderRight();
    }

    public void genSwitchHeader(String controlVariable) {
        this.codeBuffer.emitSwitchHeaderLeft();
        this.codeBuffer.emitText(controlVariable);
        this.codeBuffer.emitSwitchHeaderRight();
    }

    public void genWhileTrueHeader() {
        this.codeBuffer.emitWhileTrueHeader();
    }

    public void genLoopContinue() {
        this.codeBuffer.emitContinue();
    }

    public void genVoidReturn() {
        this.codeBuffer.emitReturn();
    }

    public void genReturn(String returnValue) {
        this.genReturnPrefix();
        this.codeBuffer.emitText(returnValue);
        this.codeBuffer.emitInsEnd();
    }

    public void genReturn(IEmitter returnValue) {
        this.genReturnPrefix();
        this.lower(returnValue);
    }

    public void genReturn(ValueNode returnValue) {
        this.genReturn(Emitter.of(returnValue));
    }

    private void genReturnPrefix() {
        this.codeBuffer.emitReturnSymbol();
        this.codeBuffer.emitWhiteSpace();
    }

    public void genSwitchCase(int ... vals) {
        this.codeBuffer.emitIntCaseChain(vals);
    }

    public void genSwitchDefaultCase() {
        this.codeBuffer.emitDefaultCase();
    }

    public void genBreak() {
        this.codeBuffer.emitBreak();
    }

    public void genBreak(String label) {
        assert (label != null);
        this.codeBuffer.emitBreakLabel(label);
    }

    public void genBlockEndBreak() {
        this.genBreak();
    }

    public void genLabel(String label) {
        this.codeBuffer.emitLabel(label);
    }

    public void genCondition(CanonicalCondition cond) {
        this.codeBuffer.emitCondition(cond);
    }

    public void genResolvedVarAccess(String name) {
        this.codeBuffer.emitText(name);
    }

    public void genResolvedVarDeclPrefix(String name) {
        this.codeBuffer.emitDeclPrefix(name);
    }

    public void genResolvedVarDeclPrefix(String name, ValueNode node) {
        this.genResolvedVarDeclPrefix(name);
    }

    public void genResolvedVarDeclPrefix(String name, ResolvedJavaType javaType) {
        this.codeBuffer.emitDeclPrefix(name, javaType);
    }

    public abstract void genResolvedVarDeclPostfix(String var1);

    public void genResolvedVarAssignmentPrefix(String name) {
        this.codeBuffer.emitText(name);
        this.codeBuffer.emitWhiteSpace();
        this.codeBuffer.emitAssignmentSymbol();
        this.codeBuffer.emitWhiteSpace();
    }

    public abstract void genNewInstance(ResolvedJavaType var1);

    public abstract void genNewArray(ResolvedJavaType var1, IEmitter var2);

    public abstract void genEmptyDeclaration(ValueNode var1);

    public abstract void genCommaList(IEmitter ... var1);

    public void genCommaList(List<IEmitter> inputs) {
        this.genCommaList(inputs.toArray(new IEmitter[0]));
    }

    public String getStringLiteral(String s) {
        return this.codeBuffer.getStringLiteral(s);
    }

    public abstract void genComment(String var1);

    public abstract void genInlineComment(String var1);

    public void genTryBlock() {
        this.codeBuffer.emitTry();
    }

    public void genCatchBlockPrefix(String expName) {
        this.codeBuffer.emitCatch(expName);
    }

    public void genCatchBlockPrefix(String expName, Stamp stamp) {
        this.genCatchBlockPrefix(expName, stamp.javaType(this.getProviders().getMetaAccess()));
    }

    public void genCatchBlockPrefix(String expName, ResolvedJavaType javaType) {
        this.codeBuffer.emitCatch(expName, javaType);
    }

    public abstract void genThrow(ValueNode var1);

    public String getExceptionObjectId(Node n) {
        return "exception_object_" + n.getId();
    }

    public abstract void genAssignment();

    public abstract void genNull();

    public abstract void genFieldName(ResolvedJavaField var1);

    public abstract void genFieldName(Field var1);

    public abstract void genTypeName(ResolvedJavaType var1);

    public abstract void genTypeName(Class<?> var1);

    public abstract void genMethodName(ResolvedJavaMethod var1);

    public abstract void genMethodName(Method var1);

    public void genPropertyAccess(IEmitter receiver, IEmitter prop) {
        if (receiver != null) {
            this.lower(receiver);
            this.genPropertyAccessInfix();
        }
        this.lower(prop);
    }

    protected abstract void genPropertyAccessInfix();

    public abstract void genFunctionCall(IEmitter var1, IEmitter var2, IEmitter ... var3);

    protected abstract void genFunctionParameterInfix();

    protected abstract void genFunctionParameterPostfix();

    public abstract void genStaticMethodReference(ResolvedJavaMethod var1);

    public abstract void genStaticField(ResolvedJavaField var1);

    public abstract void genStaticCall(ResolvedJavaMethod var1, IEmitter ... var2);

    public abstract void genIndirectCall(IEmitter var1, IEmitter ... var2);

    public abstract void genShouldNotReachHere(String var1);

    public String toString() {
        return this.codeBuffer.toString();
    }
}

