/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hightiercodegen.lowerer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.hightiercodegen.lowerer.MoveResolver;

public class MoveResolver<S, T extends S> {
    protected final Graph graph;
    protected final Set<T> targets;
    protected final Map<Integer, T> idToTarget;
    protected final Map<Integer, S> idToSource;
    protected final Map<S, Integer> valueIds;

    public MoveResolver(Collection<T> moveTargets) {
        int numTargets = moveTargets.size();
        int numNodes = 2 * numTargets;
        this.graph = new Graph(numTargets, numNodes);
        this.targets = new HashSet<T>(moveTargets.size());
        this.idToTarget = new HashMap<Integer, T>(numTargets);
        this.idToSource = new HashMap<Integer, S>(numNodes);
        this.valueIds = new HashMap<S, Integer>(numNodes);
        for (T target : moveTargets) {
            assert (!this.targets.contains(target)) : "Target can only be added once";
            this.targets.add(target);
        }
    }

    protected boolean isTarget(S source) {
        return this.targets.contains(source);
    }

    public void addMove(S source, T target) {
        assert (this.isTarget(target)) : "Target was not provided in constructor";
        int sourceId = this.getId(source);
        int targetId = this.getId(target);
        this.graph.addMove(sourceId, targetId);
    }

    protected int getId(S value) {
        int id;
        if (this.valueIds.containsKey(value)) {
            return this.valueIds.get(value);
        }
        if (this.isTarget(value)) {
            id = this.graph.newTargetNode();
            S targetValue = value;
            this.idToTarget.put(id, targetValue);
        } else {
            id = this.graph.newSourceNode();
        }
        assert (!this.idToSource.containsKey(id));
        this.valueIds.put(value, id);
        this.idToSource.put(id, value);
        return id;
    }

    public Schedule scheduleMoves() {
        for (int node : this.graph.getNodes()) {
            if (!this.graph.isTarget(node)) continue;
            assert (!this.graph.isLeaf(node) || this.graph.hasIncoming(node));
            if (this.graph.getIncoming(node) != node) continue;
            this.graph.removeMove(node, node);
            if (!this.graph.isLeaf(node)) continue;
            this.graph.removeTarget(node);
        }
        Object object = this.findCycles().iterator();
        while (object.hasNext()) {
            Pair backEdge = (Pair)object.next();
            this.graph.breakMove((Integer)backEdge.getLeft(), (Integer)backEdge.getRight());
        }
        ArrayList<Integer> roots = new ArrayList<Integer>();
        for (int node : this.graph.getNodes()) {
            if (this.graph.isLeaf(node) || this.graph.hasIncoming(node)) continue;
            roots.add(node);
        }
        Schedule schedule = new Schedule();
        roots.forEach(root -> this.scheduleComponent(schedule, (int)root));
        assert (IntStream.of(this.graph.getNodes()).noneMatch(this.graph::hasIncoming)) : "The graph still has moves";
        assert (IntStream.of(this.graph.getNodes()).allMatch(this.graph::isLeaf)) : "The graph still has moves";
        return schedule;
    }

    private List<Pair<Integer, Integer>> findCycles() {
        int[] nodes;
        ArrayList<Pair<Integer, Integer>> cycles = new ArrayList<Pair<Integer, Integer>>();
        HashMap<Integer, Color> colors = new HashMap<Integer, Color>();
        for (int node : nodes = this.graph.getNodes()) {
            colors.put(node, Color.White);
        }
        for (int node : nodes) {
            Pair<Integer, Integer> backEdge;
            if (colors.get(node) != Color.White || (backEdge = this.findSingleCycle(node, colors)) == null) continue;
            cycles.add(backEdge);
        }
        return cycles;
    }

    private Pair<Integer, Integer> findSingleCycle(int startNode, Map<Integer, Color> colors) {
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        stack.push(startNode);
        Pair backEdge = null;
        while (!stack.isEmpty()) {
            int current = (Integer)stack.pop();
            assert (colors.get(current) != Color.Black);
            if (colors.get(current) == Color.Gray) {
                colors.put(current, Color.Black);
                continue;
            }
            colors.put(current, Color.Gray);
            stack.push(current);
            Iterator iterator = this.graph.getTargets(current).iterator();
            while (iterator.hasNext()) {
                int target = (Integer)iterator.next();
                Color color = colors.get(target);
                if (color == Color.White) {
                    stack.push(target);
                    continue;
                }
                if (color != Color.Gray || backEdge != null) continue;
                backEdge = Pair.create((Object)current, (Object)target);
            }
        }
        return backEdge;
    }

    private void scheduleComponent(Schedule schedule, int rootNode) {
        Iterable<Integer> reverseTopologicalOrder = this.reverseTopologicalOrder(rootNode);
        Integer tempNode = this.graph.isTemp(rootNode) ? Integer.valueOf(rootNode) : null;
        boolean wasTempMoveScheduled = false;
        for (int leafNode : reverseTopologicalOrder) {
            assert (this.graph.isLeaf(leafNode));
            if (leafNode == rootNode) break;
            T target = this.idToTarget.get(leafNode);
            int source = this.graph.getIncoming(leafNode);
            if (this.graph.isTemp(source)) {
                assert (tempNode != null) : "Move from temporary variable, but no temporary node exists";
                assert (tempNode == source) : "Found a second TempNode";
                assert (wasTempMoveScheduled) : "Move from temporary variable, but the move to the temporary variable was not yet scheduled";
                int originalSource = this.graph.getOriginalTarget(source);
                schedule.scheduleMoveFromTemporary(this.idToSource.get(originalSource), target);
            } else {
                if (!wasTempMoveScheduled && tempNode != null && this.graph.getOriginalTarget(tempNode) == leafNode) {
                    schedule.scheduleMoveToTemporary(target);
                    wasTempMoveScheduled = true;
                }
                schedule.scheduleMove(this.idToSource.get(source), target);
            }
            this.graph.removeMove(source, leafNode);
            this.graph.removeTarget(leafNode);
        }
    }

    private Iterable<Integer> reverseTopologicalOrder(int rootNode) {
        assert (!this.graph.hasIncoming(rootNode)) : "The node is not a root";
        assert (!this.graph.isLeaf(rootNode)) : "The root node is part of a component without edges";
        ArrayDeque<Integer> workList = new ArrayDeque<Integer>();
        workList.push(rootNode);
        ArrayDeque<Integer> reverseTopologicalOrder = new ArrayDeque<Integer>();
        while (!workList.isEmpty()) {
            int current = (Integer)workList.pop();
            reverseTopologicalOrder.addFirst(current);
            assert (!this.graph.isTemp(current) || current == rootNode) : "The TempNode is not the root.";
            Iterator iterator = this.graph.getTargets(current).iterator();
            while (iterator.hasNext()) {
                int target = (Integer)iterator.next();
                assert (!reverseTopologicalOrder.contains(target)) : "The graph still has cycles";
                workList.push(target);
            }
        }
        return reverseTopologicalOrder;
    }

    protected static class Graph {
        private final List<Node> nodes;
        private final List<SortedSet<Integer>> moves;
        private final List<Integer> incomingMoves;
        private final EconomicMap<Integer, Integer> targetToTemp;

        public Graph(int numTargets, int numNodes) {
            this.nodes = new ArrayList<Node>(numNodes);
            this.moves = new ArrayList<SortedSet<Integer>>(numNodes);
            this.incomingMoves = new ArrayList<Integer>(numNodes);
            this.targetToTemp = EconomicMap.create((int)numTargets);
        }

        public int newTargetNode() {
            return this.addNode(id -> new Node(Type.Target, (int)id));
        }

        public int newSourceNode() {
            return this.addNode(id -> new Node(Type.PureSource, (int)id));
        }

        public void addMove(int source, int target) {
            assert (!this.isTemp(target));
            assert (this.isTarget(target));
            this.doGetTargets(source).add(target);
            assert (!this.hasIncoming(target));
            this.incomingMoves.set(target, source);
        }

        public void removeTarget(int target) {
            assert (this.isLeaf(target)) : "Removed target must have no outgoing moves";
            assert (this.isTarget(target));
            assert (!this.hasIncoming(target)) : "Removed target must have no incoming move";
            this.moves.set(target, null);
            this.nodes.set(target, null);
        }

        public void removeMove(int source, int target) {
            assert (this.isTarget(target));
            this.doGetTargets(source).remove(target);
            assert (this.hasIncoming(target));
            this.incomingMoves.set(target, null);
        }

        public void breakMove(int source, int target) {
            int tempNode = this.getTempForTarget(source);
            this.removeMove(source, target);
            this.addMove(tempNode, target);
        }

        public int[] getNodes() {
            return IntStream.range(0, this.nodes.size()).filter(node -> this.nodes.get(node) != null).toArray();
        }

        private int addNode(Function<Integer, Node> constructor) {
            int numNodes = this.nodes.size();
            assert (numNodes == this.moves.size());
            assert (numNodes == this.incomingMoves.size());
            Node node = constructor.apply(numNodes);
            this.nodes.add(node);
            this.moves.add(new TreeSet());
            this.incomingMoves.add(null);
            return numNodes;
        }

        private Node getNode(int id) {
            Node node = this.nodes.get(id);
            assert (node != null);
            return node;
        }

        public boolean isTarget(int node) {
            return this.getNode(node).isTarget();
        }

        public boolean isTemp(int node) {
            return this.getNode(node).isTemp();
        }

        private int getTempForTarget(int target) {
            assert (this.isTarget(target));
            if (this.targetToTemp.containsKey((Object)target)) {
                return (Integer)this.targetToTemp.get((Object)target);
            }
            int id = this.addNode(newId -> new TempNode((int)newId, target));
            this.targetToTemp.put((Object)target, (Object)id);
            return id;
        }

        public int getOriginalTarget(int tempNode) {
            assert (this.isTemp(tempNode));
            return ((TempNode)this.getNode((int)tempNode)).originalNode;
        }

        private SortedSet<Integer> doGetTargets(int node) {
            SortedSet<Integer> targets = this.moves.get(node);
            assert (targets != null);
            return targets;
        }

        public SortedSet<Integer> getTargets(int node) {
            return Collections.unmodifiableSortedSet(this.doGetTargets(node));
        }

        public boolean isLeaf(int node) {
            return this.doGetTargets(node).isEmpty();
        }

        public Integer getIncoming(int target) {
            assert (this.isTarget(target));
            return this.incomingMoves.get(target);
        }

        public boolean hasIncoming(int node) {
            return this.incomingMoves.get(node) != null;
        }

        static class Node {
            private final Type type;
            protected final int id;

            Node(Type type, int id) {
                this.type = type;
                this.id = id;
            }

            public boolean isTarget() {
                return this.type == Type.Target;
            }

            public boolean isTemp() {
                return this.type == Type.Temp;
            }

            public String toString() {
                return "Node{" + this.id + ", " + this.type.name() + "}";
            }
        }

        static class TempNode
        extends Node {
            public final int originalNode;

            TempNode(int id, int originalNode) {
                super(Type.Temp, id);
                this.originalNode = originalNode;
            }
        }

        static enum Type {
            PureSource,
            Target,
            Temp;

        }
    }

    public class Schedule {
        public final List<org.graalvm.compiler.hightiercodegen.lowerer.MoveResolver$Schedule.Move> moves = new ArrayList<org.graalvm.compiler.hightiercodegen.lowerer.MoveResolver$Schedule.Move>();
        private boolean needsTemporary = false;

        public void scheduleMove(S source, T target) {
            this.moves.add((org.graalvm.compiler.hightiercodegen.lowerer.MoveResolver$Schedule.Move)new Move(source, target, false));
        }

        public void scheduleMoveFromTemporary(S source, T target) {
            assert (this.needsTemporary);
            this.moves.add((org.graalvm.compiler.hightiercodegen.lowerer.MoveResolver$Schedule.Move)new Move(source, target, true));
        }

        public void scheduleMoveToTemporary(T source) {
            this.needsTemporary = true;
            this.moves.add((org.graalvm.compiler.hightiercodegen.lowerer.MoveResolver$Schedule.Move)new Move(source, null, true));
        }

        public boolean needsTemporary() {
            return this.needsTemporary;
        }

        public String toString() {
            return "Schedule{" + (this.needsTemporary ? "with temp, " : "") + this.moves + "}";
        }

        public class Move {
            public final S source;
            public final T target;
            public final boolean useTemporary;

            public Move(S source, T target, boolean useTemporary) {
                this.source = source;
                this.target = target;
                this.useTemporary = useTemporary;
            }

            public String toString() {
                return "Move{" + this.source + " -> " + this.target + ", " + (this.useTemporary ? "temporary" : "current") + "}";
            }
        }
    }

    static enum Color {
        White,
        Gray,
        Black;

    }
}

