/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hightiercodegen.reconstruction;

import java.util.SortedSet;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hightiercodegen.reconstruction.ReconstructionData;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.blocks.LabeledBlock;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.blocks.LabeledBlockGeneration;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.CatchScopeContainer;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.IfScopeContainer;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.LoopScopeContainer;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.Scope;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.ScopeContainer;
import org.graalvm.compiler.hightiercodegen.reconstruction.stackifier.scopes.SwitchScopeContainer;
import org.graalvm.compiler.nodes.cfg.HIRBlock;

public class StackifierData
implements ReconstructionData {
    private EconomicMap<HIRBlock, SortedSet<LabeledBlock>> labeledBlockStarts;
    private EconomicMap<HIRBlock, LabeledBlock> labeledBlockEnd;
    private HIRBlock[] blocks;
    private EconomicMap<HIRBlock, Scope> enclosingScope;
    private EconomicMap<Node, ScopeContainer> scopes;
    private LabeledBlockGeneration labeledBlockGeneration;

    public SortedSet<LabeledBlock> labeledBlockStarts(HIRBlock start) {
        return (SortedSet)this.labeledBlockStarts.get((Object)start);
    }

    public LabeledBlock labeledBlockEnd(HIRBlock end) {
        return (LabeledBlock)this.labeledBlockEnd.get((Object)end);
    }

    public int getNrOfLabeledBlocks() {
        return this.labeledBlockEnd.size();
    }

    public HIRBlock[] getBlocks() {
        return this.blocks;
    }

    public EconomicMap<HIRBlock, Scope> getEnclosingScope() {
        return this.enclosingScope;
    }

    public void setEnclosingScope(EconomicMap<HIRBlock, Scope> enclosingScope) {
        this.enclosingScope = enclosingScope;
    }

    public void setLabeledBlockStarts(EconomicMap<HIRBlock, SortedSet<LabeledBlock>> labeledBlockStarts) {
        this.labeledBlockStarts = labeledBlockStarts;
    }

    public void setLabeledBlockEnd(EconomicMap<HIRBlock, LabeledBlock> labeledBlockEnds) {
        this.labeledBlockEnd = labeledBlockEnds;
    }

    public void setSortedBlocks(HIRBlock[] sortedBlocks) {
        this.blocks = sortedBlocks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String separator = "-----------------------------\n";
        String indent = " ";
        sb.append("Stackifier data\n");
        sb.append("-----------------------------\n");
        StringBuilder indentSb = new StringBuilder();
        sb.append(this.blocks.length).append(" basic blocks in total\n").append("-----------------------------\n");
        sb.append("Labeled blocks\n").append("-----------------------------\n");
        for (HIRBlock b : this.blocks) {
            if (this.labeledBlockEnd(b) != null) {
                indentSb.replace(0, 1, "");
                LabeledBlock labeledBlock = this.labeledBlockEnd(b);
                sb.append((CharSequence)indentSb).append("}").append(labeledBlock.getLabel()).append(" [").append(labeledBlock.getEnd()).append("]\n");
            }
            if (this.labeledBlockStarts(b) == null) continue;
            for (LabeledBlock labeledBlock : this.labeledBlockStarts(b)) {
                sb.append((CharSequence)indentSb).append(labeledBlock.getLabel()).append(" [").append(labeledBlock.getStart()).append("] {\n");
                indentSb.append(" ");
            }
        }
        sb.append("-----------------------------\n").append("Scopes\n").append("-----------------------------\n");
        for (HIRBlock b : this.blocks) {
            Scope[] caseScopes;
            ScopeContainer scopeContainer;
            if (b.isLoopHeader()) {
                sb.append("Loop ").append(((LoopScopeContainer)this.scopes.get((Object)b.getBeginNode())).getLoopScope()).append("\n");
            }
            if ((scopeContainer = (ScopeContainer)this.scopes.get((Object)b.getEndNode())) == null) continue;
            if (scopeContainer instanceof IfScopeContainer) {
                IfScopeContainer ifScopeContainer = (IfScopeContainer)scopeContainer;
                if (ifScopeContainer.getThenScope() != null) {
                    sb.append("Then ").append(ifScopeContainer.getThenScope()).append("\n");
                }
                if (ifScopeContainer.getElseScope() == null) continue;
                sb.append("Else ").append(ifScopeContainer.getElseScope()).append("\n");
                continue;
            }
            if (scopeContainer instanceof CatchScopeContainer) {
                CatchScopeContainer catchScopeContainer = (CatchScopeContainer)scopeContainer;
                if (catchScopeContainer.getCatchScope() == null) continue;
                sb.append("Catch ").append(((CatchScopeContainer)scopeContainer).getCatchScope()).append("\n");
                continue;
            }
            if (!(scopeContainer instanceof SwitchScopeContainer)) continue;
            SwitchScopeContainer switchScopeContainer = (SwitchScopeContainer)scopeContainer;
            for (Scope scope : caseScopes = switchScopeContainer.getCaseScopes()) {
                if (scope == null) continue;
                sb.append("Case ").append(scope).append("\n");
            }
        }
        sb.append("-----------------------------\n").append("Innermost enclosing scopes\n").append("-----------------------------\n");
        for (HIRBlock b : this.enclosingScope.getKeys()) {
            sb.append(b).append(" -> ").append(this.enclosingScope.get((Object)b)).append("\n");
        }
        sb.append("-----------------------------\n");
        return sb.toString();
    }

    public void setScopeEntries(EconomicMap<Node, ScopeContainer> scopes) {
        this.scopes = scopes;
    }

    public ScopeContainer getScopeEntry(Node node) {
        return (ScopeContainer)this.scopes.get((Object)node);
    }

    public int getNrThenScopes() {
        int sum = 0;
        for (ScopeContainer scopeContainer : this.scopes.getValues()) {
            if (!(scopeContainer instanceof IfScopeContainer) || ((IfScopeContainer)scopeContainer).getThenScope() == null) continue;
            ++sum;
        }
        return sum;
    }

    public int getNrElseScopes() {
        int sum = 0;
        for (ScopeContainer scopeContainer : this.scopes.getValues()) {
            if (!(scopeContainer instanceof IfScopeContainer) || ((IfScopeContainer)scopeContainer).getElseScope() == null) continue;
            ++sum;
        }
        return sum;
    }

    public int getNrLoopScopes() {
        int sum = 0;
        for (ScopeContainer scopeContainer : this.scopes.getValues()) {
            if (!(scopeContainer instanceof LoopScopeContainer)) continue;
            ++sum;
        }
        return sum;
    }

    public int getNrCatchScopes() {
        int sum = 0;
        for (ScopeContainer scopeContainer : this.scopes.getValues()) {
            if (!(scopeContainer instanceof CatchScopeContainer) || ((CatchScopeContainer)scopeContainer).getCatchScope() == null) continue;
            ++sum;
        }
        return sum;
    }

    public LabeledBlockGeneration getLabeledBlockGeneration() {
        return this.labeledBlockGeneration;
    }

    public void setLabeledBlockGeneration(LabeledBlockGeneration labeledBlockGeneration) {
        this.labeledBlockGeneration = labeledBlockGeneration;
    }
}

