/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;

public class HotSpotGraalOptionValues {
    private static final String GRAAL_OPTIONS_FILE_PROPERTY_NAME = "graal.options.file";
    private static final String GRAAL_VERSION_PROPERTY_NAME = "graal.version";
    public static final String GRAAL_OPTION_PROPERTY_PREFIX = "graal.";
    @NativeImageReinitialize
    private static volatile OptionValues hotspotOptions;

    public static String asSystemPropertySetting(OptionValues options, OptionKey<?> value) {
        return GRAAL_OPTION_PROPERTY_PREFIX + value.getName() + "=" + value.getValue(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OptionValues defaultOptions() {
        OptionValues res = hotspotOptions;
        if (res != null) return res;
        Class<HotSpotGraalOptionValues> clazz = HotSpotGraalOptionValues.class;
        synchronized (HotSpotGraalOptionValues.class) {
            res = hotspotOptions;
            if (res != null) return res;
            hotspotOptions = res = HotSpotGraalOptionValues.initializeOptions();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return res;
        }
    }

    public static EconomicMap<OptionKey<?>, Object> parseOptions() {
        EconomicMap<OptionKey<?>, Object> values = OptionValues.newOptionMap();
        try (InitTimer t = InitTimer.timer((String)"InitializeOptions");){
            File graalOptions;
            Iterable<OptionDescriptors> loader = OptionsParser.getOptionsLoader();
            Map savedProps = Services.getSavedProperties();
            String optionsFile = (String)savedProps.get(GRAAL_OPTIONS_FILE_PROPERTY_NAME);
            if (optionsFile != null && (graalOptions = new File(optionsFile)).exists()) {
                try (FileReader fr = new FileReader(graalOptions);){
                    Properties props = new Properties();
                    props.load(fr);
                    EconomicMap optionSettings = EconomicMap.create();
                    for (Map.Entry<Object, Object> e : props.entrySet()) {
                        optionSettings.put((Object)((String)e.getKey()), (Object)((String)e.getValue()));
                    }
                    try {
                        OptionsParser.parseOptions((EconomicMap<String, String>)optionSettings, values, loader);
                    }
                    catch (Throwable e) {
                        throw new InternalError("Error parsing an option from " + graalOptions, e);
                    }
                }
                catch (IOException e) {
                    throw new InternalError("Error reading " + graalOptions, e);
                }
            }
            EconomicMap optionSettings = EconomicMap.create();
            for (Map.Entry e : savedProps.entrySet()) {
                String name = (String)e.getKey();
                if (!name.startsWith(GRAAL_OPTION_PROPERTY_PREFIX)) continue;
                if (name.equals("graal.PrintFlags") || name.equals("graal.ShowFlags")) {
                    System.err.println("The " + name + " option has been removed and will be ignored. Use -XX:+JVMCIPrintProperties instead.");
                    continue;
                }
                if (name.equals(GRAAL_OPTIONS_FILE_PROPERTY_NAME) || name.equals(GRAAL_VERSION_PROPERTY_NAME)) continue;
                String value = (String)e.getValue();
                optionSettings.put((Object)name.substring(GRAAL_OPTION_PROPERTY_PREFIX.length()), (Object)value);
            }
            OptionsParser.parseOptions((EconomicMap<String, String>)optionSettings, values, loader);
            Iterator iterator = values;
            return iterator;
        }
    }

    private static OptionValues initializeOptions() {
        return new OptionValues((UnmodifiableEconomicMap<OptionKey<?>, Object>)HotSpotGraalOptionValues.parseOptions());
    }
}

