/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public class SnippetObjectConstant
implements JavaConstant {
    protected final Object object;

    public SnippetObjectConstant(Object object) {
        this.object = object;
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SnippetObjectConstant) {
            SnippetObjectConstant other = (SnippetObjectConstant)o;
            return this.object == other.object;
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this.object);
    }

    public <T> T asObject(Class<T> type) {
        if (type.isInstance(this.object)) {
            return type.cast(this.object);
        }
        return null;
    }

    public String toString() {
        return "SnippetObjectConstant{object=" + this.object + "}";
    }

    public String toValueString() {
        return JavaKind.Object.format(this.object);
    }

    public boolean isNull() {
        return false;
    }

    public boolean isDefaultForKind() {
        return false;
    }

    public Object asBoxedPrimitive() {
        throw new IllegalArgumentException();
    }

    public int asInt() {
        throw new IllegalArgumentException();
    }

    public boolean asBoolean() {
        throw new IllegalArgumentException();
    }

    public long asLong() {
        throw new IllegalArgumentException();
    }

    public float asFloat() {
        throw new IllegalArgumentException();
    }

    public double asDouble() {
        throw new IllegalArgumentException();
    }
}

