/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.hotspot.SnippetResolvedJavaType;
import org.graalvm.compiler.hotspot.SnippetSignature;

public final class SnippetResolvedJavaMethod
implements ResolvedJavaMethod {
    private final String name;
    private final int modifiers;
    private final SnippetResolvedJavaType type;
    private final SnippetSignature signature;

    public SnippetResolvedJavaMethod(SnippetResolvedJavaType type, ResolvedJavaMethod method) {
        this.type = type;
        this.name = method.getName();
        this.modifiers = method.getModifiers();
        this.signature = new SnippetSignature(method.getSignature().toMethodDescriptor());
        assert (this.format("%H.%n(%P)").equals(method.format("%H.%n(%P)")));
        assert (this.format("%H.%n(%p)").equals(method.format("%H.%n(%p)")));
        assert (this.format("%h.%n").equals(method.format("%h.%n")));
    }

    public byte[] getCode() {
        return null;
    }

    public int getCodeSize() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.type;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public int getMaxLocals() {
        throw new UnsupportedOperationException();
    }

    public int getMaxStackSize() {
        throw new UnsupportedOperationException();
    }

    public boolean isSynthetic() {
        throw new UnsupportedOperationException();
    }

    public boolean isVarArgs() {
        throw new UnsupportedOperationException();
    }

    public boolean isBridge() {
        throw new UnsupportedOperationException();
    }

    public boolean isDefault() {
        throw new UnsupportedOperationException();
    }

    public boolean isClassInitializer() {
        throw new UnsupportedOperationException();
    }

    public boolean isConstructor() {
        throw new UnsupportedOperationException();
    }

    public boolean canBeStaticallyBound() {
        throw new UnsupportedOperationException();
    }

    public ExceptionHandler[] getExceptionHandlers() {
        throw new UnsupportedOperationException();
    }

    public StackTraceElement asStackTraceElement(int bci) {
        return new StackTraceElement(this.getDeclaringClass().getName(), this.name, null, -1);
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        throw new UnsupportedOperationException();
    }

    public void reprofile() {
    }

    public ConstantPool getConstantPool() {
        throw new UnsupportedOperationException();
    }

    public Annotation[][] getParameterAnnotations() {
        throw new UnsupportedOperationException();
    }

    public Type[] getGenericParameterTypes() {
        throw new UnsupportedOperationException();
    }

    public boolean canBeInlined() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNeverInlineDirective() {
        throw new UnsupportedOperationException();
    }

    public boolean shouldBeInlined() {
        throw new UnsupportedOperationException();
    }

    public LineNumberTable getLineNumberTable() {
        throw new UnsupportedOperationException();
    }

    public LocalVariableTable getLocalVariableTable() {
        throw new UnsupportedOperationException();
    }

    public Constant getEncoding() {
        throw new UnsupportedOperationException();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        throw new UnsupportedOperationException();
    }

    public SpeculationLog getSpeculationLog() {
        throw new UnsupportedOperationException();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw new UnsupportedOperationException();
    }

    public Annotation[] getAnnotations() {
        throw new UnsupportedOperationException();
    }

    public Annotation[] getDeclaredAnnotations() {
        throw new UnsupportedOperationException();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnippetResolvedJavaMethod that = (SnippetResolvedJavaMethod)o;
        return this.modifiers == that.modifiers && this.name.equals(that.name) && this.type.equals(that.type) && this.signature.equals(that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.modifiers, this.type, this.signature);
    }

    public String toString() {
        return "SnippetResolvedJavaMethod{name='" + this.name + "', type=" + this.type + "}";
    }
}

