/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import java.util.function.Function;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.aarch64.AArch64ControlFlow;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

final class AArch64HotSpotStrategySwitchOp
extends AArch64ControlFlow.StrategySwitchOp {
    public static final LIRInstructionClass<AArch64HotSpotStrategySwitchOp> TYPE = LIRInstructionClass.create(AArch64HotSpotStrategySwitchOp.class);

    AArch64HotSpotStrategySwitchOp(SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue key, Function<Condition, AArch64Assembler.ConditionFlag> converter) {
        super(TYPE, strategy, keyTargets, defaultTarget, key, converter);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        this.strategy.run(new HotSpotSwitchClosure(ValueUtil.asRegister((Value)this.key), crb, masm));
    }

    public class HotSpotSwitchClosure
    extends AArch64ControlFlow.StrategySwitchOp.SwitchClosure {
        protected HotSpotSwitchClosure(Register keyRegister, CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            super(AArch64HotSpotStrategySwitchOp.this, keyRegister, crb, masm);
        }

        @Override
        protected void emitComparison(Constant c) {
            if (c instanceof HotSpotMetaspaceConstant) {
                HotSpotMetaspaceConstant meta = (HotSpotMetaspaceConstant)c;
                this.crb.recordInlineDataInCode((Constant)meta);
                if (meta.isCompressed()) {
                    throw GraalError.unimplemented("compressed metaspace constant");
                }
                try (AArch64MacroAssembler.ScratchRegister scratchRegister = this.masm.getScratchRegister();){
                    Register scratch = scratchRegister.getRegister();
                    this.masm.movNativeAddress(scratch, 0xDEADDEADDEADL);
                    this.masm.cmp(64, this.keyRegister, scratch);
                }
            } else {
                super.emitComparison(c);
            }
        }
    }
}

