/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.hotspot.aarch64.AArch64HotSpotRegisterConfig;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.aarch64.AArch64BarrierSetLIRGenerator;
import org.graalvm.compiler.core.aarch64.AArch64LIRGenerator;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotBackend;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotZAtomicReadAndWriteOp;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotZCompareAndSwapOp;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotZReadBarrierOp;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.aarch64.AArch64AddressValue;
import org.graalvm.compiler.lir.aarch64.AArch64Call;
import org.graalvm.compiler.lir.aarch64.AArch64FrameMap;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AArch64HotSpotZBarrierSetLIRGenerator
extends AArch64BarrierSetLIRGenerator {
    private final GraalHotSpotVMConfig config;
    private final HotSpotProviders providers;

    public AArch64HotSpotZBarrierSetLIRGenerator(GraalHotSpotVMConfig config, HotSpotProviders providers) {
        this.config = config;
        this.providers = providers;
    }

    public AArch64LIRGenerator getAArch64LIRGen() {
        return (AArch64LIRGenerator)this.lirGen;
    }

    public ForeignCallsProvider getForeignCalls() {
        return this.providers.getForeignCalls();
    }

    public static void emitBarrier(CompilationResultBuilder crb, AArch64MacroAssembler masm, Label success, Register resultReg, GraalHotSpotVMConfig config, ForeignCallLinkage callTarget, AArch64Address address, LIRInstruction op, AArch64FrameMap frameMap) {
        assert (!resultReg.equals((Object)address.getBase()) && !resultReg.equals((Object)address.getOffset()));
        Label entryPoint = new Label();
        Label continuation = new Label();
        try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();){
            Register scratch1 = sc1.getRegister();
            Register thread = AArch64HotSpotRegisterConfig.threadRegister;
            AArch64Address badMask = masm.makeAddress(64, thread, config.threadAddressBadMaskOffset, scratch1);
            masm.ldr(64, scratch1, badMask);
            if (success == null) {
                masm.tst(64, scratch1, resultReg);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, entryPoint);
            } else {
                masm.and(64, scratch1, scratch1, resultReg);
                masm.cbz(64, scratch1, success);
                masm.jmp(entryPoint);
            }
            crb.getLIR().addSlowPath(op, () -> {
                Register addressReg;
                masm.bind(entryPoint);
                if (frameMap != null) {
                    AArch64HotSpotBackend.rawEnter(crb, frameMap, masm, config);
                }
                CallingConvention cc = callTarget.getOutgoingCallingConvention();
                AArch64Address cArg0 = (AArch64Address)crb.asAddress((Value)cc.getArgument(0));
                AArch64Address cArg1 = (AArch64Address)crb.asAddress((Value)cc.getArgument(1));
                masm.str(64, resultReg, cArg0);
                if (address.isBaseRegisterOnly()) {
                    addressReg = address.getBase();
                } else {
                    addressReg = resultReg;
                    masm.loadAddress(resultReg, address);
                }
                masm.str(64, addressReg, cArg1);
                AArch64Call.directCall(crb, masm, callTarget, AArch64Call.isNearCall(callTarget) ? null : scratch1, null);
                masm.ldr(64, resultReg, cArg0);
                if (frameMap != null) {
                    AArch64HotSpotBackend.rawLeave(crb, config);
                }
                masm.jmp(continuation);
            });
            masm.bind(continuation);
        }
    }

    @Override
    public Variable emitBarrieredLoad(LIRKind kind, Value address, LIRFrameState state, MemoryOrderMode memoryOrder, BarrierType barrierType) {
        if (kind.getPlatformKind().getVectorLength() == 1) {
            GraalError.guarantee(kind.getPlatformKind() == AArch64Kind.QWORD, "ZGC only uses uncompressed oops: %s", (Object)kind);
            ForeignCallLinkage callTarget = this.getBarrierStub(barrierType);
            AArch64AddressValue loadAddress = this.getAArch64LIRGen().asAddressValue(address, 64);
            Variable result = this.getLIRGen().newVariable(this.getLIRGen().toRegisterKind(kind));
            this.getLIRGen().getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
            this.getLIRGen().append(new AArch64HotSpotZReadBarrierOp(result, loadAddress, memoryOrder, state, this.config, callTarget));
            return result;
        }
        throw GraalError.shouldNotReachHere("unhandled");
    }

    public ForeignCallLinkage getBarrierStub(BarrierType barrierType) {
        return switch (barrierType) {
            case BarrierType.READ -> this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_FIELD_BARRIER);
            case BarrierType.REFERENCE_GET -> this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_REFERENCE_GET_BARRIER);
            case BarrierType.WEAK_REFERS_TO -> this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_WEAK_REFERS_TO_BARRIER);
            case BarrierType.PHANTOM_REFERS_TO -> this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_PHANTOM_REFERS_TO_BARRIER);
            default -> throw GraalError.shouldNotReachHere("Unexpected barrier type: " + barrierType);
        };
    }

    @Override
    public void emitCompareAndSwapOp(boolean isLogicVariant, Value address, MemoryOrderMode memoryOrder, AArch64Kind memKind, Variable result, AllocatableValue allocatableExpectedValue, AllocatableValue allocatableNewValue, BarrierType barrierType) {
        ForeignCallLinkage callTarget = this.getBarrierStub(barrierType);
        Variable temp = this.getLIRGen().newVariable(this.getLIRGen().toRegisterKind(LIRKind.value((PlatformKind)memKind)));
        this.getLIRGen().getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        this.getLIRGen().append(new AArch64HotSpotZCompareAndSwapOp(memKind, memoryOrder, isLogicVariant, result, (Value)allocatableExpectedValue, allocatableNewValue, this.getLIRGen().asAllocatable(address), this.config, callTarget, temp));
    }

    AllocatableValue asAllocatable(Value value) {
        return this.getLIRGen().asAllocatable(value);
    }

    public <I extends LIRInstruction> I append(I op) {
        return this.getLIRGen().append(op);
    }

    @Override
    public Value emitAtomicReadAndWrite(LIRKind accessKind, Value address, Value newValue, BarrierType barrierType) {
        GraalError.guarantee(barrierType == BarrierType.READ, "unexpected type for barrier: %s", (Object)barrierType);
        Variable result = this.lirGen.newVariable(this.lirGen.toRegisterKind(accessKind));
        GraalError.guarantee(accessKind.getPlatformKind() == AArch64Kind.QWORD, "unexpected kind for ZGC");
        ForeignCallLinkage callTarget = this.getBarrierStub(barrierType);
        this.getLIRGen().getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        this.append(new AArch64HotSpotZAtomicReadAndWriteOp((AArch64Kind)accessKind.getPlatformKind(), result, this.asAllocatable(address), this.asAllocatable(newValue), this.config, callTarget));
        return result;
    }
}

