/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotZBarrieredOp;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.aarch64.AArch64AddressValue;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AArch64HotSpotZReadBarrierOp
extends AArch64HotSpotZBarrieredOp {
    public static final LIRInstructionClass<AArch64HotSpotZReadBarrierOp> TYPE = LIRInstructionClass.create(AArch64HotSpotZReadBarrierOp.class);
    private final MemoryOrderMode memoryOrder;
    @LIRInstruction.State
    protected LIRFrameState state;

    public AArch64HotSpotZReadBarrierOp(Variable result, AArch64AddressValue loadAddress, MemoryOrderMode memoryOrder, LIRFrameState state, GraalHotSpotVMConfig config, ForeignCallLinkage callTarget) {
        super(TYPE, result, loadAddress, config, callTarget);
        this.memoryOrder = memoryOrder;
        this.state = state;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        int loadPosition;
        Register resultReg = ValueUtil.asRegister((Value)this.result);
        switch (this.memoryOrder) {
            case PLAIN: 
            case OPAQUE: {
                loadPosition = masm.position();
                masm.ldr(64, resultReg, this.loadAddress.toAddress(), false);
                break;
            }
            case ACQUIRE: 
            case VOLATILE: {
                try (AArch64MacroAssembler.ScratchRegister scratch1 = masm.getScratchRegister();){
                    Register addrReg;
                    AArch64Address address = this.loadAddress.toAddress();
                    if (address.isBaseRegisterOnly()) {
                        addrReg = address.getBase();
                    } else {
                        addrReg = scratch1.getRegister();
                        masm.loadAddress(addrReg, address);
                    }
                    loadPosition = masm.position();
                    masm.ldar(64, resultReg, addrReg);
                    break;
                }
            }
            default: {
                throw GraalError.shouldNotReachHere("Unexpected memory order");
            }
        }
        if (this.state != null) {
            crb.recordImplicitException(loadPosition, this.state);
        }
        this.emitBarrier(crb, masm);
    }
}

