/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkageImpl;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.amd64.AMD64MathStub;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.IntrinsicStubsGen;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsForeignCalls;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.VectorizedHashCodeNode;
import org.graalvm.compiler.word.WordTypes;

public class AMD64HotSpotForeignCallsProvider
extends HotSpotHostForeignCallsProvider {
    private final Value[] nativeABICallerSaveRegisters;

    public AMD64HotSpotForeignCallsProvider(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalRuntimeProvider runtime, MetaAccessProvider metaAccess, CodeCacheProvider codeCache, WordTypes wordTypes, Value[] nativeABICallerSaveRegisters) {
        super(jvmciRuntime, runtime, metaAccess, codeCache, wordTypes);
        this.nativeABICallerSaveRegisters = nativeABICallerSaveRegisters;
    }

    @Override
    public void initialize(HotSpotProviders providers, OptionValues options) {
        TargetDescription target = providers.getCodeCache().getTarget();
        PlatformKind word = target.arch.getWordKind();
        RegisterValue exception = AMD64.rax.asValue((ValueKind)LIRKind.reference(word));
        RegisterValue exceptionPc = AMD64.rdx.asValue((ValueKind)LIRKind.value(word));
        CallingConvention exceptionCc = new CallingConvention(0, Value.ILLEGAL, new AllocatableValue[]{exception, exceptionPc});
        this.register(new HotSpotForeignCallLinkageImpl(HotSpotBackend.EXCEPTION_HANDLER, 0L, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, exceptionCc, null));
        this.register(new HotSpotForeignCallLinkageImpl(HotSpotBackend.EXCEPTION_HANDLER_IN_CALLER, -2401018188504514833L, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, exceptionCc, null));
        this.linkSnippetStubs(providers, options, IntrinsicStubsGen::new, ArrayEqualsForeignCalls.STUBS_AMD64);
        this.linkSnippetStubs(providers, options, IntrinsicStubsGen::new, VectorizedHashCodeNode.STUBS);
        super.initialize(providers, options);
    }

    @Override
    public Value[] getNativeABICallerSaveRegisters() {
        return this.nativeABICallerSaveRegisters;
    }

    @Override
    protected void registerMathStubs(GraalHotSpotVMConfig hotSpotVMConfig, HotSpotProviders providers, OptionValues options) {
        if (HotSpotBackend.Options.GraalArithmeticStubs.getValue(options).booleanValue()) {
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.SIN, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.SIN.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.COS, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.COS.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.TAN, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.TAN.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.EXP, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.EXP.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.LOG, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.LOG.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation.LOG10, options, providers, this.registerStubCall(UnaryMathIntrinsicNode.UnaryOperation.LOG10.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
            AMD64HotSpotForeignCallsProvider.link(new AMD64MathStub(BinaryMathIntrinsicNode.BinaryOperation.POW, options, providers, this.registerStubCall(BinaryMathIntrinsicNode.BinaryOperation.POW.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED, NO_LOCATIONS)));
        } else {
            super.registerMathStubs(hotSpotVMConfig, providers, options);
        }
    }
}

