/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.debug;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.hotspot.debug.BenchmarkCounters;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionStability;
import org.graalvm.compiler.options.OptionType;

public class BenchmarkCounters_OptionDescriptors
implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
            case "AbortOnBenchmarkCounterOverflow": {
                return OptionDescriptor.create("AbortOnBenchmarkCounterOverflow", OptionType.Debug, Boolean.class, "Abort VM with SIGILL if benchmark counters controlled by the (Generic|Timed|Benchmark)DynamicCounters", new String[]{"option overflow.  WARNING: No descriptive error message will be printed! In", "case of an overflow, manual inspection of the emitted code is required."}, BenchmarkCounters.Options.class, "AbortOnBenchmarkCounterOverflow", BenchmarkCounters.Options.AbortOnBenchmarkCounterOverflow, OptionStability.EXPERIMENTAL, false, "");
            }
            case "BenchmarkCounterPrintingCutoff": {
                return OptionDescriptor.create("BenchmarkCounterPrintingCutoff", OptionType.Debug, Boolean.class, "Use a cutoff to print only most significant counters.", BenchmarkCounters.Options.class, "BenchmarkCounterPrintingCutoff", BenchmarkCounters.Options.BenchmarkCounterPrintingCutoff, OptionStability.EXPERIMENTAL, false, "");
            }
            case "BenchmarkCountersDumpDynamic": {
                return OptionDescriptor.create("BenchmarkCountersDumpDynamic", OptionType.Debug, Boolean.class, "Dump dynamic counters", BenchmarkCounters.Options.class, "BenchmarkCountersDumpDynamic", BenchmarkCounters.Options.BenchmarkCountersDumpDynamic, OptionStability.EXPERIMENTAL, false, "");
            }
            case "BenchmarkCountersDumpStatic": {
                return OptionDescriptor.create("BenchmarkCountersDumpStatic", OptionType.Debug, Boolean.class, "Dump static counters", BenchmarkCounters.Options.class, "BenchmarkCountersDumpStatic", BenchmarkCounters.Options.BenchmarkCountersDumpStatic, OptionStability.EXPERIMENTAL, false, "");
            }
            case "BenchmarkCountersFile": {
                return OptionDescriptor.create("BenchmarkCountersFile", OptionType.Debug, String.class, "File to which benchmark counters are dumped. A CSV format is used if the file ends with .csv otherwise a more human readable format is used. The fields in the CSV format are: category, group, name, value", BenchmarkCounters.Options.class, "BenchmarkCountersFile", BenchmarkCounters.Options.BenchmarkCountersFile, OptionStability.EXPERIMENTAL, false, "");
            }
            case "BenchmarkDynamicCounters": {
                return OptionDescriptor.create("BenchmarkDynamicCounters", OptionType.Debug, String.class, "Turn on the benchmark counters. The format of this option is:", new String[]{"", "  (err|out),start pattern,end pattern", "  ", "Start counting when the start pattern matches on the given stream and stop when the end pattern occurs.", "You can use \"~\" to match 1 or more digits.", "Examples:", "", "  err, starting =====, PASSED in", "  out,Iteration ~ (~s) begins:,Iteration ~ (~s) ends:", "  ", "The first pattern matches DaCapo output and the second matches SPECjvm2008 output.", "", "As a more detailed example, here are the options to use for getting statistics", "about allocations within the DaCapo pmd benchmark:", "", "  -XX:JVMCICounterSize=<value> -XX:-JVMCICountersExcludeCompiler \\", "  -Dgraal.BenchmarkDynamicCounters=\"err, starting ====, PASSED in \" \\", "  -Dgraal.ProfileAllocations=true", "  ", "The JVMCICounterSize value depends on the granularity of the profiling -", "10000 should be sufficient. Omit JVMCICountersExcludeCompiler to exclude", "counting allocations on the compiler threads.", "The counters can be further configured by the ProfileAllocationsContext option.", "", "We highly recommend the use of -Dgraal.AbortOnBenchmarkCounterOverflow=true to", "detect counter overflows eagerly."}, BenchmarkCounters.Options.class, "BenchmarkDynamicCounters", BenchmarkCounters.Options.BenchmarkDynamicCounters, OptionStability.EXPERIMENTAL, false, "");
            }
            case "DynamicCountersPrintGroupSeparator": {
                return OptionDescriptor.create("DynamicCountersPrintGroupSeparator", OptionType.Debug, Boolean.class, "Use grouping separators for number printing", BenchmarkCounters.Options.class, "DynamicCountersPrintGroupSeparator", BenchmarkCounters.Options.DynamicCountersPrintGroupSeparator, OptionStability.EXPERIMENTAL, false, "");
            }
            case "GenericDynamicCounters": {
                return OptionDescriptor.create("GenericDynamicCounters", OptionType.Debug, Boolean.class, "Turn on the benchmark counters, and displays the results on VM shutdown", BenchmarkCounters.Options.class, "GenericDynamicCounters", BenchmarkCounters.Options.GenericDynamicCounters, OptionStability.EXPERIMENTAL, false, "");
            }
            case "TimedDynamicCounters": {
                return OptionDescriptor.create("TimedDynamicCounters", OptionType.Debug, Integer.class, "Turn on the benchmark counters, and displays the results every n milliseconds", BenchmarkCounters.Options.class, "TimedDynamicCounters", BenchmarkCounters.Options.TimedDynamicCounters, OptionStability.EXPERIMENTAL, false, "");
            }
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 9;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return BenchmarkCounters_OptionDescriptors.this.get("AbortOnBenchmarkCounterOverflow");
                    }
                    case 1: {
                        return BenchmarkCounters_OptionDescriptors.this.get("BenchmarkCounterPrintingCutoff");
                    }
                    case 2: {
                        return BenchmarkCounters_OptionDescriptors.this.get("BenchmarkCountersDumpDynamic");
                    }
                    case 3: {
                        return BenchmarkCounters_OptionDescriptors.this.get("BenchmarkCountersDumpStatic");
                    }
                    case 4: {
                        return BenchmarkCounters_OptionDescriptors.this.get("BenchmarkCountersFile");
                    }
                    case 5: {
                        return BenchmarkCounters_OptionDescriptors.this.get("BenchmarkDynamicCounters");
                    }
                    case 6: {
                        return BenchmarkCounters_OptionDescriptors.this.get("DynamicCountersPrintGroupSeparator");
                    }
                    case 7: {
                        return BenchmarkCounters_OptionDescriptors.this.get("GenericDynamicCounters");
                    }
                    case 8: {
                        return BenchmarkCounters_OptionDescriptors.this.get("TimedDynamicCounters");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

