/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import jdk.vm.ci.code.Register;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.JumpToExceptionHandlerNode;
import org.graalvm.compiler.hotspot.nodes.PatchReturnAddressNode;
import org.graalvm.compiler.hotspot.nodes.StubForeignCallNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.stubs.SnippetStub;
import org.graalvm.compiler.hotspot.stubs.StubOptions;
import org.graalvm.compiler.hotspot.stubs.StubUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

public class ExceptionHandlerStub
extends SnippetStub {
    public static final HotSpotForeignCallDescriptor EXCEPTION_HANDLER_FOR_PC = StubUtil.newDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, LocationIdentity.any(), ExceptionHandlerStub.class, "exceptionHandlerForPc", Word.class, Word.class);

    public ExceptionHandlerStub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super("exceptionHandler", options, providers, linkage);
    }

    @Override
    protected Object getConstantParameterValue(int index, String name) {
        if (index == 2) {
            return this.providers.getRegisters().getThreadRegister();
        }
        assert (index == 3);
        return StubOptions.TraceExceptionHandlerStub.getValue(this.options);
    }

    @Snippet
    private static void exceptionHandler(Object exception, Word exceptionPc, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter boolean logging) {
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        ExceptionHandlerStub.checkNoExceptionInThread(thread, ExceptionHandlerStub.assertionsEnabled(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        ExceptionHandlerStub.checkExceptionNotNull(ExceptionHandlerStub.assertionsEnabled(GraalHotSpotVMConfig.INJECTED_VMCONFIG), exception);
        HotSpotReplacementsUtil.writeExceptionOop(thread, exception);
        HotSpotReplacementsUtil.writeExceptionPc(thread, exceptionPc);
        if (logging) {
            StubUtil.printf("handling exception %p (", Word.objectToTrackedPointer(exception).rawValue());
            StubUtil.decipher(Word.objectToTrackedPointer(exception).rawValue());
            StubUtil.printf(") at %p (", exceptionPc.rawValue());
            StubUtil.decipher(exceptionPc.rawValue());
            StubUtil.printf(")\n");
        }
        PatchReturnAddressNode.patchReturnAddress(exceptionPc);
        Word handlerPc = ExceptionHandlerStub.exceptionHandlerForPc(EXCEPTION_HANDLER_FOR_PC, thread);
        if (logging) {
            StubUtil.printf("handler for exception %p at %p is at %p (", Word.objectToTrackedPointer(exception).rawValue(), exceptionPc.rawValue(), handlerPc.rawValue());
            StubUtil.decipher(handlerPc.rawValue());
            StubUtil.printf(")\n");
        }
        JumpToExceptionHandlerNode.jumpToExceptionHandler(handlerPc);
    }

    static void checkNoExceptionInThread(Word thread, boolean enabled) {
        if (enabled) {
            Word currentExceptionPc;
            Object currentException = HotSpotReplacementsUtil.readExceptionOop(thread);
            if (currentException != null) {
                StubUtil.fatal("exception object in thread must be null, not %p", Word.objectToTrackedPointer(currentException).rawValue());
            }
            if (StubUtil.cAssertionsEnabled(GraalHotSpotVMConfig.INJECTED_VMCONFIG) && (currentExceptionPc = HotSpotReplacementsUtil.readExceptionPc(thread)).notEqual((Word)WordFactory.zero())) {
                StubUtil.fatal("exception PC in thread must be zero, not %p", currentExceptionPc.rawValue());
            }
        }
    }

    static void checkExceptionNotNull(boolean enabled, Object exception) {
        if (enabled && exception == null) {
            StubUtil.fatal("exception must not be null");
        }
    }

    @Fold
    static boolean assertionsEnabled(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return Assertions.assertionsEnabled() || StubUtil.cAssertionsEnabled(config);
    }

    @Node.NodeIntrinsic(value=StubForeignCallNode.class)
    public static native Word exceptionHandlerForPc(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1);
}

