/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.GraphKit;
import org.graalvm.compiler.word.WordTypes;

public class HotSpotGraphKit
extends GraphKit {
    public HotSpotGraphKit(DebugContext debug, ResolvedJavaMethod stubMethod, Providers providers, WordTypes wordTypes, GraphBuilderConfiguration.Plugins graphBuilderPlugins, CompilationIdentifier compilationId, String name, boolean trackNodeSourcePosition, boolean recordInlinedMethods) {
        super(debug, stubMethod, providers, wordTypes, graphBuilderPlugins, compilationId, name, trackNodeSourcePosition, recordInlinedMethods);
    }

    public void inlineInvokesAsIntrinsics(String reason, String phase) {
        while (!this.graph.getNodes().filter(InvokeNode.class).isEmpty()) {
            for (InvokeNode invoke : this.graph.getNodes().filter(InvokeNode.class).snapshot()) {
                this.inlineAsIntrinsic(invoke, reason, phase);
            }
        }
        new DeadCodeEliminationPhase().apply(this.graph);
    }

    public void inlineAsIntrinsic(Invoke invoke, String reason, String phase) {
        StructuredGraph calleeGraph;
        assert (invoke instanceof Node);
        Node invokeNode = (Node)((Object)invoke);
        ResolvedJavaMethod method = invoke.callTarget().targetMethod();
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(this.graphBuilderPlugins);
        GraphBuilderConfiguration config = GraphBuilderConfiguration.getSnippetDefault(plugins);
        if (Services.IS_IN_NATIVE_IMAGE) {
            calleeGraph = this.getReplacements().getSnippet(method, null, null, null, false, null, invokeNode.getOptions());
        } else {
            calleeGraph = new StructuredGraph.Builder(invokeNode.getOptions(), invokeNode.getDebug()).method(method).trackNodeSourcePosition(invokeNode.graph().trackNodeSourcePosition()).setIsSubstitution(true).build();
            IntrinsicContext initialReplacementContext = new IntrinsicContext(method, method, this.getReplacements().getDefaultReplacementBytecodeProvider(), IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING);
            GraphBuilderPhase.Instance instance = this.createGraphBuilderInstance(config, OptimisticOptimizations.NONE, initialReplacementContext);
            instance.apply(calleeGraph);
        }
        new DeadCodeEliminationPhase().apply(calleeGraph);
        InliningUtil.inline(invoke, calleeGraph, false, method, reason, phase);
    }

    protected GraphBuilderPhase.Instance createGraphBuilderInstance(GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
        return new GraphBuilderPhase.Instance(this.getProviders(), graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
    }
}

