/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import jdk.vm.ci.code.Register;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.AllocaNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.stubs.CreateExceptionStub;
import org.graalvm.compiler.hotspot.stubs.StubUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.word.Word;

public class OutOfBoundsExceptionStub
extends CreateExceptionStub {
    static final int MAX_INT_STRING_SIZE = Integer.toString(Integer.MIN_VALUE).length();
    private static final String STR_INDEX = "Index ";
    private static final String STR_OUTOFBOUNDSFORLENGTH = " out of bounds for length ";

    public OutOfBoundsExceptionStub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super("createOutOfBoundsException", options, providers, linkage);
    }

    @Override
    protected Object getConstantParameterValue(int index, String name) {
        switch (index) {
            case 2: {
                return this.providers.getRegisters().getThreadRegister();
            }
            case 3: {
                int bytes = STR_INDEX.length() + STR_OUTOFBOUNDSFORLENGTH.length() + 2 * MAX_INT_STRING_SIZE;
                return bytes + 1;
            }
            case 4: {
                return true;
            }
        }
        throw GraalError.shouldNotReachHere("unknown parameter " + name + " at index " + index);
    }

    @Snippet
    private static Object createOutOfBoundsException(int idx, int length, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter int bufferSizeInBytes, @Snippet.ConstantParameter boolean printLengthInException) {
        Word ptr;
        Word buffer = AllocaNode.alloca(bufferSizeInBytes, HotSpotReplacementsUtil.wordSize());
        if (printLengthInException) {
            ptr = StubUtil.printString(buffer, STR_INDEX);
            ptr = StubUtil.printNumber(ptr, idx);
            ptr = StubUtil.printString(ptr, STR_OUTOFBOUNDSFORLENGTH);
            ptr = StubUtil.printNumber(ptr, length);
        } else {
            ptr = StubUtil.printNumber(buffer, idx);
        }
        ptr.writeByte(0, (byte)0);
        return OutOfBoundsExceptionStub.createException(threadRegister, ArrayIndexOutOfBoundsException.class, buffer);
    }
}

