/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import jdk.vm.ci.code.Register;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.JumpToExceptionHandlerInCallerNode;
import org.graalvm.compiler.hotspot.nodes.StubForeignCallNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.stubs.ExceptionHandlerStub;
import org.graalvm.compiler.hotspot.stubs.SnippetStub;
import org.graalvm.compiler.hotspot.stubs.StubOptions;
import org.graalvm.compiler.hotspot.stubs.StubUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;

public class UnwindExceptionToCallerStub
extends SnippetStub {
    public static final HotSpotForeignCallDescriptor EXCEPTION_HANDLER_FOR_RETURN_ADDRESS = StubUtil.newDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, LocationIdentity.any(), UnwindExceptionToCallerStub.class, "exceptionHandlerForReturnAddress", Word.class, Word.class, Word.class);

    public UnwindExceptionToCallerStub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super("unwindExceptionToCaller", options, providers, linkage);
    }

    @Override
    protected Object getConstantParameterValue(int index, String name) {
        if (index == 2) {
            return this.providers.getRegisters().getThreadRegister();
        }
        throw new InternalError();
    }

    @Snippet
    private static void unwindExceptionToCaller(Object exception, Word returnAddress, @Snippet.ConstantParameter Register threadRegister) {
        Word exceptionOop = Word.objectToTrackedPointer(exception);
        if (UnwindExceptionToCallerStub.logging(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES)) {
            StubUtil.printf("unwinding exception %p (", exceptionOop.rawValue());
            StubUtil.decipher(exceptionOop.rawValue());
            StubUtil.printf(") at %p (", returnAddress.rawValue());
            StubUtil.decipher(returnAddress.rawValue());
            StubUtil.printf(")\n");
        }
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        ExceptionHandlerStub.checkNoExceptionInThread(thread, UnwindExceptionToCallerStub.assertionsEnabled(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        ExceptionHandlerStub.checkExceptionNotNull(UnwindExceptionToCallerStub.assertionsEnabled(GraalHotSpotVMConfig.INJECTED_VMCONFIG), exception);
        Word handlerInCallerPc = UnwindExceptionToCallerStub.exceptionHandlerForReturnAddress(EXCEPTION_HANDLER_FOR_RETURN_ADDRESS, thread, returnAddress);
        if (UnwindExceptionToCallerStub.logging(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES)) {
            StubUtil.printf("handler for exception %p at return address %p is at %p (", exceptionOop.rawValue(), returnAddress.rawValue(), handlerInCallerPc.rawValue());
            StubUtil.decipher(handlerInCallerPc.rawValue());
            StubUtil.printf(")\n");
        }
        JumpToExceptionHandlerInCallerNode.jumpToExceptionHandlerInCaller(handlerInCallerPc, exception, returnAddress);
    }

    @Fold
    static boolean logging(@Fold.InjectedParameter OptionValues options) {
        return StubOptions.TraceUnwindStub.getValue(options);
    }

    @Fold
    static boolean assertionsEnabled(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return Assertions.assertionsEnabled() || StubUtil.cAssertionsEnabled(config);
    }

    @Node.NodeIntrinsic(value=StubForeignCallNode.class)
    public static native Word exceptionHandlerForReturnAddress(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2);
}

