/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.java;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.util.Providers;

public final class LambdaUtils {
    private static final Pattern LAMBDA_PATTERN;
    private static final char[] HEX;
    public static final String LAMBDA_SPLIT_PATTERN;
    public static final String LAMBDA_CLASS_NAME_SUBSTRING;
    public static final String SERIALIZATION_TEST_LAMBDA_CLASS_SUBSTRING = "$$Lambda";
    public static final String SERIALIZATION_TEST_LAMBDA_CLASS_SPLIT_PATTERN = "\\$\\$Lambda";
    public static final String ADDRESS_PREFIX = ".0x";

    private static GraphBuilderConfiguration buildLambdaParserConfig(ClassInitializationPlugin cip) {
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(new InvocationPlugins());
        plugins.setClassInitializationPlugin(cip);
        return GraphBuilderConfiguration.getDefault(plugins).withEagerResolving(true);
    }

    private LambdaUtils() {
    }

    public static String findStableLambdaName(ClassInitializationPlugin cip, Providers providers, ResolvedJavaType lambdaType, OptionValues options, DebugContext debug, Object ctx) throws RuntimeException {
        ResolvedJavaMethod[] lambdaProxyMethods = (ResolvedJavaMethod[])Arrays.stream(lambdaType.getDeclaredMethods(false)).filter(m -> !m.isBridge() && m.isPublic()).toArray(ResolvedJavaMethod[]::new);
        StructuredGraph graph = new StructuredGraph.Builder(options, debug).method(lambdaProxyMethods[0]).build();
        try (DebugContext.Scope ignored = debug.scope("Lambda target method analysis", graph, lambdaType, ctx);){
            LambdaGraphBuilder lambdaParserPhase = new LambdaGraphBuilder(LambdaUtils.buildLambdaParserConfig(cip));
            HighTierContext context = new HighTierContext(providers, null, OptimisticOptimizations.NONE);
            lambdaParserPhase.apply(graph, context);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        List<ResolvedJavaMethod> invokedMethods = StreamSupport.stream(graph.getInvokes().spliterator(), false).map(Invoke::getTargetMethod).collect(Collectors.toList());
        if (invokedMethods.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Lambda without a target invoke: ").append(lambdaType.toClassName());
            for (ResolvedJavaMethod m2 : lambdaType.getDeclaredMethods(false)) {
                sb.append("\n  Method: ").append(m2);
            }
            throw new JVMCIError(sb.toString());
        }
        return LambdaUtils.createStableLambdaName(lambdaType, invokedMethods);
    }

    public static boolean isLambdaType(ResolvedJavaType type) {
        String typeName = type.getName();
        return type.isFinalFlagSet() && LambdaUtils.isLambdaName(typeName);
    }

    public static boolean isLambdaName(String name) {
        return name.contains(LAMBDA_CLASS_NAME_SUBSTRING) && LambdaUtils.lambdaMatcher(name).find();
    }

    private static String createStableLambdaName(ResolvedJavaType lambdaType, List<ResolvedJavaMethod> targetMethods) {
        String lambdaName = lambdaType.getName();
        assert (LambdaUtils.lambdaMatcher(lambdaName).find()) : "Stable name should be created for lambda types: " + lambdaName;
        Matcher m = LambdaUtils.lambdaMatcher(lambdaName);
        StringBuilder sb = new StringBuilder();
        targetMethods.forEach(targetMethod -> sb.append(targetMethod.format("%H.%n(%P)%R")));
        return m.replaceFirst(Matcher.quoteReplacement(LAMBDA_CLASS_NAME_SUBSTRING + ADDRESS_PREFIX + LambdaUtils.digest(sb.toString()) + ";"));
    }

    private static Matcher lambdaMatcher(String value) {
        return LAMBDA_PATTERN.matcher(value);
    }

    public static String toHex(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(HEX[b >> 4 & 0xF]);
            r.append(HEX[b & 0xF]);
        }
        return r.toString();
    }

    public static String digest(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(value.getBytes(StandardCharsets.UTF_8));
            return LambdaUtils.toHex(md.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new JVMCIError((Throwable)ex);
        }
    }

    public static String capturingClass(String className) {
        return className.split(SERIALIZATION_TEST_LAMBDA_CLASS_SPLIT_PATTERN)[0];
    }

    static {
        HEX = "0123456789abcdef".toCharArray();
        if (Runtime.version().feature() < 21) {
            LAMBDA_PATTERN = Pattern.compile("\\$\\$Lambda\\$\\d+[/.][^/]+;");
            LAMBDA_SPLIT_PATTERN = "\\$\\$Lambda\\$";
            LAMBDA_CLASS_NAME_SUBSTRING = "$$Lambda$";
        } else {
            LAMBDA_PATTERN = Pattern.compile("\\$\\$Lambda[/.][^/]+;");
            LAMBDA_SPLIT_PATTERN = SERIALIZATION_TEST_LAMBDA_CLASS_SPLIT_PATTERN;
            LAMBDA_CLASS_NAME_SUBSTRING = SERIALIZATION_TEST_LAMBDA_CLASS_SUBSTRING;
        }
    }

    private static final class LambdaGraphBuilder
    extends GraphBuilderPhase {
        private LambdaGraphBuilder(GraphBuilderConfiguration config) {
            super(config);
        }

        @Override
        protected GraphBuilderPhase.Instance createInstance(CoreProviders providers, GraphBuilderConfiguration instanceGBConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
            return new Instance(providers, instanceGBConfig, optimisticOpts, initialIntrinsicContext);
        }

        private static class Instance
        extends GraphBuilderPhase.Instance {
            Instance(CoreProviders providers, GraphBuilderConfiguration instanceGBConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
                super(providers, instanceGBConfig, optimisticOpts, initialIntrinsicContext);
            }

            @Override
            protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
                return new LambdaBytecodeParser(this, graph, parent, method, entryBCI, intrinsicContext);
            }
        }
    }

    private static class LambdaBytecodeParser
    extends BytecodeParser {
        LambdaBytecodeParser(GraphBuilderPhase.Instance instance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            super(instance, graph, parent, method, entryBCI, intrinsicContext);
        }

        @Override
        protected Object lookupConstant(int cpi, int opcode, boolean allowBootstrapMethodInvocation) {
            return super.lookupConstant(cpi, opcode, true);
        }
    }
}

