/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.amd64.EndbranchOp;

public final class LIRInsertionBuffer {
    private List<LIRInstruction> lir;
    private int[] indexAndCount = new int[8];
    private int indexAndCountSize;
    private final List<LIRInstruction> ops = new ArrayList<LIRInstruction>(4);

    public void init(List<LIRInstruction> newLir) {
        assert (!this.initialized()) : "already initialized";
        assert (this.indexAndCountSize == 0 && this.ops.size() == 0);
        this.lir = newLir;
    }

    public boolean initialized() {
        return this.lir != null;
    }

    public List<LIRInstruction> lirList() {
        return this.lir;
    }

    public void append(int index, LIRInstruction op) {
        if (this.lir.size() > index && this.lir.get(index) instanceof EndbranchOp) {
            throw GraalError.shouldNotReachHere("Cannot insert before EndBranch: " + op);
        }
        int i = this.numberOfInsertionPoints() - 1;
        if (i < 0 || this.indexAt(i) < index) {
            this.appendNew(index, 1);
        } else {
            assert (this.indexAt(i) == index) : "can append LIROps in ascending order only";
            assert (this.countAt(i) > 0) : "check";
            this.setCountAt(i, this.countAt(i) + 1);
        }
        this.ops.add(op);
        assert (this.verify());
    }

    public void finish() {
        if (this.ops.size() > 0) {
            int n = this.lir.size();
            for (int i = 0; i < this.ops.size(); ++i) {
                this.lir.add(null);
            }
            int opIndex = this.ops.size() - 1;
            int fromIndex = n - 1;
            int toIndex = this.lir.size() - 1;
            for (int ipIndex = this.numberOfInsertionPoints() - 1; ipIndex >= 0; --ipIndex) {
                int index = this.indexAt(ipIndex);
                while (fromIndex >= index) {
                    this.lir.set(toIndex--, this.lir.get(fromIndex--));
                }
                for (int i = this.countAt(ipIndex); i > 0; --i) {
                    this.lir.set(toIndex--, this.ops.get(opIndex--));
                }
            }
            this.indexAndCountSize = 0;
            this.ops.clear();
        }
        this.lir = null;
    }

    private void appendNew(int index, int count) {
        int oldSize = this.indexAndCountSize;
        int newSize = oldSize + 2;
        if (newSize > this.indexAndCount.length) {
            this.indexAndCount = Arrays.copyOf(this.indexAndCount, newSize * 2);
        }
        this.indexAndCount[oldSize] = index;
        this.indexAndCount[oldSize + 1] = count;
        this.indexAndCountSize = newSize;
    }

    private void setCountAt(int i, int value) {
        this.indexAndCount[(i << 1) + 1] = value;
    }

    private int numberOfInsertionPoints() {
        assert (this.indexAndCount.length % 2 == 0) : "must have a count for each index";
        return this.indexAndCountSize >> 1;
    }

    private int indexAt(int i) {
        return this.indexAndCount[i << 1];
    }

    private int countAt(int i) {
        return this.indexAndCount[(i << 1) + 1];
    }

    private boolean verify() {
        int sum = 0;
        int prevIdx = -1;
        for (int i = 0; i < this.numberOfInsertionPoints(); ++i) {
            assert (prevIdx < this.indexAt(i)) : "index must be ordered ascending";
            sum += this.countAt(i);
        }
        assert (sum == this.ops.size()) : "wrong total sum";
        return true;
    }
}

