/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.SyncPort;
import org.graalvm.compiler.lir.SyncPorts;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@SyncPorts(value={@SyncPort(from="https://github.com/openjdk/jdk/blob/12358e6c94bc96e618efc3ec5299a2cfe1b4669d/src/hotspot/cpu/aarch64/stubGenerator_aarch64.cpp#L2702-L2733", sha1="69b7e01dbc601afd660d5dcef88917a43613e00c"), @SyncPort(from="https://github.com/openjdk/jdk/blob/12358e6c94bc96e618efc3ec5299a2cfe1b4669d/src/hotspot/cpu/aarch64/macroAssembler_aarch64_aes.cpp#L34-L110", sha1="4916141cba98c26e4d98edb457161f88a8c66ffa")})
public final class AArch64AESDecryptOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64AESDecryptOp> TYPE = LIRInstructionClass.create(AArch64AESDecryptOp.class);
    private final int lengthOffset;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value fromValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value toValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value keyValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] temps;

    public AArch64AESDecryptOp(Value fromValue, Value toValue, Value keyValue, int lengthOffset) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.fromValue = fromValue;
        this.toValue = toValue;
        this.keyValue = keyValue;
        this.lengthOffset = lengthOffset;
        this.temps = new Value[]{AArch64.v0.asValue(), AArch64.v1.asValue(), AArch64.v2.asValue(), AArch64.v3.asValue(), AArch64.v4.asValue(), AArch64.v5.asValue()};
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        GraalError.guarantee(this.fromValue.getPlatformKind().equals(AArch64Kind.QWORD), "Invalid fromValue kind: %s", (Object)this.fromValue);
        GraalError.guarantee(this.toValue.getPlatformKind().equals(AArch64Kind.QWORD), "Invalid toValue kind: %s", (Object)this.toValue);
        GraalError.guarantee(this.keyValue.getPlatformKind().equals(AArch64Kind.QWORD), "Invalid keyValue kind: %s", (Object)this.keyValue);
        Register from = ValueUtil.asRegister((Value)this.fromValue);
        Register to = ValueUtil.asRegister((Value)this.toValue);
        Register key = ValueUtil.asRegister((Value)this.keyValue);
        try (AArch64MacroAssembler.ScratchRegister sr = masm.getScratchRegister();){
            Register keylen = sr.getRegister();
            masm.ldr(32, keylen, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, key, this.lengthOffset));
            AArch64AESDecryptOp.aesecbDecrypt(masm, from, to, key, keylen);
        }
    }

    private static void aesecbDecrypt(AArch64MacroAssembler masm, Register from, Register to, Register key, Register keylen) {
        Label labelDoLast = new Label();
        masm.fldr(128, AArch64.v0, AArch64Address.createBaseRegisterOnlyAddress(128, from));
        masm.fldr(128, AArch64.v5, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, key, 16));
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v5, AArch64.v5);
        AArch64Address ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 64);
        masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v1);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v2, AArch64.v2);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v3, AArch64.v3);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v4, AArch64.v4);
        masm.neon.aesd(AArch64.v0, AArch64.v1);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v2);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v3);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v4);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 64);
        masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v1);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v2, AArch64.v2);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v3, AArch64.v3);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v4, AArch64.v4);
        masm.neon.aesd(AArch64.v0, AArch64.v1);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v2);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v3);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v4);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 32);
        masm.neon.ld1MultipleVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v2, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v1);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v2, AArch64.v2);
        masm.compare(32, keylen, 44);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, labelDoLast);
        masm.neon.aesd(AArch64.v0, AArch64.v1);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v2);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 32);
        masm.neon.ld1MultipleVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v2, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v1);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v2, AArch64.v2);
        masm.compare(32, keylen, 52);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, labelDoLast);
        masm.neon.aesd(AArch64.v0, AArch64.v1);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v2);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 32);
        masm.neon.ld1MultipleVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v2, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v1);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v2, AArch64.v2);
        masm.bind(labelDoLast);
        masm.neon.aesd(AArch64.v0, AArch64.v1);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v2);
        masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v0, AArch64.v0, AArch64.v5);
        masm.fstr(128, AArch64.v0, AArch64Address.createBaseRegisterOnlyAddress(128, to));
        masm.sub(64, key, key, keylen, AArch64Assembler.ShiftType.LSL, CodeUtil.log2((int)JavaKind.Int.getByteCount()));
    }
}

