/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import java.util.Arrays;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64ComplexVectorOp;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="AArch64_ARRAY_INDEX_OF")
public final class AArch64ArrayIndexOfOp
extends AArch64ComplexVectorOp {
    public static final LIRInstructionClass<AArch64ArrayIndexOfOp> TYPE = LIRInstructionClass.create(AArch64ArrayIndexOfOp.class);
    private final LIRGeneratorTool.ArrayIndexOfVariant variant;
    private final boolean findTwoConsecutive;
    private final boolean withMask;
    private final Stride stride;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue arrayPtrValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue arrayOffsetValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue arrayLengthValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue fromIndexValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue[] searchValues;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue[] temp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value[] vectorTemp;

    public AArch64ArrayIndexOfOp(Stride stride, LIRGeneratorTool.ArrayIndexOfVariant variant, LIRGeneratorTool tool, AllocatableValue result, AllocatableValue arrayPtr, AllocatableValue arrayOffset, AllocatableValue arrayLength, AllocatableValue fromIndex, AllocatableValue[] searchValues) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        int nValues = searchValues.length;
        GraalError.guarantee(result.getPlatformKind() == AArch64Kind.DWORD, "int value expected");
        GraalError.guarantee(arrayPtr.getPlatformKind() == AArch64Kind.QWORD, "pointer value expected");
        GraalError.guarantee(arrayOffset.getPlatformKind() == AArch64Kind.QWORD, "long value expected");
        GraalError.guarantee(arrayLength.getPlatformKind() == AArch64Kind.DWORD, "int value expected");
        GraalError.guarantee(fromIndex.getPlatformKind() == AArch64Kind.DWORD, "int value expected");
        if (variant == LIRGeneratorTool.ArrayIndexOfVariant.Table) {
            GraalError.guarantee(searchValues.length == 1 && searchValues[0].getPlatformKind() == AArch64Kind.QWORD, "single pointer value expected");
        } else {
            GraalError.guarantee(Arrays.stream(searchValues).allMatch(sv -> sv.getPlatformKind() == AArch64Kind.DWORD), "int values expected");
        }
        this.stride = stride;
        this.variant = variant;
        this.findTwoConsecutive = variant == LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutive || variant == LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutiveWithMask;
        this.withMask = variant == LIRGeneratorTool.ArrayIndexOfVariant.WithMask || variant == LIRGeneratorTool.ArrayIndexOfVariant.FindTwoConsecutiveWithMask;
        this.resultValue = result;
        this.arrayPtrValue = arrayPtr;
        this.arrayOffsetValue = arrayOffset;
        this.arrayLengthValue = arrayLength;
        this.fromIndexValue = fromIndex;
        this.searchValues = searchValues;
        this.temp = AArch64ArrayIndexOfOp.allocateTempRegisters(tool, 5);
        this.vectorTemp = AArch64ArrayIndexOfOp.allocateVectorRegisters(tool, AArch64ArrayIndexOfOp.getNumberOfRequiredVectorRegisters(variant, stride, nValues), variant == LIRGeneratorTool.ArrayIndexOfVariant.Table);
    }

    private static int getNumberOfRequiredVectorRegisters(LIRGeneratorTool.ArrayIndexOfVariant variant, Stride stride, int nValues) {
        switch (variant) {
            case MatchAny: {
                return nValues + (nValues > 1 ? 6 : 3);
            }
            case MatchRange: {
                return nValues + 6;
            }
            case WithMask: {
                return nValues + 3;
            }
            case FindTwoConsecutive: 
            case FindTwoConsecutiveWithMask: {
                return nValues + 5;
            }
            case Table: {
                switch (stride) {
                    case S1: {
                        return 7;
                    }
                    case S2: {
                        return 9;
                    }
                    case S4: {
                        return 11;
                    }
                }
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)stride);
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)variant);
    }

    private void emitScalarCode(AArch64MacroAssembler masm, Register baseAddress, Register searchLength) {
        Register maskReg;
        Register searchValueReg;
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register arrayLength = ValueUtil.asRegister((Value)this.arrayLengthValue);
        Register curValue = ValueUtil.asRegister((Value)this.temp[2]);
        Label match = new Label();
        Label searchByElementLoop = new Label();
        Label done = new Label();
        int memAccessSize = (this.findTwoConsecutive ? 2 : 1) * this.stride.value * 8;
        int compareSize = Math.max(32, memAccessSize);
        if (this.findTwoConsecutive) {
            searchValueReg = ValueUtil.asRegister((Value)this.temp[3]);
            masm.lsl(compareSize, searchValueReg, ValueUtil.asRegister((Value)this.searchValues[1]), (long)this.stride.value * 8L);
            masm.orr(compareSize, searchValueReg, searchValueReg, ValueUtil.asRegister((Value)this.searchValues[0]));
            if (this.withMask) {
                maskReg = ValueUtil.asRegister((Value)this.temp[4]);
                masm.lsl(compareSize, maskReg, ValueUtil.asRegister((Value)this.searchValues[3]), (long)this.stride.value * 8L);
                masm.orr(compareSize, maskReg, maskReg, ValueUtil.asRegister((Value)this.searchValues[2]));
            } else {
                maskReg = null;
            }
        } else {
            searchValueReg = ValueUtil.asRegister((Value)this.searchValues[0]);
            maskReg = this.withMask ? ValueUtil.asRegister((Value)this.searchValues[1]) : null;
        }
        Register endIndex = arrayLength;
        if (this.findTwoConsecutive) {
            masm.sub(32, endIndex, endIndex, 1);
            masm.cbz(32, endIndex, done);
        }
        masm.add(64, baseAddress, baseAddress, endIndex, AArch64Assembler.ExtendType.SXTW, this.stride.log2);
        Register curIndex = searchLength;
        masm.sub(64, curIndex, AArch64.zr, curIndex, AArch64Assembler.ShiftType.LSL, this.stride.log2);
        masm.align(16);
        masm.bind(searchByElementLoop);
        masm.ldr(memAccessSize, curValue, AArch64Address.createRegisterOffsetAddress(memAccessSize, baseAddress, curIndex, false));
        switch (this.variant) {
            case MatchAny: {
                for (AllocatableValue searchValue : this.searchValues) {
                    masm.cmp(compareSize, ValueUtil.asRegister((Value)searchValue), curValue);
                    masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, match);
                }
                break;
            }
            case MatchRange: {
                for (int i = 0; i < this.searchValues.length; i += 2) {
                    Label noMatch = new Label();
                    masm.cmp(compareSize, curValue, ValueUtil.asRegister((Value)this.searchValues[i]));
                    masm.branchConditionally(AArch64Assembler.ConditionFlag.LO, noMatch);
                    masm.cmp(compareSize, curValue, ValueUtil.asRegister((Value)this.searchValues[i + 1]));
                    masm.branchConditionally(AArch64Assembler.ConditionFlag.LS, match);
                    masm.bind(noMatch);
                }
                break;
            }
            case WithMask: 
            case FindTwoConsecutiveWithMask: {
                masm.orr(compareSize, curValue, curValue, maskReg);
                masm.cmp(compareSize, searchValueReg, curValue);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, match);
                break;
            }
            case FindTwoConsecutive: {
                masm.cmp(compareSize, searchValueReg, curValue);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, match);
                break;
            }
            case Table: {
                Label greaterThan0xff = new Label();
                AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();
                try {
                    Register tmp = sc.getRegister();
                    if (this.stride.value > 1) {
                        masm.compare(compareSize, curValue, 255);
                        masm.branchConditionally(AArch64Assembler.ConditionFlag.HI, greaterThan0xff);
                    }
                    masm.and(compareSize, tmp, curValue, 15L);
                    masm.asr(compareSize, curValue, curValue, 4L);
                    masm.add(compareSize, tmp, tmp, 16);
                    masm.ldr(8, curValue, AArch64Address.createRegisterOffsetAddress(8, ValueUtil.asRegister((Value)this.searchValues[0]), curValue, false));
                    masm.ldr(8, tmp, AArch64Address.createRegisterOffsetAddress(8, ValueUtil.asRegister((Value)this.searchValues[0]), tmp, false));
                    masm.tst(compareSize, curValue, tmp);
                    masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, match);
                    masm.bind(greaterThan0xff);
                    if (sc == null) break;
                    sc.close();
                    break;
                }
                catch (Throwable throwable) {
                    if (sc != null) {
                        try {
                            sc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        masm.adds(64, curIndex, curIndex, this.stride.value);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.MI, searchByElementLoop);
        masm.jmp(done);
        masm.align(16);
        masm.bind(match);
        masm.add(32, result, endIndex, curIndex, AArch64Assembler.ShiftType.ASR, this.stride.log2);
        masm.bind(done);
        if (this.findTwoConsecutive) {
            masm.add(32, endIndex, endIndex, 1);
        }
    }

    private void emitSIMDCode(AArch64MacroAssembler masm, Register baseAddress) {
        Register vecArray2;
        Register vecArray1;
        Register vecTableLo;
        Register vecTableHi;
        Register vecMask0x0f;
        Register[] vecTmp;
        Register[] vecSearchValues;
        Register array;
        Register refAddress;
        Register searchEnd;
        Register currOffset;
        Register fromIndex;
        Register arrayLength;
        Register result;
        int chunkSize;
        block27: {
            int i;
            block26: {
                chunkSize = this.getSIMDLoopChunkSize();
                result = ValueUtil.asRegister((Value)this.resultValue);
                arrayLength = ValueUtil.asRegister((Value)this.arrayLengthValue);
                fromIndex = ValueUtil.asRegister((Value)this.fromIndexValue);
                currOffset = ValueUtil.asRegister((Value)this.temp[1]);
                searchEnd = ValueUtil.asRegister((Value)this.temp[2]);
                refAddress = ValueUtil.asRegister((Value)this.temp[3]);
                array = ValueUtil.asRegister((Value)this.temp[4]);
                vecSearchValues = new Register[this.searchValues.length];
                vecTmp = new Register[this.vectorTemp.length - (this.searchValues.length + 2)];
                if (this.variant != LIRGeneratorTool.ArrayIndexOfVariant.Table) break block26;
                vecMask0x0f = ValueUtil.asRegister((Value)this.vectorTemp[0]);
                vecTableHi = ValueUtil.asRegister((Value)this.vectorTemp[1]);
                vecTableLo = ValueUtil.asRegister((Value)this.vectorTemp[2]);
                switch (this.stride) {
                    case S1: {
                        vecArray1 = ValueUtil.asRegister((Value)this.vectorTemp[3]);
                        vecArray2 = ValueUtil.asRegister((Value)this.vectorTemp[4]);
                        vecTmp[0] = ValueUtil.asRegister((Value)this.vectorTemp[5]);
                        vecTmp[1] = ValueUtil.asRegister((Value)this.vectorTemp[6]);
                        break block27;
                    }
                    case S2: {
                        vecArray1 = ValueUtil.asRegister((Value)this.vectorTemp[3]);
                        vecTmp[0] = ValueUtil.asRegister((Value)this.vectorTemp[4]);
                        vecArray2 = ValueUtil.asRegister((Value)this.vectorTemp[5]);
                        vecTmp[1] = ValueUtil.asRegister((Value)this.vectorTemp[6]);
                        vecTmp[2] = ValueUtil.asRegister((Value)this.vectorTemp[7]);
                        vecTmp[3] = ValueUtil.asRegister((Value)this.vectorTemp[8]);
                        break block27;
                    }
                    case S4: {
                        vecArray1 = ValueUtil.asRegister((Value)this.vectorTemp[3]);
                        vecTmp[0] = ValueUtil.asRegister((Value)this.vectorTemp[4]);
                        vecTmp[1] = ValueUtil.asRegister((Value)this.vectorTemp[5]);
                        vecTmp[2] = ValueUtil.asRegister((Value)this.vectorTemp[6]);
                        vecArray2 = ValueUtil.asRegister((Value)this.vectorTemp[7]);
                        vecTmp[3] = ValueUtil.asRegister((Value)this.vectorTemp[8]);
                        vecTmp[4] = ValueUtil.asRegister((Value)this.vectorTemp[9]);
                        vecTmp[5] = ValueUtil.asRegister((Value)this.vectorTemp[10]);
                        break block27;
                    }
                    default: {
                        throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.stride);
                    }
                }
            }
            vecArray1 = ValueUtil.asRegister((Value)this.vectorTemp[0]);
            vecArray2 = ValueUtil.asRegister((Value)this.vectorTemp[1]);
            for (i = 0; i < this.searchValues.length; ++i) {
                vecSearchValues[i] = ValueUtil.asRegister((Value)this.vectorTemp[i + 2]);
            }
            for (i = this.searchValues.length + 2; i < this.vectorTemp.length - (this.findTwoConsecutive ? 1 : 0); ++i) {
                vecTmp[i - (this.searchValues.length + 2)] = ValueUtil.asRegister((Value)this.vectorTemp[i]);
            }
            vecMask0x0f = null;
            vecTableHi = null;
            vecTableLo = null;
        }
        Register vecLastArray2 = this.findTwoConsecutive ? ValueUtil.asRegister((Value)this.vectorTemp[this.vectorTemp.length - 1]) : null;
        Label matchInChunk = new Label();
        Label searchByChunkLoopHead = new Label();
        Label searchByChunkLoopTail = new Label();
        Label processTail = new Label();
        Label end = new Label();
        AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromStride(this.stride);
        if (this.variant == LIRGeneratorTool.ArrayIndexOfVariant.Table) {
            masm.fldp(128, vecTableHi, vecTableLo, AArch64Address.createPairBaseRegisterOnlyAddress(128, ValueUtil.asRegister((Value)this.searchValues[0])));
            masm.neon.moveVI(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecMask0x0f, 15L);
        } else {
            for (int i = 0; i < this.searchValues.length; ++i) {
                masm.neon.dupVG(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecSearchValues[i], ValueUtil.asRegister((Value)this.searchValues[i]));
            }
        }
        masm.add(64, searchEnd, baseAddress, arrayLength, AArch64Assembler.ExtendType.SXTW, this.stride.log2);
        masm.sub(64, refAddress, searchEnd, chunkSize);
        masm.add(64, array, baseAddress, fromIndex, AArch64Assembler.ExtendType.SXTW, this.stride.log2);
        if (this.findTwoConsecutive) {
            masm.neon.notVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecLastArray2, vecSearchValues[0]);
            masm.cmp(64, refAddress, array);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.LS, processTail);
            masm.sub(64, currOffset, array, baseAddress);
            masm.fldp(128, vecArray1, vecArray2, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, array, 32));
            this.emitSIMDMatch(masm, eSize, array, vecSearchValues, vecTmp, vecArray1, vecArray2, vecLastArray2, vecMask0x0f, vecTableHi, vecTableLo, matchInChunk);
            masm.bic(64, array, array, chunkSize - 1);
            masm.fldr(128, vecArray2, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, array, -this.stride.value));
            masm.neon.insXX(eSize, vecLastArray2, AArch64ASIMDAssembler.ASIMDSize.FullReg.bytes() / this.stride.value - 1, vecArray2, 0);
        }
        masm.align(16);
        masm.bind(searchByChunkLoopHead);
        masm.cmp(64, refAddress, array);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.LS, processTail);
        masm.bind(searchByChunkLoopTail);
        masm.sub(64, currOffset, array, baseAddress);
        if (this.variant != LIRGeneratorTool.ArrayIndexOfVariant.Table) {
            masm.fldp(128, vecArray1, vecArray2, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, array, 32));
        }
        this.emitSIMDMatch(masm, eSize, array, vecSearchValues, vecTmp, vecArray1, vecArray2, vecLastArray2, vecMask0x0f, vecTableHi, vecTableLo, matchInChunk);
        if (!this.findTwoConsecutive) {
            masm.bic(64, array, array, chunkSize - 1);
        }
        masm.jmp(searchByChunkLoopHead);
        masm.align(16);
        masm.bind(processTail);
        masm.cmp(64, array, searchEnd);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.HS, end);
        if (this.findTwoConsecutive) {
            masm.sub(64, array, searchEnd, chunkSize + this.stride.value);
            masm.fldr(128, vecArray2, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, array, this.stride.value));
            masm.neon.insXX(eSize, vecLastArray2, AArch64ASIMDAssembler.ASIMDSize.FullReg.bytes() / this.stride.value - 1, vecArray2, 0);
        } else {
            masm.sub(64, array, searchEnd, chunkSize);
        }
        masm.mov(64, searchEnd, AArch64.zr);
        masm.jmp(searchByChunkLoopTail);
        masm.align(16);
        masm.bind(matchInChunk);
        if (this.variant == LIRGeneratorTool.ArrayIndexOfVariant.Table) {
            masm.neon.cmtstVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecArray1, vecArray1, vecArray1);
            masm.neon.cmtstVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecArray2, vecArray2, vecArray2);
        }
        try (AArch64MacroAssembler.ScratchRegister scratchReg = masm.getScratchRegister();){
            Register tmp = scratchReg.getRegister();
            AArch64ArrayIndexOfOp.initCalcIndexOfFirstMatchMask(masm, vecTmp[0], tmp);
            AArch64ArrayIndexOfOp.calcIndexOfFirstMatch(masm, tmp, vecArray1, vecArray2, vecTmp[0], false);
            if (this.variant == LIRGeneratorTool.ArrayIndexOfVariant.Table) {
                masm.asr(64, currOffset, currOffset, this.stride.log2);
            }
            masm.add(64, result, currOffset, tmp, AArch64Assembler.ShiftType.ASR, 1);
            if (this.findTwoConsecutive) {
                masm.sub(64, result, result, 1);
            }
        }
        if (this.getMatchResultStride().log2 != 0) {
            masm.asr(64, result, result, this.getMatchResultStride().log2);
        }
        masm.bind(end);
    }

    private void emitSIMDMatch(AArch64MacroAssembler masm, AArch64ASIMDAssembler.ElementSize eSize, Register array, Register[] vecSearchValues, Register[] vecTmp, Register vecArray1, Register vecArray2, Register vecLastArray2, Register vecMask0x0f, Register vecTableHi, Register vecTableLo, Label matchInChunk) {
        if (this.findTwoConsecutive) {
            masm.neon.extVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp[0], vecLastArray2, vecArray1, AArch64ASIMDAssembler.ASIMDSize.FullReg.bytes() - this.stride.value);
            masm.neon.extVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp[1], vecArray1, vecArray2, AArch64ASIMDAssembler.ASIMDSize.FullReg.bytes() - this.stride.value);
            masm.neon.moveVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecLastArray2, vecArray2);
        }
        block0 : switch (this.variant) {
            case MatchAny: {
                int nValues = vecSearchValues.length;
                if (nValues == 1) {
                    masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecArray1, vecArray1, vecSearchValues[0]);
                    masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecArray2, vecArray2, vecSearchValues[0]);
                    break;
                }
                masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[0], vecArray1, vecSearchValues[0]);
                masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[1], vecArray2, vecSearchValues[0]);
                for (int i = 1; i < nValues; ++i) {
                    masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[2], vecArray1, vecSearchValues[i]);
                    masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[3], vecArray2, vecSearchValues[i]);
                    masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, i == nValues - 1 ? vecArray1 : vecTmp[0], vecTmp[0], vecTmp[2]);
                    masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, i == nValues - 1 ? vecArray2 : vecTmp[1], vecTmp[1], vecTmp[3]);
                }
                break;
            }
            case MatchRange: {
                masm.neon.cmhsVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[0], vecArray1, vecSearchValues[0]);
                masm.neon.cmhsVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[1], vecArray2, vecSearchValues[0]);
                masm.neon.cmhsVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[2], vecSearchValues[1], vecArray1);
                masm.neon.cmhsVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[3], vecSearchValues[1], vecArray2);
                if (this.searchValues.length == 4) {
                    masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp[0], vecTmp[0], vecTmp[2]);
                    masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp[1], vecTmp[1], vecTmp[3]);
                    masm.neon.cmhsVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[2], vecArray1, vecSearchValues[2]);
                    masm.neon.cmhsVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[3], vecArray2, vecSearchValues[2]);
                    masm.neon.cmhsVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecArray1, vecSearchValues[3], vecArray1);
                    masm.neon.cmhsVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecArray2, vecSearchValues[3], vecArray2);
                    masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp[2], vecTmp[2], vecArray1);
                    masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp[3], vecTmp[3], vecArray2);
                    masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray1, vecTmp[0], vecTmp[2]);
                    masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray2, vecTmp[1], vecTmp[3]);
                    break;
                }
                masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray1, vecTmp[0], vecTmp[2]);
                masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray2, vecTmp[1], vecTmp[3]);
                break;
            }
            case WithMask: {
                masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray1, vecArray1, vecSearchValues[1]);
                masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray2, vecArray2, vecSearchValues[1]);
                masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecArray1, vecArray1, vecSearchValues[0]);
                masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecArray2, vecArray2, vecSearchValues[0]);
                break;
            }
            case FindTwoConsecutive: {
                masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[0], vecTmp[0], vecSearchValues[0]);
                masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[1], vecTmp[1], vecSearchValues[0]);
                masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecArray1, vecArray1, vecSearchValues[1]);
                masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecArray2, vecArray2, vecSearchValues[1]);
                masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray1, vecArray1, vecTmp[0]);
                masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray2, vecArray2, vecTmp[1]);
                break;
            }
            case FindTwoConsecutiveWithMask: {
                masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp[0], vecTmp[0], vecSearchValues[2]);
                masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp[1], vecTmp[1], vecSearchValues[2]);
                masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray1, vecArray1, vecSearchValues[3]);
                masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray2, vecArray2, vecSearchValues[3]);
                masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[0], vecTmp[0], vecSearchValues[0]);
                masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecTmp[1], vecTmp[1], vecSearchValues[0]);
                masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecArray1, vecArray1, vecSearchValues[1]);
                masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, vecArray2, vecArray2, vecSearchValues[1]);
                masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray1, vecArray1, vecTmp[0]);
                masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray2, vecArray2, vecTmp[1]);
                break;
            }
            case Table: {
                switch (this.stride) {
                    case S1: {
                        masm.fldp(128, vecArray1, vecArray2, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, array, 32));
                        AArch64ArrayIndexOfOp.performTableLookup(masm, vecMask0x0f, vecTableHi, vecTableLo, vecArray1, vecArray2, vecTmp[0], vecTmp[1]);
                        break block0;
                    }
                    case S2: {
                        masm.neon.ld2MultipleVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecArray1, vecTmp[0], AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD2_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, array, 32));
                        masm.neon.ld2MultipleVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecArray2, vecTmp[1], AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD2_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, array, 32));
                        masm.neon.moveVI(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecTmp[2], 0L);
                        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecTmp[0], vecTmp[0], vecTmp[2]);
                        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecTmp[1], vecTmp[1], vecTmp[2]);
                        AArch64ArrayIndexOfOp.performTableLookup(masm, vecMask0x0f, vecTableHi, vecTableLo, vecArray1, vecArray2, vecTmp[2], vecTmp[3]);
                        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray1, vecArray1, vecTmp[0]);
                        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray2, vecArray2, vecTmp[1]);
                        break block0;
                    }
                    case S4: {
                        masm.neon.ld4MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecArray1, vecTmp[0], vecTmp[1], vecTmp[2], AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD4_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, array, 64));
                        masm.neon.ld4MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecArray2, vecTmp[3], vecTmp[4], vecTmp[5], AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD4_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, array, 64));
                        masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp[0], vecTmp[0], vecTmp[1]);
                        masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp[3], vecTmp[3], vecTmp[4]);
                        masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp[0], vecTmp[0], vecTmp[2]);
                        masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp[1], vecTmp[3], vecTmp[5]);
                        masm.neon.moveVI(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecTmp[2], 0L);
                        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecTmp[0], vecTmp[0], vecTmp[2]);
                        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecTmp[1], vecTmp[1], vecTmp[2]);
                        AArch64ArrayIndexOfOp.performTableLookup(masm, vecMask0x0f, vecTableHi, vecTableLo, vecArray1, vecArray2, vecTmp[2], vecTmp[3]);
                        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray1, vecArray1, vecTmp[0]);
                        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray2, vecArray2, vecTmp[1]);
                        break block0;
                    }
                }
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.stride);
            }
        }
        masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp[0], vecArray1, vecArray2);
        AArch64ArrayIndexOfOp.vectorCheckZero(masm, AArch64ASIMDAssembler.ElementSize.fromStride(this.getMatchResultStride()), vecTmp[0], vecTmp[0], this.variant != LIRGeneratorTool.ArrayIndexOfVariant.Table);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, matchInChunk);
    }

    private Stride getMatchResultStride() {
        return this.variant == LIRGeneratorTool.ArrayIndexOfVariant.Table ? Stride.S1 : this.stride;
    }

    private int getSIMDLoopChunkSize() {
        return this.variant == LIRGeneratorTool.ArrayIndexOfVariant.Table ? 32 * this.stride.value : 32;
    }

    private static void performTableLookup(AArch64MacroAssembler masm, Register vecMask0xf, Register vecTableHi, Register vecTableLo, Register vecArray1, Register vecArray2, Register vecTmp1, Register vecTmp2) {
        masm.neon.ushrVVI(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecTmp1, vecArray1, 4);
        masm.neon.ushrVVI(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vecTmp2, vecArray2, 4);
        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray1, vecArray1, vecMask0xf);
        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray2, vecArray2, vecMask0xf);
        masm.neon.tblVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp1, vecTableHi, vecTmp1);
        masm.neon.tblVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecTmp2, vecTableHi, vecTmp2);
        masm.neon.tblVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray1, vecTableLo, vecArray1);
        masm.neon.tblVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray2, vecTableLo, vecArray2);
        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray1, vecArray1, vecTmp1);
        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vecArray2, vecArray2, vecTmp2);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register arrayLength = ValueUtil.asRegister((Value)this.arrayLengthValue);
        Register fromIndex = ValueUtil.asRegister((Value)this.fromIndexValue);
        Register baseAddress = ValueUtil.asRegister((Value)this.temp[0]);
        Register searchLength = ValueUtil.asRegister((Value)this.temp[1]);
        Label done = new Label();
        masm.mov(result, -1);
        masm.cbz(32, arrayLength, done);
        masm.add(64, baseAddress, ValueUtil.asRegister((Value)this.arrayPtrValue), ValueUtil.asRegister((Value)this.arrayOffsetValue));
        masm.sub(32, searchLength, arrayLength, fromIndex);
        if (this.findTwoConsecutive) {
            masm.sub(32, searchLength, searchLength, 1);
        }
        Label searchByChunk = new Label();
        int chunkByteSize = this.getSIMDLoopChunkSize();
        masm.compare(32, searchLength, chunkByteSize / this.stride.value);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.GE, searchByChunk);
        this.emitScalarCode(masm, baseAddress, searchLength);
        masm.jmp(done);
        masm.bind(searchByChunk);
        this.emitSIMDCode(masm, baseAddress);
        masm.bind(done);
    }
}

