/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerator;

public class AArch64Compare {
    private static Condition getASIMDFloatCompareCondition(Condition condition, boolean unorderedIsTrue) {
        return unorderedIsTrue ? condition.negate() : condition;
    }

    public static AArch64LIRInstruction generateASIMDFloatCompare(LIRGenerator gen, Condition condition, AllocatableValue result, AllocatableValue x, AllocatableValue y, boolean unorderedIsTrue) {
        Condition testCondition = AArch64Compare.getASIMDFloatCompareCondition(condition, unorderedIsTrue);
        if (testCondition == Condition.NE) {
            return new ASIMDFloatCompareNEOp(gen, condition, result, x, y, unorderedIsTrue);
        }
        return new ASIMDFloatCompareOp(condition, result, x, y, unorderedIsTrue);
    }

    private static class ASIMDFloatCompareNEOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<ASIMDFloatCompareNEOp> TYPE = LIRInstructionClass.create(ASIMDFloatCompareNEOp.class);
        @Opcode
        protected final Condition condition;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue y;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue[] temps;
        private final boolean unorderedIsTrue;

        ASIMDFloatCompareNEOp(LIRGenerator gen, Condition condition, AllocatableValue result, AllocatableValue x, AllocatableValue y, boolean unorderedIsTrue) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (x.getPlatformKind() == y.getPlatformKind()) : x.getPlatformKind() + " " + y.getPlatformKind();
            Condition testCondition = AArch64Compare.getASIMDFloatCompareCondition(condition, unorderedIsTrue);
            assert (testCondition == Condition.NE);
            this.condition = condition;
            this.result = result;
            this.x = x;
            this.y = y;
            this.temps = new AllocatableValue[2];
            this.temps[0] = gen.newVariable(result.getValueKind());
            this.temps[1] = gen.newVariable(result.getValueKind());
            this.unorderedIsTrue = unorderedIsTrue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register left = ValueUtil.asRegister((Value)this.x);
            Register right = ValueUtil.asRegister((Value)this.y);
            Register cmp1 = ValueUtil.asRegister((Value)this.temps[0]);
            Register cmp2 = ValueUtil.asRegister((Value)this.temps[1]);
            masm.neon.fcmgtVVV(size, eSize, cmp1, left, right);
            masm.neon.fcmgtVVV(size, eSize, cmp2, right, left);
            masm.neon.orrVVV(size, dst, cmp1, cmp2);
            if (this.unorderedIsTrue) {
                masm.neon.mvnVV(size, dst, dst);
            }
        }
    }

    private static class ASIMDFloatCompareOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<ASIMDFloatCompareOp> TYPE = LIRInstructionClass.create(ASIMDFloatCompareOp.class);
        @Opcode
        private final Condition condition;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue y;
        private final boolean unorderedIsTrue;

        ASIMDFloatCompareOp(Condition condition, AllocatableValue result, AllocatableValue x, AllocatableValue y, boolean unorderedIsTrue) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (x.getPlatformKind() == y.getPlatformKind()) : x.getPlatformKind() + " " + y.getPlatformKind();
            this.condition = condition;
            this.result = result;
            this.x = x;
            this.y = y;
            this.unorderedIsTrue = unorderedIsTrue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register left = ValueUtil.asRegister((Value)this.x);
            Register right = ValueUtil.asRegister((Value)this.y);
            Condition testCondition = AArch64Compare.getASIMDFloatCompareCondition(this.condition, this.unorderedIsTrue);
            switch (testCondition) {
                case EQ: {
                    masm.neon.fcmeqVVV(size, eSize, dst, left, right);
                    break;
                }
                case LT: {
                    masm.neon.fcmgtVVV(size, eSize, dst, right, left);
                    break;
                }
                case LE: {
                    masm.neon.fcmgeVVV(size, eSize, dst, right, left);
                    break;
                }
                case GT: {
                    masm.neon.fcmgtVVV(size, eSize, dst, left, right);
                    break;
                }
                case GE: {
                    masm.neon.fcmgeVVV(size, eSize, dst, left, right);
                    break;
                }
                case AE: {
                    masm.neon.facgeVVV(size, eSize, dst, left, right);
                    break;
                }
                case BE: {
                    masm.neon.facgeVVV(size, eSize, dst, right, left);
                    break;
                }
                case AT: {
                    masm.neon.facgtVVV(size, eSize, dst, left, right);
                    break;
                }
                case BT: {
                    masm.neon.facgtVVV(size, eSize, dst, right, left);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHereUnexpectedValue((Object)testCondition);
                }
            }
            if (this.unorderedIsTrue) {
                masm.neon.mvnVV(size, dst, dst);
            }
        }
    }

    public static class ASIMDFloatCompareZeroOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<ASIMDFloatCompareZeroOp> TYPE = LIRInstructionClass.create(ASIMDFloatCompareZeroOp.class);
        @Opcode
        private final Condition condition;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        private final boolean unorderedIsTrue;

        public ASIMDFloatCompareZeroOp(Condition condition, AllocatableValue result, AllocatableValue x, boolean unorderedIsTrue) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.condition = condition;
            this.result = result;
            this.x = x;
            this.unorderedIsTrue = unorderedIsTrue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src = ValueUtil.asRegister((Value)this.x);
            Condition testCondition = AArch64Compare.getASIMDFloatCompareCondition(this.condition, this.unorderedIsTrue);
            switch (testCondition) {
                case EQ: {
                    masm.neon.fcmeqZeroVV(size, eSize, dst, src);
                    break;
                }
                case NE: {
                    masm.neon.fabsVV(size, eSize, dst, src);
                    masm.neon.fcmgtZeroVV(size, eSize, dst, dst);
                    break;
                }
                case LT: {
                    masm.neon.fcmltZeroVV(size, eSize, dst, src);
                    break;
                }
                case LE: {
                    masm.neon.fcmleZeroVV(size, eSize, dst, src);
                    break;
                }
                case GT: {
                    masm.neon.fcmgtZeroVV(size, eSize, dst, src);
                    break;
                }
                case GE: {
                    masm.neon.fcmgeZeroVV(size, eSize, dst, src);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHereUnexpectedValue((Object)testCondition);
                }
            }
            if (this.unorderedIsTrue) {
                masm.neon.mvnVV(size, dst, dst);
            }
        }
    }

    public static class ASIMDCompareZeroOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<ASIMDCompareZeroOp> TYPE = LIRInstructionClass.create(ASIMDCompareZeroOp.class);
        @Opcode
        private final Condition condition;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;

        public ASIMDCompareZeroOp(Condition condition, AllocatableValue result, AllocatableValue x) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.condition = condition;
            this.result = result;
            this.x = x;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src = ValueUtil.asRegister((Value)this.x);
            switch (this.condition) {
                case EQ: {
                    masm.neon.cmeqZeroVV(size, eSize, dst, src);
                    break;
                }
                case NE: {
                    masm.neon.cmeqZeroVV(size, eSize, dst, src);
                    masm.neon.mvnVV(size, dst, dst);
                    break;
                }
                case LT: {
                    masm.neon.cmltZeroVV(size, eSize, dst, src);
                    break;
                }
                case LE: {
                    masm.neon.cmleZeroVV(size, eSize, dst, src);
                    break;
                }
                case GT: {
                    masm.neon.cmgtZeroVV(size, eSize, dst, src);
                    break;
                }
                case GE: {
                    masm.neon.cmgeZeroVV(size, eSize, dst, src);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.condition);
                }
            }
        }
    }

    public static class ASIMDCompareOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<ASIMDCompareOp> TYPE = LIRInstructionClass.create(ASIMDCompareOp.class);
        @Opcode
        private final Condition condition;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue y;

        public ASIMDCompareOp(Condition condition, AllocatableValue result, AllocatableValue x, AllocatableValue y) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (x.getPlatformKind() == y.getPlatformKind()) : x.getPlatformKind() + " " + y.getPlatformKind();
            this.condition = condition;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register left = ValueUtil.asRegister((Value)this.x);
            Register right = ValueUtil.asRegister((Value)this.y);
            switch (this.condition) {
                case EQ: {
                    masm.neon.cmeqVVV(size, eSize, dst, left, right);
                    break;
                }
                case NE: {
                    masm.neon.cmeqVVV(size, eSize, dst, left, right);
                    masm.neon.mvnVV(size, dst, dst);
                    break;
                }
                case LT: {
                    masm.neon.cmgtVVV(size, eSize, dst, right, left);
                    break;
                }
                case LE: {
                    masm.neon.cmgeVVV(size, eSize, dst, right, left);
                    break;
                }
                case GT: {
                    masm.neon.cmgtVVV(size, eSize, dst, left, right);
                    break;
                }
                case GE: {
                    masm.neon.cmgeVVV(size, eSize, dst, left, right);
                    break;
                }
                case AE: {
                    masm.neon.cmhsVVV(size, eSize, dst, left, right);
                    break;
                }
                case BE: {
                    masm.neon.cmhsVVV(size, eSize, dst, right, left);
                    break;
                }
                case AT: {
                    masm.neon.cmhiVVV(size, eSize, dst, left, right);
                    break;
                }
                case BT: {
                    masm.neon.cmhiVVV(size, eSize, dst, right, left);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.condition);
                }
            }
        }
    }

    public static class FloatCompareOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<FloatCompareOp> TYPE = LIRInstructionClass.create(FloatCompareOp.class);
        @LIRInstruction.Use
        protected Value x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        protected Value y;
        private final Condition condition;
        private final boolean unorderedIsTrue;

        public FloatCompareOp(Value x, Value y, Condition condition, boolean unorderedIsTrue) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (!LIRValueUtil.isJavaConstant(y) || FloatCompareOp.isCompareConstant(y, condition, unorderedIsTrue));
            this.x = x;
            this.y = y;
            this.condition = condition;
            this.unorderedIsTrue = unorderedIsTrue;
        }

        private static boolean needsUnorderedFixup(Condition condition, boolean unorderedIsTrue) {
            return condition == Condition.EQ && unorderedIsTrue || condition == Condition.NE && !unorderedIsTrue;
        }

        public static boolean isCompareConstant(Value value, Condition condition, boolean unorderedIsTrue) {
            if (FloatCompareOp.needsUnorderedFixup(condition, unorderedIsTrue)) {
                return false;
            }
            return LIRValueUtil.isJavaConstant(value) && LIRValueUtil.asJavaConstant(value).isDefaultForKind();
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (ValueUtil.isRegister((Value)this.x));
            Register left = ValueUtil.asRegister((Value)this.x);
            int size = this.x.getPlatformKind().getSizeInBytes() * 8;
            boolean fixupUnorderedState = FloatCompareOp.needsUnorderedFixup(this.condition, this.unorderedIsTrue);
            if (ValueUtil.isRegister((Value)this.y)) {
                masm.fcmp(size, left, ValueUtil.asRegister((Value)this.y));
                if (fixupUnorderedState) {
                    int nzcv = 4;
                    masm.fccmp(size, left, ValueUtil.asRegister((Value)this.y), nzcv, AArch64Assembler.ConditionFlag.VC);
                }
            } else {
                assert (!fixupUnorderedState);
                masm.fcmpZero(size, left);
            }
        }

        @Override
        public void verify() {
            assert (this.x.getPlatformKind().equals(this.y.getPlatformKind())) : "a: " + this.x + " b: " + this.y;
        }
    }

    public static class CompareOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<CompareOp> TYPE = LIRInstructionClass.create(CompareOp.class);
        @LIRInstruction.Use
        protected Value x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        protected Value y;

        public CompareOp(Value x, Value y) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (x.getPlatformKind() == y.getPlatformKind()) : x.getPlatformKind() + " " + y.getPlatformKind();
            assert (!LIRValueUtil.isJavaConstant(y) || CompareOp.isCompareConstant(y));
            this.x = x;
            this.y = y;
        }

        public static boolean isCompareConstant(Value value) {
            if (LIRValueUtil.isJavaConstant(value)) {
                JavaConstant constant = LIRValueUtil.asJavaConstant(value);
                if (constant instanceof PrimitiveConstant) {
                    return AArch64MacroAssembler.isComparisonImmediate(constant.asLong());
                }
                return constant.isDefaultForKind();
            }
            return false;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int size = this.x.getPlatformKind().getSizeInBytes() * 8;
            if (ValueUtil.isRegister((Value)this.y)) {
                masm.cmp(size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
            } else {
                JavaConstant constant = LIRValueUtil.asJavaConstant(this.y);
                if (constant.isDefaultForKind()) {
                    masm.compare(size, ValueUtil.asRegister((Value)this.x), 0);
                } else {
                    JavaKind javaKind = constant.getJavaKind();
                    GraalError.guarantee(javaKind == JavaKind.Int || javaKind == JavaKind.Long, "Unexpected constant size.");
                    masm.compare(size, ValueUtil.asRegister((Value)this.x), NumUtil.safeToInt(constant.asLong()));
                }
            }
        }
    }
}

