/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.SyncPort;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.ArrayDataPointerConstant;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@SyncPort(from="https://github.com/openjdk/jdk/blob/d7b941640638b35f9ac1ef11cd6bf6ccb795c29a/src/hotspot/cpu/aarch64/stubGenerator_aarch64.cpp#L3591-L3680", sha1="64b4f4aa44a5201f87d28ee048721dcd3c3231ed")
public final class AArch64SHA1Op
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64SHA1Op> TYPE = LIRInstructionClass.create(AArch64SHA1Op.class);
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value bufValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value stateValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value limitValue;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value resultValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value bufTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] temps;
    private final boolean multiBlock;
    static ArrayDataPointerConstant keys = new ArrayDataPointerConstant(new int[]{1518500249, 1859775393, -1894007588, -899497514}, 16);

    public AArch64SHA1Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue) {
        this(tool, bufValue, stateValue, Value.ILLEGAL, Value.ILLEGAL, Value.ILLEGAL, false);
    }

    public AArch64SHA1Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue, AllocatableValue ofsValue, AllocatableValue limitValue, AllocatableValue resultValue, boolean multiBlock) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.bufValue = bufValue;
        this.stateValue = stateValue;
        this.ofsValue = ofsValue;
        this.limitValue = limitValue;
        this.resultValue = resultValue;
        this.multiBlock = multiBlock;
        if (multiBlock) {
            this.bufTempValue = tool.newVariable(bufValue.getValueKind());
            this.ofsTempValue = tool.newVariable(ofsValue.getValueKind());
        } else {
            this.bufTempValue = Value.ILLEGAL;
            this.ofsTempValue = Value.ILLEGAL;
        }
        this.temps = new Value[]{AArch64.v0.asValue(), AArch64.v1.asValue(), AArch64.v2.asValue(), AArch64.v3.asValue(), AArch64.v4.asValue(), AArch64.v5.asValue(), AArch64.v6.asValue(), AArch64.v7.asValue(), AArch64.v16.asValue(), AArch64.v17.asValue(), AArch64.v18.asValue(), AArch64.v19.asValue(), AArch64.v20.asValue(), AArch64.v21.asValue(), AArch64.v22.asValue()};
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register limit;
        Register ofs;
        Register buf;
        GraalError.guarantee(this.bufValue.getPlatformKind().equals(AArch64Kind.QWORD), "Invalid bufValue kind: %s", (Object)this.bufValue);
        GraalError.guarantee(this.stateValue.getPlatformKind().equals(AArch64Kind.QWORD), "Invalid stateValue kind: %s", (Object)this.stateValue);
        Register state = ValueUtil.asRegister((Value)this.stateValue);
        if (this.multiBlock) {
            GraalError.guarantee(this.ofsValue.getPlatformKind().equals(AArch64Kind.DWORD), "Invalid ofsValue kind: %s", (Object)this.ofsValue);
            GraalError.guarantee(this.limitValue.getPlatformKind().equals(AArch64Kind.DWORD), "Invalid limitValue kind: %s", (Object)this.limitValue);
            buf = ValueUtil.asRegister((Value)this.bufTempValue);
            ofs = ValueUtil.asRegister((Value)this.ofsTempValue);
            limit = ValueUtil.asRegister((Value)this.limitValue);
            masm.mov(64, buf, ValueUtil.asRegister((Value)this.bufValue));
            masm.mov(32, ofs, ValueUtil.asRegister((Value)this.ofsValue));
        } else {
            buf = ValueUtil.asRegister((Value)this.bufValue);
            ofs = Register.None;
            limit = Register.None;
        }
        try (AArch64MacroAssembler.ScratchRegister scratchReg = masm.getScratchRegister();){
            Register rscratch1 = scratchReg.getRegister();
            crb.recordDataReferenceInCode(keys);
            masm.adrpAdd(rscratch1);
            masm.neon.ld4rVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Word, AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64Address.createStructureNoOffsetAddress(rscratch1));
        }
        masm.fldr(128, AArch64.v6, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, state, 0));
        masm.fldr(32, AArch64.v7, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, state, 16));
        Label labelSHA1Loop = new Label();
        masm.bind(labelSHA1Loop);
        masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Word, AArch64.v16, AArch64.v17, AArch64.v18, AArch64.v19, this.multiBlock ? AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Word, buf, 64) : AArch64Address.createStructureNoOffsetAddress(buf));
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v16, AArch64.v16);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v17, AArch64.v17);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v18, AArch64.v18);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v19, AArch64.v19);
        masm.neon.addVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Word, AArch64.v4, AArch64.v16, AArch64.v0);
        masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v20, AArch64.v6, AArch64.v6);
        Register d0 = AArch64.v16;
        Register d1 = AArch64.v17;
        Register d2 = AArch64.v18;
        Register d3 = AArch64.v19;
        for (int round = 0; round < 20; ++round) {
            Register key;
            Register tmp4;
            Register tmp2;
            Register tmp1 = (round & 1) == 1 ? AArch64.v4 : AArch64.v5;
            Register register = tmp2 = (round & 1) == 1 ? AArch64.v21 : AArch64.v22;
            Register tmp3 = round != 0 ? ((round & 1) == 1 ? AArch64.v22 : AArch64.v21) : AArch64.v7;
            Register register2 = tmp4 = (round & 1) == 1 ? AArch64.v5 : AArch64.v4;
            Register register3 = round < 4 ? AArch64.v0 : (round < 9 ? AArch64.v1 : (key = round < 14 ? AArch64.v2 : AArch64.v3));
            if (round < 16) {
                masm.neon.sha1su0(d0, d1, d2);
            }
            if (round < 19) {
                masm.neon.addVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Word, tmp1, d1, key);
            }
            masm.neon.sha1h(tmp2, AArch64.v20);
            if (round < 5) {
                masm.neon.sha1c(AArch64.v20, tmp3, tmp4);
            } else if (round < 10 || round >= 15) {
                masm.neon.sha1p(AArch64.v20, tmp3, tmp4);
            } else {
                masm.neon.sha1m(AArch64.v20, tmp3, tmp4);
            }
            if (round < 16) {
                masm.neon.sha1su1(d0, d3);
            }
            tmp1 = d0;
            d0 = d1;
            d1 = d2;
            d2 = d3;
            d3 = tmp1;
        }
        masm.neon.addVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, AArch64ASIMDAssembler.ElementSize.Word, AArch64.v7, AArch64.v7, AArch64.v21);
        masm.neon.addVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Word, AArch64.v6, AArch64.v6, AArch64.v20);
        if (this.multiBlock) {
            masm.add(32, ofs, ofs, 64);
            masm.cmp(32, ofs, limit);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.LE, labelSHA1Loop);
            GraalError.guarantee(this.resultValue.getPlatformKind().equals(AArch64Kind.DWORD), "Invalid resultValue kind: %s", (Object)this.resultValue);
            masm.mov(32, ValueUtil.asRegister((Value)this.resultValue), ofs);
        }
        masm.fstr(128, AArch64.v6, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, state, 0));
        masm.fstr(32, AArch64.v7, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, state, 16));
    }
}

