/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import java.util.function.Consumer;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.SyncPort;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="SPIN_WAIT")
@SyncPort(from="https://github.com/openjdk/jdk/blob/d7b941640638b35f9ac1ef11cd6bf6ccb795c29a/src/hotspot/cpu/aarch64/vm_version_aarch64.cpp#L52-L68", sha1="92f81ed500658553a2ef2e7c48633094d95ba974")
public final class AArch64SpinWaitOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64SpinWaitOp> TYPE = LIRInstructionClass.create(AArch64SpinWaitOp.class);
    private final Consumer<AArch64MacroAssembler> instruction;
    private final int count;

    public AArch64SpinWaitOp(Consumer<AArch64MacroAssembler> instruction, int count) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.instruction = instruction;
        this.count = count;
        GraalError.guarantee(count > 0, "count should be positive");
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        for (int i = 0; i < this.count; ++i) {
            this.instruction.accept(masm);
        }
    }
}

