/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.SyncPort;
import org.graalvm.compiler.lir.amd64.AMD64AESEncryptOp;
import org.graalvm.compiler.lir.amd64.AMD64LIRHelper;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@SyncPort(from="https://github.com/openjdk/jdk/blob/d7b941640638b35f9ac1ef11cd6bf6ccb795c29a/src/hotspot/cpu/x86/stubGenerator_x86_64_aes.cpp#L1011-L1104", sha1="e87f6c5b4d86975678f423126a4c79c1e31b6833")
public final class AMD64AESDecryptOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64AESDecryptOp> TYPE = LIRInstructionClass.create(AMD64AESDecryptOp.class);
    private final int lengthOffset;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value fromValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value toValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value keyValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value keyLenValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value xmmResultValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value xmmKeyShufMaskValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value xmmTempValue1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value xmmTempValue2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value xmmTempValue3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value xmmTempValue4;

    public AMD64AESDecryptOp(LIRGeneratorTool tool, Value fromValue, Value toValue, Value keyValue, int lengthOffset) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.fromValue = fromValue;
        this.toValue = toValue;
        this.keyValue = keyValue;
        this.lengthOffset = lengthOffset;
        this.keyLenValue = tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        LIRKind lirKind = LIRKind.value((PlatformKind)AMD64Kind.V128_BYTE);
        this.xmmResultValue = tool.newVariable(lirKind);
        this.xmmKeyShufMaskValue = tool.newVariable(lirKind);
        this.xmmTempValue1 = tool.newVariable(lirKind);
        this.xmmTempValue2 = tool.newVariable(lirKind);
        this.xmmTempValue3 = tool.newVariable(lirKind);
        this.xmmTempValue4 = tool.newVariable(lirKind);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        GraalError.guarantee(this.fromValue.getPlatformKind().equals(AMD64Kind.QWORD), "Invalid fromValue kind: %s", (Object)this.fromValue);
        GraalError.guarantee(this.toValue.getPlatformKind().equals(AMD64Kind.QWORD), "Invalid toValue kind: %s", (Object)this.toValue);
        GraalError.guarantee(this.keyValue.getPlatformKind().equals(AMD64Kind.QWORD), "Invalid keyValue kind: %s", (Object)this.keyValue);
        Label labelDoLast = new Label();
        Register from = ValueUtil.asRegister((Value)this.fromValue);
        Register to = ValueUtil.asRegister((Value)this.toValue);
        Register key = ValueUtil.asRegister((Value)this.keyValue);
        Register keylen = ValueUtil.asRegister((Value)this.keyLenValue);
        Register xmmResult = ValueUtil.asRegister((Value)this.xmmResultValue);
        Register xmmKeyShufMask = ValueUtil.asRegister((Value)this.xmmKeyShufMaskValue);
        Register xmmTemp1 = ValueUtil.asRegister((Value)this.xmmTempValue1);
        Register xmmTemp2 = ValueUtil.asRegister((Value)this.xmmTempValue2);
        Register xmmTemp3 = ValueUtil.asRegister((Value)this.xmmTempValue3);
        Register xmmTemp4 = ValueUtil.asRegister((Value)this.xmmTempValue4);
        masm.movl(keylen, new AMD64Address(key, this.lengthOffset));
        masm.movdqu(xmmKeyShufMask, AMD64LIRHelper.recordExternalAddress(crb, AMD64AESEncryptOp.keyShuffleMask));
        masm.movdqu(xmmResult, new AMD64Address(from, 0));
        AMD64AESEncryptOp.loadKey(masm, xmmTemp1, key, 16, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp2, key, 32, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp3, key, 48, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp4, key, 64, xmmKeyShufMask);
        masm.pxor(xmmResult, xmmTemp1);
        masm.aesdec(xmmResult, xmmTemp2);
        masm.aesdec(xmmResult, xmmTemp3);
        masm.aesdec(xmmResult, xmmTemp4);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp1, key, 80, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp2, key, 96, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp3, key, 112, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp4, key, 128, xmmKeyShufMask);
        masm.aesdec(xmmResult, xmmTemp1);
        masm.aesdec(xmmResult, xmmTemp2);
        masm.aesdec(xmmResult, xmmTemp3);
        masm.aesdec(xmmResult, xmmTemp4);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp1, key, 144, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp2, key, 160, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp3, key, 0, xmmKeyShufMask);
        masm.cmplAndJcc(keylen, 44, AMD64Assembler.ConditionFlag.Equal, labelDoLast, true);
        masm.aesdec(xmmResult, xmmTemp1);
        masm.aesdec(xmmResult, xmmTemp2);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp1, key, 176, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp2, key, 192, xmmKeyShufMask);
        masm.cmplAndJcc(keylen, 52, AMD64Assembler.ConditionFlag.Equal, labelDoLast, true);
        masm.aesdec(xmmResult, xmmTemp1);
        masm.aesdec(xmmResult, xmmTemp2);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp1, key, 208, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp2, key, 224, xmmKeyShufMask);
        masm.bind(labelDoLast);
        masm.aesdec(xmmResult, xmmTemp1);
        masm.aesdec(xmmResult, xmmTemp2);
        masm.aesdeclast(xmmResult, xmmTemp3);
        masm.movdqu(new AMD64Address(to), xmmResult);
    }
}

