/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.DiagnosticLIRGeneratorTool;

public class AMD64Call {
    private static final int INLINE_CACHE_MOV_SIZE = 10;

    public static int directCall(CompilationResultBuilder crb, AMD64MacroAssembler masm, InvokeTarget callTarget, Register scratch, boolean align, LIRFrameState info) {
        int callPosition;
        AMD64MacroAssembler.PostCallAction afterCall = (before, after) -> {
            Call call = crb.recordDirectCall(before, after, callTarget, info);
            if (align) {
                AMD64Call.checkCallDisplacementAlignment(crb, before, call);
            }
            crb.recordExceptionHandlers(after, info);
            if (masm.position() == after) {
                masm.postCallNop((Infopoint)call);
            }
        };
        if (scratch != null) {
            if (align) {
                throw new GraalError("register call has no immediate displacement operand to be aligned");
            }
            callPosition = masm.directCall(afterCall, 0L, scratch, callTarget);
        } else {
            masm.alignBeforeCall(align, 0);
            callPosition = masm.call(afterCall, callTarget);
        }
        return callPosition;
    }

    public static void directInlineCacheCall(CompilationResultBuilder crb, AMD64MacroAssembler masm, InvokeTarget callTarget, CompilationResult.MarkId markId, long nonOopBits, LIRFrameState info) {
        masm.alignBeforeCall(true, 10);
        crb.recordMark(markId);
        int movPos = masm.position();
        masm.movq(AMD64.rax, nonOopBits);
        masm.call((before, after) -> {
            assert (movPos + 10 == before);
            Call call = crb.recordDirectCall(before, after, callTarget, info);
            AMD64Call.checkCallDisplacementAlignment(crb, before, call);
            crb.recordExceptionHandlers(after, info);
            if (masm.position() == after) {
                masm.postCallNop((Infopoint)call);
            }
        }, callTarget);
    }

    private static void checkCallDisplacementAlignment(CompilationResultBuilder crb, int before, Call call) throws GraalError {
        int opcode = crb.asm.getByte(call.pcOffset);
        if (opcode != 232) {
            throw new GraalError("unexpected opcode 0x%x at offset %d: %s", opcode, before, call);
        }
        int callDisplacement = call.pcOffset + 1;
        if (callDisplacement % 4 != 0) {
            throw new GraalError("displacement for call at offset %d is not 4-byte aligned: %s", call.pcOffset, call);
        }
    }

    public static void directJmp(CompilationResultBuilder crb, AMD64MacroAssembler masm, ForeignCallLinkage target, Register scratch) {
        int before = scratch != null ? masm.directJmp(0L, scratch) : masm.jmp(0, true);
        crb.recordDirectCall(before, masm.position(), target, null);
    }

    public static int indirectCall(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register dst, InvokeTarget callTarget, LIRFrameState info) {
        return AMD64Call.indirectCall(crb, masm, dst, callTarget, info, false);
    }

    public static int indirectCall(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register dst, InvokeTarget callTarget, LIRFrameState info, CallingConvention.Type callingConventionType) {
        return AMD64Call.indirectCall(crb, masm, dst, callTarget, info, false, callingConventionType);
    }

    public static int indirectCall(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register dst, InvokeTarget callTarget, LIRFrameState info, boolean mitigateDecodingAsDirectCall) {
        return AMD64Call.indirectCall(crb, masm, dst, callTarget, info, mitigateDecodingAsDirectCall, null);
    }

    public static int indirectCall(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register dst, InvokeTarget callTarget, LIRFrameState info, boolean mitigateDecodingAsDirectCall, CallingConvention.Type callingConventionType) {
        AMD64MacroAssembler.PostCallAction postCallAction = (before, after) -> {
            Call call = crb.recordIndirectCall(before, after, callTarget, info);
            crb.recordExceptionHandlers(after, info);
            if (masm.position() == after) {
                masm.postCallNop((Infopoint)call);
            }
        };
        return masm.indirectCall(postCallAction, dst, mitigateDecodingAsDirectCall, callTarget, callingConventionType);
    }

    @Opcode(value="FAR_FOREIGN_CALL")
    public static final class DirectFarForeignCallOp
    extends ForeignCallOp {
        public static final LIRInstructionClass<DirectFarForeignCallOp> TYPE = LIRInstructionClass.create(DirectFarForeignCallOp.class);
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue callTemp = AMD64.rax.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.QWORD));

        public DirectFarForeignCallOp(ForeignCallLinkage callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(TYPE, callTarget, result, parameters, temps, state);
            assert (LIRValueUtil.differentRegisters(parameters, this.callTemp));
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Call.directCall(crb, masm, this.callTarget, ((RegisterValue)this.callTemp).getRegister(), false, this.state);
        }
    }

    @Opcode(value="NEAR_FOREIGN_CALL")
    public static final class DirectNearForeignCallOp
    extends ForeignCallOp {
        public static final LIRInstructionClass<DirectNearForeignCallOp> TYPE = LIRInstructionClass.create(DirectNearForeignCallOp.class);

        public DirectNearForeignCallOp(ForeignCallLinkage linkage, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(TYPE, linkage, result, parameters, temps, state);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Call.directCall(crb, masm, this.callTarget, null, false, this.state);
        }
    }

    public static abstract class ForeignCallOp
    extends CallOp
    implements DiagnosticLIRGeneratorTool.ZapRegistersAfterInstruction {
        public static final LIRInstructionClass<ForeignCallOp> TYPE = LIRInstructionClass.create(ForeignCallOp.class);
        protected final ForeignCallLinkage callTarget;

        public ForeignCallOp(LIRInstructionClass<? extends ForeignCallOp> c, ForeignCallLinkage callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(c, result, parameters, temps, state);
            this.callTarget = callTarget;
        }

        @Override
        public boolean destroysCallerSavedRegisters() {
            return this.callTarget.destroysRegisters();
        }

        @Override
        public boolean needsClearUpperVectorRegisters() {
            return this.callTarget.needsClearUpperVectorRegisters();
        }
    }

    @Opcode(value="CALL_INDIRECT")
    public static class IndirectCallOp
    extends MethodCallOp {
        public static final LIRInstructionClass<IndirectCallOp> TYPE = LIRInstructionClass.create(IndirectCallOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected Value targetAddress;

        public IndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state) {
            this(TYPE, callTarget, result, parameters, temps, targetAddress, state);
        }

        protected IndirectCallOp(LIRInstructionClass<? extends IndirectCallOp> c, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state) {
            super(c, callTarget, result, parameters, temps, state);
            this.targetAddress = targetAddress;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Call.indirectCall(crb, masm, ValueUtil.asRegister((Value)this.targetAddress), (InvokeTarget)this.callTarget, this.state);
        }

        @Override
        public void verify() {
            super.verify();
            assert (ValueUtil.isRegister((Value)this.targetAddress)) : "The current register allocator cannot handle variables to be used at call sites, it must be in a fixed register for now";
        }
    }

    @Opcode(value="CALL_DIRECT")
    public static abstract class DirectCallOp
    extends MethodCallOp {
        public static final LIRInstructionClass<DirectCallOp> TYPE = LIRInstructionClass.create(DirectCallOp.class);

        protected DirectCallOp(LIRInstructionClass<? extends DirectCallOp> c, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(c, callTarget, result, parameters, temps, state);
        }
    }

    public static abstract class MethodCallOp
    extends CallOp {
        public static final LIRInstructionClass<MethodCallOp> TYPE = LIRInstructionClass.create(MethodCallOp.class);
        protected final ResolvedJavaMethod callTarget;

        protected MethodCallOp(LIRInstructionClass<? extends MethodCallOp> c, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(c, result, parameters, temps, state);
            this.callTarget = callTarget;
        }
    }

    public static abstract class CallOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<CallOp> TYPE = LIRInstructionClass.create(CallOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected Value result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected Value[] parameters;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected Value[] temps;
        @LIRInstruction.State
        protected LIRFrameState state;

        protected CallOp(LIRInstructionClass<? extends CallOp> c, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)c);
            this.result = result;
            this.parameters = parameters;
            this.state = state;
            this.temps = CallOp.addStackSlotsToTemporaries(parameters, temps);
            assert (temps != null);
        }

        @Override
        public boolean destroysCallerSavedRegisters() {
            return true;
        }
    }
}

