/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.constopt;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.constopt.UseEntry;

class DefUseTree {
    private final StandardOp.LoadConstantOp instruction;
    private final BasicBlock<?> block;
    private final List<UseEntry> uses;

    DefUseTree(LIRInstruction instruction, BasicBlock<?> block) {
        assert (StandardOp.LoadConstantOp.isLoadConstantOp(instruction)) : "Not a LoadConstantOp: " + instruction;
        this.instruction = StandardOp.LoadConstantOp.asLoadConstantOp(instruction);
        this.block = block;
        this.uses = new ArrayList<UseEntry>();
    }

    public Variable getVariable() {
        return LIRValueUtil.asVariable((Value)this.instruction.getResult());
    }

    public Constant getConstant() {
        return this.instruction.getConstant();
    }

    public LIRInstruction getInstruction() {
        return (LIRInstruction)((Object)this.instruction);
    }

    public BasicBlock<?> getBlock() {
        return this.block;
    }

    public String toString() {
        return "DefUseTree [" + this.instruction + "|" + this.block + "," + this.uses + "]";
    }

    public void addUsage(BasicBlock<?> b, LIRInstruction inst, Value value) {
        this.uses.add(new UseEntry(b, inst, value));
    }

    public int usageCount() {
        return this.uses.size();
    }

    public void forEach(Consumer<? super UseEntry> action) {
        this.uses.forEach(action);
    }
}

