/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.phases;

import java.util.regex.Pattern;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.MemUseTrackerKey;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.LIRPhaseSuite;
import org.graalvm.compiler.options.OptionKey;

public abstract class LIRPhase<C> {
    private final TimerKey timer;
    private final MemUseTrackerKey memUseTracker;
    public static final ClassValue<LIRPhaseStatistics> statisticsClassValue = new ClassValue<LIRPhaseStatistics>(){

        @Override
        protected LIRPhaseStatistics computeValue(Class<?> c) {
            return new LIRPhaseStatistics(c);
        }
    };

    public static LIRPhaseStatistics getLIRPhaseStatistics(Class<?> c) {
        return statisticsClassValue.get(c);
    }

    private static boolean checkName(CharSequence name) {
        assert (name == null || NamePatternHolder.NAME_PATTERN.matcher(name).matches()) : "illegal phase name: " + name;
        return true;
    }

    public LIRPhase() {
        LIRPhaseStatistics statistics = LIRPhase.getLIRPhaseStatistics(this.getClass());
        this.timer = statistics.timer;
        this.memUseTracker = statistics.memUseTracker;
    }

    public final void apply(TargetDescription target, LIRGenerationResult lirGenRes, C context) {
        this.apply(target, lirGenRes, context, true);
    }

    public final void apply(TargetDescription target, LIRGenerationResult lirGenRes, C context, boolean dumpLIR) {
        DebugContext debug = lirGenRes.getLIR().getDebug();
        CharSequence name = this.getName();
        try (DebugContext.Scope s = debug.scope((Object)name, this);
             DebugContext.CompilerPhaseScope cps = debug.enterCompilerPhase(name);
             DebugCloseable a = this.timer.start(debug);
             DebugCloseable c = this.memUseTracker.start(debug);){
            this.run(target, lirGenRes, context);
            if (dumpLIR && debug.areScopesEnabled()) {
                this.dumpAfter(lirGenRes);
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    private void dumpAfter(LIRGenerationResult lirGenRes) {
        DebugContext debug;
        boolean isStage = this instanceof LIRPhaseSuite;
        if (!isStage && (debug = lirGenRes.getLIR().getDebug()).isDumpEnabled(2)) {
            debug.dump(2, (Object)lirGenRes.getLIR(), "After %s", this.getName());
        }
    }

    protected abstract void run(TargetDescription var1, LIRGenerationResult var2, C var3);

    public static CharSequence createName(Class<?> clazz) {
        String className = clazz.getName();
        String s = className.substring(className.lastIndexOf(".") + 1);
        int innerClassPos = s.indexOf(36);
        if (innerClassPos > 0) {
            s = s.substring(0, innerClassPos);
        }
        if (s.endsWith("Phase")) {
            s = s.substring(0, s.length() - "Phase".length());
        }
        return s;
    }

    protected CharSequence createName() {
        return LIRPhase.createName(this.getClass());
    }

    public final CharSequence getName() {
        CharSequence name = this.createName();
        assert (LIRPhase.checkName(name));
        return name;
    }

    public static final class LIRPhaseStatistics {
        public final TimerKey timer;
        public final MemUseTrackerKey memUseTracker;

        public LIRPhaseStatistics(Class<?> clazz) {
            this.timer = DebugContext.timer("LIRPhaseTime_%s", clazz);
            this.memUseTracker = DebugContext.memUseTracker("LIRPhaseMemUse_%s", clazz);
        }
    }

    static class NamePatternHolder {
        static final Pattern NAME_PATTERN = Pattern.compile("[A-Z][A-Za-z0-9]+");

        NamePatternHolder() {
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> LIROptimization = new OptionKey<Boolean>(true);
    }
}

