/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.phases;

import org.graalvm.compiler.lir.phases.AllocationPhase;
import org.graalvm.compiler.lir.phases.FinalCodeAnalysisPhase;
import org.graalvm.compiler.lir.phases.LIRPhaseSuite;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;
import org.graalvm.compiler.lir.phases.PreAllocationOptimizationPhase;

public class LIRSuites {
    private final LIRPhaseSuite<PreAllocationOptimizationPhase.PreAllocationOptimizationContext> preAllocOptStage;
    private final LIRPhaseSuite<AllocationPhase.AllocationContext> allocStage;
    private final LIRPhaseSuite<PostAllocationOptimizationPhase.PostAllocationOptimizationContext> postAllocStage;
    private final LIRPhaseSuite<FinalCodeAnalysisPhase.FinalCodeAnalysisContext> finalCodeAnalysisStage;

    public LIRSuites(LIRPhaseSuite<PreAllocationOptimizationPhase.PreAllocationOptimizationContext> preAllocOptStage, LIRPhaseSuite<AllocationPhase.AllocationContext> allocStage, LIRPhaseSuite<PostAllocationOptimizationPhase.PostAllocationOptimizationContext> postAllocStage, LIRPhaseSuite<FinalCodeAnalysisPhase.FinalCodeAnalysisContext> finalCodeAnalysisStage) {
        this.preAllocOptStage = preAllocOptStage;
        this.allocStage = allocStage;
        this.postAllocStage = postAllocStage;
        this.finalCodeAnalysisStage = finalCodeAnalysisStage;
    }

    public LIRSuites(LIRSuites other) {
        this(other.getPreAllocationOptimizationStage().copy(), other.getAllocationStage().copy(), other.getPostAllocationOptimizationStage().copy(), other.getFinalCodeAnalysisStage().copy());
    }

    public LIRPhaseSuite<PreAllocationOptimizationPhase.PreAllocationOptimizationContext> getPreAllocationOptimizationStage() {
        return this.preAllocOptStage;
    }

    public LIRPhaseSuite<AllocationPhase.AllocationContext> getAllocationStage() {
        return this.allocStage;
    }

    public LIRPhaseSuite<PostAllocationOptimizationPhase.PostAllocationOptimizationContext> getPostAllocationOptimizationStage() {
        return this.postAllocStage;
    }

    public LIRPhaseSuite<FinalCodeAnalysisPhase.FinalCodeAnalysisContext> getFinalCodeAnalysisStage() {
        return this.finalCodeAnalysisStage;
    }

    public LIRSuites copy() {
        return new LIRSuites(this.preAllocOptStage.copy(), this.allocStage.copy(), this.postAllocStage.copy(), this.finalCodeAnalysisStage.copy());
    }
}

