/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.phases;

import org.graalvm.compiler.lir.ComputeCodeEmissionOrder;
import org.graalvm.compiler.lir.ControlFlowOptimizer;
import org.graalvm.compiler.lir.EdgeMoveOptimizer;
import org.graalvm.compiler.lir.NullCheckOptimizer;
import org.graalvm.compiler.lir.RedundantMoveElimination;
import org.graalvm.compiler.lir.phases.LIRPhase;
import org.graalvm.compiler.lir.phases.LIRPhaseSuite;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;
import org.graalvm.compiler.lir.profiling.MethodProfilingPhase;
import org.graalvm.compiler.lir.profiling.MoveProfilingPhase;
import org.graalvm.compiler.options.NestedBooleanOptionKey;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;

public class PostAllocationOptimizationStage
extends LIRPhaseSuite<PostAllocationOptimizationPhase.PostAllocationOptimizationContext> {
    public PostAllocationOptimizationStage(OptionValues options) {
        if (Options.LIROptEdgeMoveOptimizer.getValue(options).booleanValue()) {
            this.appendPhase(new EdgeMoveOptimizer());
        }
        if (Options.LIROptRedundantMoveElimination.getValue(options).booleanValue()) {
            this.appendPhase(new RedundantMoveElimination());
        }
        if (Options.LIROptNullCheckOptimizer.getValue(options).booleanValue()) {
            this.appendPhase(new NullCheckOptimizer());
        }
        if (Options.LIROptControlFlowOptimizer.getValue(options).booleanValue()) {
            this.appendPhase(new ControlFlowOptimizer());
        }
        if (Options.LIRProfileMoves.getValue(options).booleanValue()) {
            this.appendPhase(new MoveProfilingPhase());
        }
        if (Options.LIRProfileMethods.getValue(options).booleanValue()) {
            this.appendPhase(new MethodProfilingPhase());
        }
        if (!ComputeCodeEmissionOrder.Options.EarlyCodeEmissionOrder.getValue(options).booleanValue()) {
            this.appendPhase(new ComputeCodeEmissionOrder());
        }
    }

    public static class Options {
        public static final NestedBooleanOptionKey LIROptEdgeMoveOptimizer = new NestedBooleanOptionKey(LIRPhase.Options.LIROptimization, true);
        public static final NestedBooleanOptionKey LIROptControlFlowOptimizer = new NestedBooleanOptionKey(LIRPhase.Options.LIROptimization, true);
        public static final NestedBooleanOptionKey LIROptRedundantMoveElimination = new NestedBooleanOptionKey(LIRPhase.Options.LIROptimization, true);
        public static final NestedBooleanOptionKey LIROptNullCheckOptimizer = new NestedBooleanOptionKey(LIRPhase.Options.LIROptimization, true);
        public static final OptionKey<Boolean> LIRProfileMoves = new OptionKey<Boolean>(false);
        public static final OptionKey<Boolean> LIRProfileMethods = new OptionKey<Boolean>(false);
    }
}

