/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.profiling;

import java.util.ArrayList;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInsertionBuffer;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.gen.DiagnosticLIRGeneratorTool;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;

public class MethodProfilingPhase
extends PostAllocationOptimizationPhase {
    public static final String INVOCATION_GROUP = "METHOD_INVOCATION_COUNTER";
    public static final String ITERATION_GROUP = "METHOD_ITERATION_COUNTER";

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        new Analyzer(target, lirGenRes, context.diagnosticLirGenTool).run();
    }

    private static class Analyzer {
        private final LIR lir;
        private final DiagnosticLIRGeneratorTool diagnosticLirGenTool;
        private final LIRInsertionBuffer buffer;
        private final ConstantValue increment;
        private final LIRGenerationResult lirGenRes;

        Analyzer(TargetDescription target, LIRGenerationResult lirGenRes, DiagnosticLIRGeneratorTool diagnosticLirGenTool) {
            this.lir = lirGenRes.getLIR();
            this.lirGenRes = lirGenRes;
            this.diagnosticLirGenTool = diagnosticLirGenTool;
            this.buffer = new LIRInsertionBuffer();
            this.increment = new ConstantValue(LIRKind.fromJavaKind(target.arch, JavaKind.Int), (Constant)JavaConstant.INT_1);
        }

        public void run() {
            this.doBlock((BasicBlock<?>)this.lir.getControlFlowGraph().getStartBlock(), MethodProfilingPhase.INVOCATION_GROUP);
            for (BasicBlock block : this.lir.getControlFlowGraph().getBlocks()) {
                if (!block.isLoopHeader()) continue;
                this.doBlock(block, MethodProfilingPhase.ITERATION_GROUP);
            }
        }

        public void doBlock(BasicBlock<?> block, String group) {
            ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
            assert (instructions.size() >= 2) : "Malformed block: " + block + ", " + instructions;
            assert (instructions.get(instructions.size() - 1) instanceof StandardOp.BlockEndOp) : "Not a BlockEndOp: " + instructions.get(instructions.size() - 1);
            assert (!(instructions.get(instructions.size() - 2) instanceof StandardOp.BlockEndOp)) : "Is a BlockEndOp: " + instructions.get(instructions.size() - 2);
            assert (instructions.get(0) instanceof StandardOp.LabelOp) : "Not a LabelOp: " + instructions.get(0);
            assert (!(instructions.get(1) instanceof StandardOp.LabelOp)) : "Is a LabelOp: " + instructions.get(1);
            LIRInstruction op = this.diagnosticLirGenTool.createBenchmarkCounter(this.lirGenRes.getCompilationUnitName(), group, this.increment);
            this.buffer.init(instructions);
            int insertionIndex = this.lirGenRes.getFirstInsertPosition(block);
            this.buffer.append(insertionIndex, op);
            this.buffer.finish();
        }
    }
}

