/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.Map;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.spi.ArrayLengthProvider;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(nameTemplate="C({p#rawvalue}) {p#stampKind}", cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_1)
public final class ConstantNode
extends FloatingNode
implements LIRLowerable,
ArrayLengthProvider {
    public static final NodeClass<ConstantNode> TYPE = NodeClass.create(ConstantNode.class);
    protected final Constant value;
    private final int stableDimension;
    private final boolean isDefaultStable;

    private static ConstantNode createPrimitive(JavaConstant value) {
        assert (value.getJavaKind() != JavaKind.Object);
        return new ConstantNode((Constant)value, StampFactory.forConstant(value));
    }

    public ConstantNode(Constant value, Stamp stamp) {
        this(value, stamp, 0, false);
    }

    private ConstantNode(Constant value, Stamp stamp, int stableDimension, boolean isDefaultStable) {
        super((NodeClass<? extends FloatingNode>)TYPE, stamp);
        assert (stamp != null && stamp.isCompatible(value)) : stamp + " " + value;
        this.value = value;
        this.stableDimension = stableDimension;
        this.isDefaultStable = stableDimension == 0 ? false : isDefaultStable;
    }

    public Constant getValue() {
        return this.value;
    }

    public int getStableDimension() {
        return this.stableDimension;
    }

    public boolean isDefaultStable() {
        return this.isDefaultStable;
    }

    public static NodeIterable<ConstantNode> getConstantNodes(StructuredGraph graph) {
        return graph.getNodes().filter(ConstantNode.class);
    }

    public void replace(StructuredGraph graph, Node replacement) {
        assert (graph == this.graph());
        this.replaceAtUsagesAndDelete(replacement);
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        boolean needVariable;
        LIRGeneratorTool lirTool = gen.getLIRGeneratorTool();
        LIRKind kind = lirTool.getLIRKind(this.stamp(NodeView.DEFAULT));
        boolean bl = needVariable = kind.needsVariableInState() && this.usages().filter(VirtualState.class).isNotEmpty();
        if (!needVariable && this.onlyUsedInVirtualState()) {
            gen.setResult(this, new ConstantValue(kind, this.value));
        } else if (!needVariable && (lirTool.canInlineConstant(this.value) || lirTool.mayEmbedConstantLoad(this.value) && this.hasExactlyOneUsage() && this.onlyUsedInCurrentBlock())) {
            gen.setResult(this, new ConstantValue(lirTool.toRegisterKind(kind), this.value));
        } else {
            gen.setResult(this, gen.getLIRGeneratorTool().emitConstant(kind, this.value));
        }
    }

    private boolean onlyUsedInCurrentBlock() {
        assert (this.graph().getLastSchedule() != null);
        NodeMap<HIRBlock> nodeBlockMap = this.graph().getLastSchedule().getNodeToBlockMap();
        HIRBlock currentBlock = nodeBlockMap.get(this);
        for (Node usage : this.usages()) {
            if (currentBlock == nodeBlockMap.get(usage)) continue;
            return false;
        }
        return true;
    }

    private boolean onlyUsedInVirtualState() {
        for (Node n : this.usages()) {
            if (n instanceof VirtualState) continue;
            return false;
        }
        return true;
    }

    public static ConstantNode forConstant(JavaConstant constant, MetaAccessProvider metaAccess, StructuredGraph graph) {
        if (constant.getJavaKind().getStackKind() == JavaKind.Int && constant.getJavaKind() != JavaKind.Int) {
            return ConstantNode.forInt(constant.asInt(), graph);
        }
        if (constant.getJavaKind() == JavaKind.Object) {
            return ConstantNode.unique(graph, new ConstantNode((Constant)constant, StampFactory.forConstant(constant, metaAccess)));
        }
        return ConstantNode.unique(graph, ConstantNode.createPrimitive(constant));
    }

    public static ConstantNode forConstant(JavaConstant constant, int stableDimension, boolean isDefaultStable, MetaAccessProvider metaAccess) {
        if (constant.getJavaKind().getStackKind() == JavaKind.Int && constant.getJavaKind() != JavaKind.Int) {
            return ConstantNode.forInt(constant.asInt());
        }
        if (constant.getJavaKind() == JavaKind.Object) {
            return new ConstantNode((Constant)constant, StampFactory.forConstant(constant, metaAccess), stableDimension, isDefaultStable);
        }
        assert (stableDimension == 0);
        return ConstantNode.createPrimitive(constant);
    }

    public static ConstantNode forConstant(JavaConstant array, MetaAccessProvider metaAccess) {
        return ConstantNode.forConstant(array, 0, false, metaAccess);
    }

    public static ConstantNode forConstant(Stamp stamp, Constant constant, MetaAccessProvider metaAccess, StructuredGraph graph) {
        return graph.unique(new ConstantNode(constant, stamp.constant(constant, metaAccess)));
    }

    public static ConstantNode forConstant(Stamp stamp, Constant constant, int stableDimension, boolean isDefaultStable, MetaAccessProvider metaAccess) {
        return new ConstantNode(constant, stamp.constant(constant, metaAccess), stableDimension, isDefaultStable);
    }

    public static ConstantNode forConstant(Stamp stamp, Constant constant, MetaAccessProvider metaAccess) {
        return new ConstantNode(constant, stamp.constant(constant, metaAccess));
    }

    public static ConstantNode forPrimitive(JavaConstant constant, StructuredGraph graph) {
        assert (constant.getJavaKind() != JavaKind.Object);
        return ConstantNode.forConstant(constant, null, graph);
    }

    public static ConstantNode forPrimitive(JavaConstant constant) {
        assert (constant.getJavaKind() != JavaKind.Object);
        return ConstantNode.forConstant(constant, null);
    }

    public static ConstantNode forPrimitive(Stamp stamp, JavaConstant constant, StructuredGraph graph) {
        if (stamp instanceof IntegerStamp) {
            assert (constant.getJavaKind().isNumericInteger() && stamp.getStackKind() == constant.getJavaKind().getStackKind());
            IntegerStamp istamp = (IntegerStamp)stamp;
            return ConstantNode.forIntegerBits(istamp.getBits(), constant, graph);
        }
        assert (constant.getJavaKind().isNumericFloat() && stamp.getStackKind() == constant.getJavaKind());
        return ConstantNode.forPrimitive(constant, graph);
    }

    public static ConstantNode forPrimitive(Stamp stamp, Constant constant) {
        if (stamp instanceof IntegerStamp) {
            PrimitiveConstant primitive = (PrimitiveConstant)constant;
            assert (primitive.getJavaKind().isNumericInteger() && stamp.getStackKind() == primitive.getJavaKind().getStackKind());
            IntegerStamp istamp = (IntegerStamp)stamp;
            return ConstantNode.forIntegerBits(istamp.getBits(), (JavaConstant)primitive);
        }
        if (stamp instanceof FloatStamp) {
            PrimitiveConstant primitive = (PrimitiveConstant)constant;
            assert (primitive.getJavaKind().isNumericFloat() && stamp.getStackKind() == primitive.getJavaKind());
            return ConstantNode.forConstant((JavaConstant)primitive, null);
        }
        assert (!(stamp instanceof AbstractObjectStamp));
        return new ConstantNode(constant, stamp.constant(constant, null));
    }

    public static ConstantNode forDouble(double d, StructuredGraph graph) {
        return ConstantNode.unique(graph, ConstantNode.createPrimitive((JavaConstant)JavaConstant.forDouble((double)d)));
    }

    public static ConstantNode forDouble(double d) {
        return ConstantNode.createPrimitive((JavaConstant)JavaConstant.forDouble((double)d));
    }

    public static ConstantNode forFloat(float f, StructuredGraph graph) {
        return ConstantNode.unique(graph, ConstantNode.createPrimitive((JavaConstant)JavaConstant.forFloat((float)f)));
    }

    public static ConstantNode forFloat(float f) {
        return ConstantNode.createPrimitive((JavaConstant)JavaConstant.forFloat((float)f));
    }

    public static ConstantNode forLong(long i, StructuredGraph graph) {
        return ConstantNode.unique(graph, ConstantNode.createPrimitive((JavaConstant)JavaConstant.forLong((long)i)));
    }

    public static ConstantNode forLong(long i) {
        return ConstantNode.createPrimitive((JavaConstant)JavaConstant.forLong((long)i));
    }

    public static ConstantNode forInt(int i, StructuredGraph graph) {
        return ConstantNode.unique(graph, ConstantNode.createPrimitive((JavaConstant)JavaConstant.forInt((int)i)));
    }

    public static ConstantNode forInt(int i) {
        return ConstantNode.createPrimitive((JavaConstant)JavaConstant.forInt((int)i));
    }

    public static ConstantNode forBoolean(boolean i, StructuredGraph graph) {
        return ConstantNode.unique(graph, ConstantNode.createPrimitive((JavaConstant)JavaConstant.forInt((int)(i ? 1 : 0))));
    }

    public static ConstantNode forBoolean(boolean i) {
        return ConstantNode.createPrimitive((JavaConstant)JavaConstant.forInt((int)(i ? 1 : 0)));
    }

    public static ConstantNode forByte(byte i, StructuredGraph graph) {
        return ConstantNode.unique(graph, ConstantNode.createPrimitive((JavaConstant)JavaConstant.forInt((int)i)));
    }

    public static ConstantNode forChar(char i, StructuredGraph graph) {
        return ConstantNode.unique(graph, ConstantNode.createPrimitive((JavaConstant)JavaConstant.forInt((int)i)));
    }

    public static ConstantNode forShort(short i, StructuredGraph graph) {
        return ConstantNode.unique(graph, ConstantNode.createPrimitive((JavaConstant)JavaConstant.forInt((int)i)));
    }

    private static ConstantNode unique(StructuredGraph graph, ConstantNode node) {
        return graph.unique(node);
    }

    private static ConstantNode forIntegerBits(int bits, JavaConstant constant, StructuredGraph graph) {
        long value = constant.asLong();
        long bounds = CodeUtil.signExtend((long)value, (int)bits);
        return ConstantNode.unique(graph, new ConstantNode((Constant)constant, (Stamp)IntegerStamp.createConstant(bits, bounds)));
    }

    public static ConstantNode forIntegerBits(int bits, long value, StructuredGraph graph) {
        return ConstantNode.forIntegerBits(bits, (JavaConstant)JavaConstant.forPrimitiveInt((int)bits, (long)value), graph);
    }

    private static ConstantNode forIntegerBits(int bits, JavaConstant constant) {
        long value = constant.asLong();
        long bounds = CodeUtil.signExtend((long)value, (int)bits);
        return new ConstantNode((Constant)constant, (Stamp)IntegerStamp.createConstant(bits, bounds));
    }

    public static ConstantNode forIntegerBits(int bits, long value) {
        return ConstantNode.forIntegerBits(bits, (JavaConstant)JavaConstant.forPrimitiveInt((int)bits, (long)value));
    }

    public static ConstantNode forIntegerStamp(Stamp stamp, long value, StructuredGraph graph) {
        if (stamp instanceof IntegerStamp) {
            IntegerStamp intStamp = (IntegerStamp)stamp;
            return ConstantNode.forIntegerBits(intStamp.getBits(), value, graph);
        }
        return ConstantNode.forIntegerKind(stamp.getStackKind(), value, graph);
    }

    public static ConstantNode forIntegerStamp(Stamp stamp, long value) {
        if (stamp instanceof IntegerStamp) {
            IntegerStamp intStamp = (IntegerStamp)stamp;
            return ConstantNode.forIntegerBits(intStamp.getBits(), value);
        }
        return ConstantNode.forIntegerKind(stamp.getStackKind(), value);
    }

    public static ConstantNode forIntegerKind(JavaKind kind, long value, StructuredGraph graph) {
        switch (kind) {
            case Byte: 
            case Short: 
            case Int: {
                return ConstantNode.forInt((int)value, graph);
            }
            case Long: {
                return ConstantNode.forLong(value, graph);
            }
        }
        throw GraalError.shouldNotReachHere("unknown kind " + kind);
    }

    public static ConstantNode forIntegerKind(JavaKind kind, long value) {
        switch (kind) {
            case Byte: 
            case Short: 
            case Int: {
                return ConstantNode.createPrimitive((JavaConstant)JavaConstant.forInt((int)((int)value)));
            }
            case Long: {
                return ConstantNode.createPrimitive((JavaConstant)JavaConstant.forLong((long)value));
            }
        }
        throw GraalError.shouldNotReachHere("unknown kind " + kind);
    }

    public static ConstantNode forFloatingKind(JavaKind kind, double value, StructuredGraph graph) {
        switch (kind) {
            case Float: {
                return ConstantNode.forFloat((float)value, graph);
            }
            case Double: {
                return ConstantNode.forDouble(value, graph);
            }
        }
        throw GraalError.shouldNotReachHere("unknown kind " + kind);
    }

    public static ConstantNode defaultForKind(JavaKind kind, StructuredGraph graph) {
        return ConstantNode.unique(graph, ConstantNode.defaultForKind(kind));
    }

    public static ConstantNode defaultForKind(JavaKind kind) {
        switch (kind) {
            case Byte: 
            case Short: 
            case Int: 
            case Boolean: 
            case Char: {
                return ConstantNode.forInt(0);
            }
            case Double: {
                return ConstantNode.forDouble(0.0);
            }
            case Float: {
                return ConstantNode.forFloat(0.0f);
            }
            case Long: {
                return ConstantNode.forLong(0L);
            }
            case Object: {
                return ConstantNode.forConstant(JavaConstant.NULL_POINTER, null);
            }
        }
        return null;
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        Map<Object, Object> properties = super.getDebugProperties(map);
        properties.put("rawvalue", this.value.toValueString());
        properties.put("stampKind", this.stamp.unrestricted().toString());
        return properties;
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            String valueString = this.value == null ? "null" : this.value.toValueString();
            Stamp stampVal = this.stamp(NodeView.DEFAULT);
            stampVal = stampVal == null ? null : stampVal.unrestricted();
            String stampString = stampVal == null ? "null" : stampVal.toString();
            return super.toString(Verbosity.Name) + "(" + valueString + ", " + stampString + ")";
        }
        return super.toString(verbosity);
    }

    @Override
    public ValueNode findLength(ArrayLengthProvider.FindLengthMode mode, ConstantReflectionProvider constantReflection) {
        if (constantReflection == null || !(this.value instanceof JavaConstant) || ((JavaConstant)this.value).isNull()) {
            return null;
        }
        Integer length = constantReflection.readArrayLength((JavaConstant)this.value);
        if (length == null) {
            return null;
        }
        return ConstantNode.forInt(length);
    }
}

