/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;

class GraphComparison {
    GraphComparison() {
    }

    public static boolean verifyGraphsEqual(StructuredGraph expectedGraph, StructuredGraph actualGraph) {
        NodeMap<Node> nodeMapping = new NodeMap<Node>(expectedGraph);
        ArrayDeque<Pair<Node, Node>> workList = new ArrayDeque<Pair<Node, Node>>();
        assert (actualGraph.isRecordingInlinedMethods() == expectedGraph.isRecordingInlinedMethods());
        if (actualGraph.isRecordingInlinedMethods()) assert (expectedGraph.getMethods().equals(actualGraph.getMethods()));
        assert (actualGraph.allowAssumptions() == expectedGraph.allowAssumptions());
        if (actualGraph.getAssumptions() != null) assert (expectedGraph.getAssumptions().equals((Object)actualGraph.getAssumptions()));
        assert (expectedGraph.hasUnsafeAccess() == actualGraph.hasUnsafeAccess());
        GraphComparison.pushToWorklist(expectedGraph.start(), actualGraph.start(), nodeMapping, workList);
        while (!workList.isEmpty()) {
            Pair pair = (Pair)workList.removeFirst();
            Node expectedNode = (Node)pair.getLeft();
            Node actualNode = (Node)pair.getRight();
            assert (expectedNode.getClass() == actualNode.getClass());
            NodeClass<? extends Node> nodeClass = expectedNode.getNodeClass();
            assert (nodeClass == actualNode.getNodeClass());
            if (expectedNode instanceof MergeNode) {
                GraphComparison.verifyNodesEqual(expectedNode.inputs(), actualNode.inputs(), nodeMapping, workList, true);
            } else if (expectedNode instanceof PhiNode) {
                GraphComparison.verifyPhi((PhiNode)expectedNode, (PhiNode)actualNode, nodeMapping, workList);
            } else {
                GraphComparison.verifyNodesEqual(expectedNode.inputs(), actualNode.inputs(), nodeMapping, workList, false);
            }
            GraphComparison.verifyNodesEqual(expectedNode.successors(), actualNode.successors(), nodeMapping, workList, false);
            if (expectedNode instanceof LoopEndNode) {
                LoopEndNode actualLoopEnd = (LoopEndNode)actualNode;
                assert (actualLoopEnd.loopBegin().loopEnds().snapshot().indexOf(actualLoopEnd) == actualLoopEnd.endIndex());
            } else {
                for (int i = 0; i < nodeClass.getData().getCount(); ++i) {
                    Object expectedProperty = nodeClass.getData().get(expectedNode, i);
                    Object actualProperty = nodeClass.getData().get(actualNode, i);
                    assert (Objects.equals(expectedProperty, actualProperty));
                }
            }
            if (expectedNode instanceof EndNode) {
                assert (expectedNode.hasExactlyOneUsage());
                assert (actualNode.hasExactlyOneUsage());
                GraphComparison.verifyNodesEqual(expectedNode.usages(), actualNode.usages(), nodeMapping, workList, false);
            }
            if (!(expectedNode instanceof AbstractEndNode)) continue;
            GraphComparison.verifyPhis((AbstractEndNode)expectedNode, (AbstractEndNode)actualNode, nodeMapping, workList);
        }
        return true;
    }

    protected static void verifyPhi(PhiNode expectedPhi, PhiNode actualPhi, NodeMap<Node> nodeMapping, Deque<Pair<Node, Node>> workList) {
        AbstractMergeNode expectedMergeNode = expectedPhi.merge();
        AbstractMergeNode actualMergeNode = actualPhi.merge();
        assert (actualMergeNode == nodeMapping.get(expectedMergeNode));
        for (EndNode expectedEndNode : expectedMergeNode.ends) {
            EndNode actualEndNode = (EndNode)nodeMapping.get(expectedEndNode);
            if (actualEndNode == null) continue;
            ValueNode expectedPhiInput = expectedPhi.valueAt(expectedEndNode);
            ValueNode actualPhiInput = actualPhi.valueAt(actualEndNode);
            GraphComparison.verifyNodeEqual(expectedPhiInput, actualPhiInput, nodeMapping, workList, false);
        }
    }

    protected static void verifyPhis(AbstractEndNode expectedEndNode, AbstractEndNode actualEndNode, NodeMap<Node> nodeMapping, Deque<Pair<Node, Node>> workList) {
        AbstractMergeNode expectedMergeNode = expectedEndNode.merge();
        AbstractMergeNode actualMergeNode = (AbstractMergeNode)nodeMapping.get(expectedMergeNode);
        assert (actualMergeNode != null);
        for (PhiNode expectedPhi : expectedMergeNode.phis()) {
            PhiNode actualPhi = (PhiNode)nodeMapping.get(expectedPhi);
            if (actualPhi == null) continue;
            ValueNode expectedPhiInput = expectedPhi.valueAt(expectedEndNode);
            ValueNode actualPhiInput = actualPhi.valueAt(actualEndNode);
            GraphComparison.verifyNodeEqual(expectedPhiInput, actualPhiInput, nodeMapping, workList, false);
        }
    }

    private static void verifyNodesEqual(NodeIterable<Node> expectedNodes, NodeIterable<Node> actualNodes, NodeMap<Node> nodeMapping, Deque<Pair<Node, Node>> workList, boolean ignoreEndNode) {
        Iterator actualIter = actualNodes.iterator();
        for (Node expectedNode : expectedNodes) {
            GraphComparison.verifyNodeEqual(expectedNode, (Node)actualIter.next(), nodeMapping, workList, ignoreEndNode);
        }
        assert (!actualIter.hasNext());
    }

    protected static void verifyNodeEqual(Node expectedNode, Node actualNode, NodeMap<Node> nodeMapping, Deque<Pair<Node, Node>> workList, boolean ignoreEndNode) {
        assert (expectedNode.getClass() == actualNode.getClass());
        if (ignoreEndNode && expectedNode instanceof EndNode) {
            return;
        }
        Node existing = nodeMapping.get(expectedNode);
        if (existing != null) {
            assert (existing == actualNode);
        } else {
            GraphComparison.pushToWorklist(expectedNode, actualNode, nodeMapping, workList);
        }
    }

    protected static void pushToWorklist(Node expectedNode, Node actualNode, NodeMap<Node> nodeMapping, Deque<Pair<Node, Node>> workList) {
        nodeMapping.set(expectedNode, actualNode);
        if (expectedNode instanceof AbstractEndNode) {
            workList.addLast((Pair<Node, Node>)Pair.create((Object)expectedNode, (Object)actualNode));
        } else {
            workList.addFirst((Pair<Node, Node>)Pair.create((Object)expectedNode, (Object)actualNode));
        }
    }
}

